/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.internal.statistic.IdeActivity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DumbServiceMergingTaskQueue {
    private static final Logger LOG = Logger.getInstance(DumbServiceMergingTaskQueue.class);
    private final Object myLock = new Object();
    private final Map<Object, DumbModeTask> myTasksQueue = new LinkedHashMap<Object, DumbModeTask>();
    private final Map<DumbModeTask, ProgressIndicatorBase> myProgresses = new HashMap<DumbModeTask, ProgressIndicatorBase>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disposePendingTasks() {
        ArrayList<ProgressIndicatorEx> indicatorsQueue;
        ArrayList<DumbModeTask> disposeQueue;
        Object object = this.myLock;
        synchronized (object) {
            disposeQueue = new ArrayList<DumbModeTask>(this.myTasksQueue.values());
            indicatorsQueue = new ArrayList<ProgressIndicatorEx>(this.myProgresses.values());
            this.myTasksQueue.clear();
            this.myProgresses.clear();
        }
        DumbServiceMergingTaskQueue.cancelIndicatorSafe(indicatorsQueue);
        DumbServiceMergingTaskQueue.disposeSafe(disposeQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAllTasks() {
        ArrayList<ProgressIndicatorBase> tasks;
        Iterator iterator2 = this.myLock;
        synchronized (iterator2) {
            tasks = new ArrayList<ProgressIndicatorBase>(this.myProgresses.values());
        }
        for (ProgressIndicatorEx progressIndicatorEx : tasks) {
            progressIndicatorEx.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTask(@NotNull DumbModeTask task2) {
        ProgressIndicatorEx indicator;
        Object object = this.myLock;
        synchronized (object) {
            indicator = this.myProgresses.get(task2);
        }
        if (indicator != null) {
            indicator.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(@NotNull DumbModeTask task2) {
        DumbModeTask olderTask;
        Object object = this.myLock;
        synchronized (object) {
            Object key = task2.getEquivalenceObject();
            olderTask = this.myTasksQueue.remove(key);
            this.myTasksQueue.put(key, task2);
            ProgressIndicatorBase progress2 = new ProgressIndicatorBase();
            this.myProgresses.put(task2, progress2);
            Disposer.register((Disposable)task2, () -> {
                Object object = this.myLock;
                synchronized (object) {
                    this.myProgresses.remove(task2);
                }
                progress2.cancel();
            });
        }
        if (olderTask != null) {
            Disposer.dispose((Disposable)olderTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public QueuedDumbModeTask extractNextTask() {
        ArrayList<DumbModeTask> disposeQueue = new ArrayList<DumbModeTask>(1);
        try {
            Object object = this.myLock;
            synchronized (object) {
            }
        }
        catch (Throwable throwable) {
            DumbServiceMergingTaskQueue.disposeSafe(disposeQueue);
            throw throwable;
        }
        {
            while (true) {
                if (this.myTasksQueue.isEmpty()) {
                    QueuedDumbModeTask queuedDumbModeTask = null;
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 8] lbl12 : MonitorExitStatement: MONITOREXIT : var2_2
                    DumbServiceMergingTaskQueue.disposeSafe(disposeQueue);
                    return queuedDumbModeTask;
                }
                Object key = this.myTasksQueue.keySet().iterator().next();
                DumbModeTask task2 = this.myTasksQueue.remove(key);
                if (task2 == null) continue;
                ProgressIndicatorBase indicator = this.myProgresses.get(task2);
                if (indicator != null && !indicator.isCanceled()) {
                    QueuedDumbModeTask queuedDumbModeTask = new QueuedDumbModeTask(task2, indicator);
                    // MONITOREXIT @DISABLED, blocks:[4, 6, 7] lbl21 : MonitorExitStatement: MONITOREXIT : var2_2
                    DumbServiceMergingTaskQueue.disposeSafe(disposeQueue);
                    return queuedDumbModeTask;
                }
                disposeQueue.add(task2);
            }
        }
    }

    private static void disposeSafe(@NotNull Collection<DumbModeTask> tasks) {
        for (DumbModeTask task2 : tasks) {
            DumbServiceMergingTaskQueue.disposeSafe(task2);
        }
    }

    private static void disposeSafe(@NotNull DumbModeTask task2) {
        block3: {
            try {
                if (Disposer.isDisposed((Disposable)task2)) {
                    return;
                }
                Disposer.dispose((Disposable)task2);
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) break block3;
                LOG.warn("Failed to dispose DumbModeTask: " + t.getMessage(), t);
            }
        }
    }

    private static void cancelIndicatorSafe(@NotNull List<ProgressIndicatorEx> indicators) {
        for (ProgressIndicatorEx indicator : indicators) {
            DumbServiceMergingTaskQueue.cancelIndicatorSafe(indicator);
        }
    }

    private static void cancelIndicatorSafe(@NotNull ProgressIndicatorEx indicator) {
        block2: {
            try {
                indicator.cancel();
            }
            catch (Throwable t) {
                if (t instanceof ControlFlowException) break block2;
                LOG.warn("Failed to cancel DumbModeTask indicator: " + t.getMessage(), t);
            }
        }
    }

    static class QueuedDumbModeTask
    implements AutoCloseable {
        private final DumbModeTask myTask;
        private final ProgressIndicatorEx myIndicator;

        QueuedDumbModeTask(@NotNull DumbModeTask task2, @NotNull ProgressIndicatorEx progress2) {
            this.myTask = task2;
            this.myIndicator = progress2;
        }

        @Override
        public void close() {
            Disposer.dispose((Disposable)this.myTask);
        }

        @NotNull
        ProgressIndicatorEx getIndicator() {
            return this.myIndicator;
        }

        void executeTask() {
            this.executeTask(null);
        }

        void executeTask(@Nullable ProgressIndicator customIndicator) {
            this.myIndicator.checkCanceled();
            this.myIndicator.setIndeterminate(true);
            if (customIndicator == null) {
                customIndicator = this.myIndicator;
            } else {
                customIndicator.checkCanceled();
            }
            this.myTask.performInDumbMode(customIndicator);
        }

        void registerStageStarted(@NotNull IdeActivity activity) {
            activity.stageStarted(this.myTask.getClass());
        }

        String getInfoString() {
            return String.valueOf(this.myTask);
        }
    }
}

