/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackgroundTaskQueue {
    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected final String myTitle;
    @NotNull
    protected final QueueProcessor<TaskData> myProcessor;
    @NotNull
    private final Object TEST_TASK_LOCK = new Object();
    private volatile boolean myForceAsyncInTests;

    public BackgroundTaskQueue(@Nullable Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title) {
        this.myTitle = title;
        Condition disposeCondition = project != null ? project.getDisposed() : ApplicationManager.getApplication().getDisposed();
        this.myProcessor = new QueueProcessor(Consumer::consume, true, QueueProcessor.ThreadToUse.AWT, disposeCondition);
    }

    public void clear() {
        this.myProcessor.clear();
    }

    public boolean isEmpty() {
        return this.myProcessor.isEmpty();
    }

    public void waitForTasksToFinish() {
        this.myProcessor.waitFor();
    }

    public void run(@NotNull Task.Backgroundable task2) {
        this.run(task2, null, null);
    }

    public void run(@NotNull Task.Backgroundable task2, @Nullable ModalityState modalityState, @Nullable ProgressIndicator indicator) {
        BackgroundableTaskData taskData = new BackgroundableTaskData(task2, modalityState, indicator);
        if (!this.myForceAsyncInTests && ApplicationManager.getApplication().isUnitTestMode()) {
            this.runTaskInCurrentThread(taskData);
        } else {
            this.myProcessor.add((Object)taskData, modalityState);
        }
    }

    public void setForceAsyncInTests(boolean value2, @NotNull Disposable disposable2) {
        this.myForceAsyncInTests = value2;
        Disposer.register((Disposable)disposable2, () -> {
            this.myForceAsyncInTests = false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTaskInCurrentThread(@NotNull BackgroundableTaskData data2) {
        ModalityState modalityState;
        Task.Backgroundable task2 = data2.myTask;
        ProgressIndicator indicator = data2.myIndicator;
        if (indicator == null) {
            indicator = new EmptyProgressIndicator();
        }
        if ((modalityState = data2.myModalityState) == null) {
            modalityState = ModalityState.NON_MODAL;
        }
        ProgressManagerImpl pm = (ProgressManagerImpl)ProgressManager.getInstance();
        Object object = this.TEST_TASK_LOCK;
        synchronized (object) {
            pm.runProcessWithProgressInCurrentThread((Task)task2, indicator, modalityState);
        }
    }

    protected class BackgroundableTaskData
    implements TaskData {
        @NotNull
        private final Task.Backgroundable myTask;
        @Nullable
        private final ModalityState myModalityState;
        @Nullable
        private final ProgressIndicator myIndicator;

        BackgroundableTaskData(@Nullable Task.Backgroundable task2, @Nullable ModalityState modalityState, ProgressIndicator indicator) {
            this.myTask = task2;
            this.myModalityState = modalityState;
            this.myIndicator = indicator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void consume(@NotNull Runnable continuation) {
            ModalityState modalityState;
            Task.Backgroundable task2 = this.myTask;
            Project taskProject = task2.getProject();
            if (taskProject != null && taskProject.isDisposed()) {
                continuation.run();
                return;
            }
            Object indicator = this.myIndicator;
            if (indicator == null) {
                indicator = ApplicationManager.getApplication().isHeadlessEnvironment() ? new EmptyProgressIndicator() : new BackgroundableProcessIndicator(task2);
            }
            if ((modalityState = this.myModalityState) == null) {
                modalityState = ModalityState.NON_MODAL;
            }
            if (StringUtil.isEmptyOrSpaces((String)task2.getTitle())) {
                task2.setTitle(BackgroundTaskQueue.this.myTitle);
            }
            boolean synchronous = task2.isHeadless() && !CoreProgressManager.shouldRunHeadlessTasksSynchronously() && !BackgroundTaskQueue.this.myForceAsyncInTests || task2.isConditionalModal() && !task2.shouldStartInBackground();
            ProgressManagerImpl pm = (ProgressManagerImpl)ProgressManager.getInstance();
            if (synchronous) {
                try {
                    pm.runProcessWithProgressSynchronously((Task)task2, null);
                }
                finally {
                    continuation.run();
                }
            } else {
                pm.runProcessWithProgressAsynchronously(task2, (ProgressIndicator)indicator, continuation, modalityState);
            }
        }
    }

    @FunctionalInterface
    protected static interface TaskData
    extends Consumer<Runnable> {
    }
}

