/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.ide.BrowserUtil;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ContributedReferenceHost;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.FakePsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebReference
extends PsiReferenceBase<PsiElement> {
    @Nullable
    private final String myUrl;

    public WebReference(@NotNull PsiElement element2) {
        this(element2, (String)null);
    }

    public WebReference(@NotNull PsiElement element2, @Nullable String url) {
        super(element2, true);
        this.myUrl = url;
    }

    public WebReference(@NotNull PsiElement element2, @NotNull TextRange textRange) {
        this(element2, textRange, null);
    }

    public WebReference(@NotNull PsiElement element2, TextRange textRange, @Nullable String url) {
        super(element2, textRange, true);
        this.myUrl = url;
    }

    public PsiElement resolve() {
        return new MyFakePsiElement();
    }

    public String getUrl() {
        return this.myUrl != null ? this.myUrl : this.getValue();
    }

    public static boolean isWebReferenceWorthy(@NotNull PsiElement element2) {
        return element2 instanceof HintedReferenceHost || element2 instanceof ContributedReferenceHost || element2 instanceof PsiExternalReferenceHost;
    }

    class MyFakePsiElement
    extends FakePsiElement
    implements SyntheticElement {
        MyFakePsiElement() {
        }

        public PsiElement getParent() {
            return WebReference.this.myElement;
        }

        @Override
        public void navigate(boolean requestFocus) {
            BrowserUtil.browse((String)WebReference.this.getUrl());
        }

        @Override
        public String getPresentableText() {
            return WebReference.this.getUrl();
        }

        @Override
        public String getName() {
            return WebReference.this.getUrl();
        }

        @Override
        public TextRange getTextRange() {
            TextRange rangeInElement = WebReference.this.getRangeInElement();
            TextRange elementRange = WebReference.this.myElement.getTextRange();
            return elementRange != null ? rangeInElement.shiftRight(elementRange.getStartOffset()) : rangeInElement;
        }
    }
}

