/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.util.Function;
import com.intellij.util.io.URLUtil;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalPathReferenceProvider
implements PathReferenceProvider {
    @NonNls
    private static final String[] PREFIXES = new String[]{"tel:", "sms:", "skype:", "data:", "xmpp:"};

    public static boolean startsWithAllowedPrefix(String s) {
        for (String prefix : PREFIXES) {
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean createReferences(@NotNull PsiElement psiElement, @NotNull List<PsiReference> references, boolean soft) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)psiElement);
        if (manipulator == null) {
            return false;
        }
        return this.createUrlReference(psiElement, manipulator.getRangeInElement(psiElement).substring(psiElement.getText()), manipulator.getRangeInElement(psiElement), references);
    }

    public boolean createUrlReference(@NotNull PsiElement psiElement, String url, TextRange rangeInElement, @NotNull List<? super PsiReference> references) {
        if (GlobalPathReferenceProvider.isWebReferenceUrl(url)) {
            references.add((PsiReference)new WebReference(psiElement, rangeInElement, url));
            return true;
        }
        if (url.contains("://") || url.startsWith("//") || GlobalPathReferenceProvider.startsWithAllowedPrefix(url)) {
            references.add((PsiReference)PsiReferenceBase.createSelfReference((PsiElement)psiElement, (TextRange)rangeInElement, (PsiElement)psiElement));
            return true;
        }
        return false;
    }

    public static boolean isWebReferenceUrl(String url) {
        return url.startsWith("http://") || url.startsWith("https://") || url.startsWith("about:") || url.startsWith("mailto:");
    }

    @Nullable
    public PathReference getPathReference(@NotNull String path, @NotNull PsiElement element2) {
        return URLUtil.containsScheme((String)path) ? new PathReference(path, (Function)PathReference.NULL_ICON) : null;
    }
}

