/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.CommonBundle;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.IdeUICustomization;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleConfigurableEditor
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(SingleConfigurableEditor.class);
    private Project myProject;
    private Configurable myConfigurable;
    private JComponent myCenterPanel;
    private final String myDimensionKey;
    private final boolean myShowApplyButton;
    private boolean mySaveAllOnClose;

    public SingleConfigurableEditor(@Nullable Project project, @NotNull Configurable configurable2, @NonNls String dimensionKey, boolean showApplyButton, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        super(project, true, ideModalityType);
        this.myDimensionKey = dimensionKey;
        this.myShowApplyButton = showApplyButton;
        String title = SingleConfigurableEditor.createTitleString(configurable2);
        if (project != null && project.isDefault()) {
            title = IdeUICustomization.getInstance().projectMessage("title.for.new.projects", new Object[]{title});
        }
        this.setTitle(title);
        this.myProject = project;
        this.myConfigurable = configurable2;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(Component parent, @NotNull Configurable configurable2, String dimensionServiceKey, boolean showApplyButton, DialogWrapper.IdeModalityType ideModalityType) {
        super(parent, true);
        this.myDimensionKey = dimensionServiceKey;
        this.myShowApplyButton = showApplyButton;
        this.setTitle(SingleConfigurableEditor.createTitleString(configurable2));
        this.myConfigurable = configurable2;
        this.init();
        this.myConfigurable.reset();
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable2, @NonNls String dimensionKey, boolean showApplyButton) {
        this(project, configurable2, dimensionKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable2, String dimensionServiceKey, boolean showApplyButton) {
        this(parent, configurable2, dimensionServiceKey, showApplyButton, DialogWrapper.IdeModalityType.IDE);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable2, @NonNls String dimensionKey, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        this(project, configurable2, dimensionKey, true, ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable2, @NonNls String dimensionKey) {
        this(project, configurable2, dimensionKey, true);
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable2, String dimensionServiceKey) {
        this(parent, configurable2, dimensionServiceKey, true);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable2, @NotNull DialogWrapper.IdeModalityType ideModalityType) {
        this(project, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2), ideModalityType);
    }

    public SingleConfigurableEditor(@Nullable Project project, Configurable configurable2) {
        this(project, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2));
    }

    public SingleConfigurableEditor(Component parent, Configurable configurable2) {
        this(parent, configurable2, ShowSettingsUtilImpl.createDimensionKey(configurable2));
    }

    public Configurable getConfigurable() {
        return this.myConfigurable;
    }

    public Project getProject() {
        return this.myProject;
    }

    private static String createTitleString(@NotNull Configurable configurable2) {
        String displayName = configurable2.getDisplayName();
        LOG.assertTrue(displayName != null, (Object)configurable2.getClass().getName());
        return displayName.replaceAll("\n", " ");
    }

    protected String getDimensionServiceKey() {
        if (this.myDimensionKey == null) {
            return super.getDimensionServiceKey();
        }
        return this.myDimensionKey;
    }

    protected Action @NotNull [] createActions() {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.getOKAction());
        actions.add(this.getCancelAction());
        if (this.myShowApplyButton) {
            actions.add(new ApplyAction());
        }
        if (this.getHelpId() != null) {
            actions.add(this.getHelpAction());
        }
        return actions.toArray(new Action[0]);
    }

    @Nullable
    protected String getHelpId() {
        return this.myConfigurable.getHelpTopic();
    }

    protected void doOKAction() {
        try {
            if (this.myConfigurable.isModified()) {
                this.myConfigurable.apply();
                this.mySaveAllOnClose = true;
            }
        }
        catch (ConfigurationException e) {
            if (e.getMessage() != null) {
                if (this.myProject != null) {
                    Messages.showMessageDialog((Project)this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog((Component)this.getRootPane(), (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
            }
            return;
        }
        super.doOKAction();
    }

    protected static String createDimensionKey(Configurable configurable2) {
        String displayName = configurable2.getDisplayName();
        displayName = displayName.replaceAll("\n", "_").replaceAll(" ", "_");
        return "#" + displayName;
    }

    protected JComponent createCenterPanel() {
        this.myCenterPanel = this.myConfigurable.createComponent();
        return this.myCenterPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        Configurable configurable2 = this.myConfigurable;
        JComponent preferred = configurable2 == null ? null : configurable2.getPreferredFocusedComponent();
        return preferred == null ? IdeFocusTraversalPolicy.getPreferredFocusedComponent(this.myCenterPanel) : preferred;
    }

    public void dispose() {
        super.dispose();
        this.myConfigurable.disposeUIResources();
        this.myConfigurable = null;
        if (this.mySaveAllOnClose) {
            SaveAndSyncHandler.getInstance().scheduleSaveDocumentsAndProjectsAndApp(this.myProject);
        }
    }

    protected class ApplyAction
    extends AbstractAction {
        private final Alarm myUpdateAlarm;

        public ApplyAction() {
            super(CommonBundle.getApplyButtonText());
            this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
            Runnable updateRequest = new Runnable(){

                @Override
                public void run() {
                    if (!SingleConfigurableEditor.this.isShowing()) {
                        return;
                    }
                    try {
                        ApplyAction.this.setEnabled(SingleConfigurableEditor.this.myConfigurable != null && SingleConfigurableEditor.this.myConfigurable.isModified());
                    }
                    catch (IndexNotReadyException indexNotReadyException) {
                        // empty catch block
                    }
                    ApplyAction.this.addUpdateRequest(this);
                }
            };
            SwingUtilities.invokeLater(() -> {
                if (SingleConfigurableEditor.this.myConfigurable != null) {
                    this.addUpdateRequest(updateRequest);
                }
            });
        }

        private void addUpdateRequest(Runnable updateRequest) {
            this.myUpdateAlarm.addRequest(updateRequest, 500, ModalityState.stateForComponent((Component)SingleConfigurableEditor.this.getWindow()));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (SingleConfigurableEditor.this.myPerformAction) {
                return;
            }
            try {
                SingleConfigurableEditor.this.myPerformAction = true;
                if (SingleConfigurableEditor.this.myConfigurable.isModified()) {
                    SingleConfigurableEditor.this.myConfigurable.apply();
                    SingleConfigurableEditor.this.mySaveAllOnClose = true;
                    SingleConfigurableEditor.this.setCancelButtonText(CommonBundle.getCloseButtonText());
                }
            }
            catch (ConfigurationException e) {
                if (SingleConfigurableEditor.this.myProject != null) {
                    Messages.showMessageDialog((Project)SingleConfigurableEditor.this.myProject, (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    Messages.showMessageDialog((Component)SingleConfigurableEditor.this.getRootPane(), (String)e.getMessage(), (String)e.getTitle(), (Icon)Messages.getErrorIcon());
                }
            }
            finally {
                SingleConfigurableEditor.this.myPerformAction = false;
            }
        }
    }
}

