/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurableGroup;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.ActionCallback;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class Settings {
    public static final DataKey<Settings> KEY = DataKey.create((String)"settings.editor");
    private final List<? extends ConfigurableGroup> myGroups;
    private final Map<UnnamedConfigurable, ConfigurableWrapper> myMap = new IdentityHashMap<UnnamedConfigurable, ConfigurableWrapper>();

    protected Settings(@NotNull List<? extends ConfigurableGroup> groups) {
        this.myGroups = groups;
    }

    @Nullable
    public final <T extends Configurable> T find(@NotNull Class<T> type) {
        return this.unwrap(ConfigurableVisitor.findByType(type, this.myGroups), type);
    }

    @Nullable
    public final Configurable find(@NotNull String id2) {
        return this.unwrap(ConfigurableVisitor.findById(id2, this.myGroups), Configurable.class);
    }

    @NotNull
    public final ActionCallback select(Configurable configurable2) {
        return configurable2 == null ? ActionCallback.REJECTED : Promises.toActionCallback(this.selectImpl(Settings.choose(configurable2, (Configurable)this.myMap.get(configurable2))));
    }

    @NotNull
    public final ActionCallback select(Configurable configurable2, String option2) {
        SearchableConfigurable searchable;
        Runnable search2;
        ActionCallback callback2 = this.select(configurable2);
        if (option2 != null && configurable2 instanceof SearchableConfigurable && (search2 = (searchable = (SearchableConfigurable)configurable2).enableSearch(option2)) != null) {
            callback2.doWhenDone(search2);
        }
        return callback2;
    }

    @NotNull
    protected abstract Promise<? super Object> selectImpl(Configurable var1);

    private <T extends Configurable> T unwrap(Configurable configurable2, Class<T> type) {
        Configurable result2 = (Configurable)ConfigurableWrapper.cast(type, (UnnamedConfigurable)configurable2);
        if (result2 != null && configurable2 instanceof ConfigurableWrapper) {
            this.myMap.put((UnnamedConfigurable)result2, (ConfigurableWrapper)configurable2);
        }
        return (T)result2;
    }

    private static Configurable choose(Configurable configurable2, Configurable variant) {
        return variant != null ? variant : configurable2;
    }

    public void revalidate() {
    }

    public void reload() {
        this.myMap.clear();
    }
}

