/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.options.OptionsBundle;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ConfigurableGroupEP
implements PluginAware {
    private static final ExtensionPointName<ConfigurableGroupEP> EP = new ExtensionPointName("com.intellij.groupConfigurable");
    @RequiredElement
    @Attribute(value="id")
    @NonNls
    public String id;
    @Attribute(value="parentId")
    @NonNls
    public String parentId;
    @Attribute(value="weight")
    public int weight;
    @Attribute(value="helpTopic")
    @NonNls
    public String helpTopic;
    @Attribute(value="bundle")
    public String bundle;
    @RequiredElement
    @Attribute(value="displayNameKey")
    public String displayNameKey;
    @RequiredElement
    @Attribute(value="descriptionKey")
    public String descriptionKey;
    private PluginDescriptor myPluginDescriptor;

    ConfigurableGroupEP() {
    }

    public void setPluginDescriptor(@NotNull PluginDescriptor descriptor2) {
        this.myPluginDescriptor = descriptor2;
    }

    @NotNull
    String getDisplayName() {
        return this.getResourceValue(this.displayNameKey);
    }

    @NotNull
    String getDescription() {
        return this.getResourceValue(this.descriptionKey);
    }

    @NotNull
    ResourceBundle getResourceBundle() {
        ClassLoader classLoader;
        PluginDescriptor descriptor2 = this.myPluginDescriptor;
        String pathToBundle = this.bundle;
        if (pathToBundle == null) {
            if (descriptor2 != null) {
                pathToBundle = descriptor2.getResourceBundleBaseName();
            }
            if (pathToBundle == null) {
                return OptionsBundle.INSTANCE.getResourceBundle();
            }
        }
        ClassLoader classLoader2 = classLoader = descriptor2 == null ? null : descriptor2.getPluginClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return DynamicBundle.INSTANCE.getResourceBundle(pathToBundle, classLoader);
    }

    @NotNull
    String getResourceValue(@NotNull String key) {
        String message = AbstractBundle.messageOrNull((ResourceBundle)this.getResourceBundle(), (String)key, (Object[])new Object[0]);
        return message != null ? message : OptionsBundle.message((String)key, (Object[])new Object[0]);
    }

    @Nullable
    static ConfigurableGroupEP find(@NotNull String id2) {
        return (ConfigurableGroupEP)EP.findFirstSafe(ep2 -> id2.equals(ep2.id));
    }
}

