/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.ide.ui.search.OptionDescription;
import com.intellij.openapi.options.BeanConfigurable;
import com.intellij.openapi.options.ConfigurableBuilderHelper;
import com.intellij.openapi.options.ConfigurableWithOptionDescriptors;
import com.intellij.openapi.options.UiDslConfigurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.Setter;
import com.intellij.ui.layout.RowBuilder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.reflect.KMutableProperty0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigurableBuilder
extends UiDslConfigurable.Simple
implements UiDslConfigurable,
ConfigurableWithOptionDescriptors {
    private String myTitle;
    private final List<BeanField<?, ?>> myFields = new ArrayList();

    protected ConfigurableBuilder() {
    }

    protected ConfigurableBuilder(@Nullable String title) {
        this.setTitle(title);
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    protected void setTitle(@Nullable String title) {
        this.myTitle = title;
    }

    protected void checkBox(@NotNull String title, @NotNull @NotNull Getter<@NotNull Boolean> getter, @NotNull Setter<? super Boolean> setter) {
        this.myFields.add(new CheckboxField(new CallbackAccessor(getter, setter), title));
    }

    protected void checkBox(@NotNull String title, @NotNull @NotNull KMutableProperty0<@NotNull Boolean> prop) {
        this.myFields.add(new CheckboxField(new KPropertyAccessor(prop), title));
    }

    protected <V> void component(final @NotNull JComponent component2, @NotNull Getter<? extends V> beanGetter, @NotNull Setter<? super V> beanSetter, final @NotNull Getter<? extends V> componentGetter, final @NotNull Setter<? super V> componentSetter) {
        BeanField field = new BeanField<JComponent, V>(new CallbackAccessor(beanGetter, beanSetter)){

            @Override
            @NotNull
            protected JComponent createComponent() {
                return component2;
            }

            @Override
            protected V getComponentValue() {
                return componentGetter.get();
            }

            @Override
            protected void setComponentValue(V value2) {
                componentSetter.set(value2);
            }
        };
        this.myFields.add(field);
    }

    @NotNull
    public List<OptionDescription> getOptionDescriptors(@NotNull String configurableId, @NotNull Function<? super String, String> nameConverter) {
        List boxes = JBIterable.from(this.myFields).filter(CheckboxField.class).toList();
        return ContainerUtil.map((Collection)boxes, box -> new BooleanOptionDescription((String)nameConverter.apply(((CheckboxField)box).getTitle()), configurableId, (CheckboxField)box){
            final /* synthetic */ CheckboxField val$box;
            {
                this.val$box = checkboxField;
                super(x0, x1);
            }

            public boolean isOptionEnabled() {
                return this.val$box.getAccessorValue();
            }

            public void setOptionState(boolean enabled) {
                this.val$box.setAccessorValue(enabled);
            }
        });
    }

    @Override
    public void createComponentRow(@NotNull RowBuilder builder2) {
        ConfigurableBuilderHelper.buildFieldsPanel$intellij_platform_ide_impl(builder2, this.myTitle, this.myFields);
    }

    @Nullable
    public static String getConfigurableTitle(@NotNull UnnamedConfigurable configurable2) {
        if (configurable2 instanceof BeanConfigurable) {
            return ((BeanConfigurable)configurable2).getTitle();
        }
        if (configurable2 instanceof ConfigurableBuilder) {
            return ((ConfigurableBuilder)configurable2).getTitle();
        }
        return null;
    }

    private static class CheckboxField
    extends BeanField<JCheckBox, Boolean> {
        private final String myTitle;

        private CheckboxField(PropertyAccessor<Boolean> accessor, @NotNull String title) {
            super(accessor);
            this.myTitle = title;
        }

        @NotNull
        private String getTitle() {
            return this.myTitle;
        }

        private void setAccessorValue(boolean value2) {
            this.myAccessor.setValue(value2);
        }

        private boolean getAccessorValue() {
            return (Boolean)this.myAccessor.getValue();
        }

        @Override
        @NotNull
        protected JCheckBox createComponent() {
            return new JCheckBox(this.myTitle);
        }

        @Override
        protected Boolean getComponentValue() {
            return ((JCheckBox)this.getComponent()).isSelected();
        }

        @Override
        protected void setComponentValue(@NotNull Boolean value2) {
            ((JCheckBox)this.getComponent()).setSelected(value2);
        }
    }

    static abstract class BeanField<C extends JComponent, T> {
        protected final PropertyAccessor<T> myAccessor;
        private C myComponent;

        private BeanField(@NotNull PropertyAccessor<T> accessor) {
            this.myAccessor = accessor;
        }

        @NotNull
        C getComponent() {
            if (this.myComponent == null) {
                this.myComponent = this.createComponent();
            }
            return this.myComponent;
        }

        @NotNull
        protected abstract C createComponent();

        boolean isModified() {
            T beanValue;
            T componentValue = this.getComponentValue();
            return !Comparing.equal(componentValue, beanValue = this.myAccessor.getValue());
        }

        void apply() {
            this.myAccessor.setValue(this.getComponentValue());
        }

        void reset() {
            this.setComponentValue(this.myAccessor.getValue());
        }

        protected abstract T getComponentValue();

        protected abstract void setComponentValue(T var1);
    }

    private static class KPropertyAccessor<T>
    implements PropertyAccessor<T> {
        private final KMutableProperty0<T> myProperty;

        private KPropertyAccessor(KMutableProperty0<T> property) {
            this.myProperty = property;
        }

        @Override
        public T getValue() {
            return (T)this.myProperty.get();
        }

        @Override
        public void setValue(@NotNull T value2) {
            this.myProperty.set(value2);
        }
    }

    private static class CallbackAccessor<T>
    implements PropertyAccessor<T> {
        private final Getter<? extends T> myGetter;
        private final Setter<? super T> mySetter;

        private CallbackAccessor(Getter<? extends T> getter, Setter<? super T> setter) {
            this.myGetter = getter;
            this.mySetter = setter;
        }

        @Override
        public T getValue() {
            return (T)this.myGetter.get();
        }

        @Override
        public void setValue(@NotNull T value2) {
            this.mySetter.set(value2);
        }
    }

    private static interface PropertyAccessor<T> {
        public T getValue();

        public void setValue(@NotNull T var1);
    }
}

