/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.ExternalizableScheme;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundScheme<E extends SchemeElement>
implements ExternalizableScheme {
    protected String myName;
    protected final ArrayList<E> myElements = new ArrayList();

    public CompoundScheme(String name) {
        this.setName(name);
    }

    public final void addElement(E t) {
        this.myElements.add(t);
    }

    @NotNull
    public final List<E> getElements() {
        if (this.myElements.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<E>(this.myElements));
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Override
    public final void setName(@NotNull String name) {
        this.myName = name;
        for (SchemeElement template : this.myElements) {
            template.setGroupName(name);
        }
    }

    public final void removeElement(E template) {
        this.myElements.remove(template);
    }

    public final boolean isEmpty() {
        return this.myElements.isEmpty();
    }

    @NotNull
    private CompoundScheme<E> createNewInstance(String name) {
        try {
            Constructor<?> constructor = this.getClass().getConstructor(String.class);
            try {
                constructor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return (CompoundScheme)constructor.newInstance(name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    CompoundScheme<E> copy() {
        CompoundScheme<E> result2 = this.createNewInstance(this.getName());
        result2.resetFrom(this);
        return result2;
    }

    void resetFrom(@NotNull CompoundScheme<? extends E> template) {
        this.myElements.clear();
        this.myElements.ensureCapacity(template.myElements.size());
        for (SchemeElement element2 : template.myElements) {
            this.myElements.add(element2.copy());
        }
    }

    public boolean containsElement(@NotNull String key) {
        return ContainerUtil.exists(this.myElements, e -> key.equals(e.getKey()));
    }

    public static final class MutatorHelper<T extends CompoundScheme<E>, E extends SchemeElement> {
        private final Map<T, T> copiedToOriginal = new IdentityHashMap<T, T>();

        @NotNull
        public T copy(@NotNull T scheme) {
            CompoundScheme copied = ((CompoundScheme)scheme).copy();
            this.copiedToOriginal.put(copied, scheme);
            return (T)copied;
        }

        @NotNull
        public List<T> apply(@NotNull List<? extends T> copiedSchemes) {
            return this.apply(copiedSchemes, null);
        }

        @NotNull
        public List<T> apply(@NotNull List<? extends T> copiedSchemes, @Nullable BiConsumer<? super T, ? super T> changedConsumer) {
            this.copiedToOriginal.values().removeIf(it -> !ContainerUtil.containsIdentity((Iterable)copiedSchemes, (Object)it));
            ArrayList originals = new ArrayList(copiedSchemes.size());
            for (CompoundScheme copied : copiedSchemes) {
                CompoundScheme original = (CompoundScheme)this.copiedToOriginal.remove(copied);
                if (original == null) {
                    original = copied.copy();
                    this.copiedToOriginal.put(copied, original);
                } else {
                    if (changedConsumer != null) {
                        changedConsumer.accept(original, copied);
                    }
                    original.resetFrom(copied);
                }
                originals.add(original);
            }
            return originals;
        }

        public void clear() {
            this.copiedToOriginal.clear();
        }
    }
}

