/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl.scopes;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ObjectIntHashMap;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryRuntimeClasspathScope
extends GlobalSearchScope {
    private final ProjectFileIndex myIndex;
    private final ObjectIntHashMap<VirtualFile> myEntries = new ObjectIntHashMap();

    public LibraryRuntimeClasspathScope(@NotNull Project project, @NotNull Collection<? extends Module> modules2) {
        super(project);
        this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        THashSet processedSdk = new THashSet();
        THashSet processedLibraries = new THashSet();
        THashSet processedModules = new THashSet();
        Condition condition = arg_0 -> LibraryRuntimeClasspathScope.lambda$new$0((Set)processedModules, arg_0);
        for (Module module : modules2) {
            this.buildEntries(module, (Set<? super Module>)processedModules, (Set<? super Library>)processedLibraries, (Set<? super Sdk>)processedSdk, (Condition<? super OrderEntry>)condition);
        }
    }

    public LibraryRuntimeClasspathScope(@NotNull Project project, @NotNull LibraryOrderEntry entry) {
        super(project);
        this.myIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        LibraryRuntimeClasspathScope.addAll(this.myEntries, entry.getRootFiles(OrderRootType.CLASSES));
        LibraryRuntimeClasspathScope.addAll(this.myEntries, entry.getRootFiles(OrderRootType.SOURCES));
    }

    public int calcHashCode() {
        return this.myEntries.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != LibraryRuntimeClasspathScope.class) {
            return false;
        }
        LibraryRuntimeClasspathScope that = (LibraryRuntimeClasspathScope)((Object)object);
        return that.myEntries.equals(this.myEntries);
    }

    private void buildEntries(@NotNull Module module, final @NotNull Set<? super Module> processedModules, final @NotNull Set<? super Library> processedLibraries, final @NotNull Set<? super Sdk> processedSdk, @NotNull Condition<? super OrderEntry> condition) {
        if (!processedModules.add((Module)module)) {
            return;
        }
        ModuleRootManager.getInstance((Module)module).orderEntries().recursively().satisfying(condition).process((RootPolicy)new RootPolicy<ObjectIntHashMap<VirtualFile>>(){

            public ObjectIntHashMap<VirtualFile> visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, ObjectIntHashMap<VirtualFile> value2) {
                Library library = libraryOrderEntry.getLibrary();
                if (library != null && processedLibraries.add(library)) {
                    LibraryRuntimeClasspathScope.addAll((ObjectIntHashMap<? super VirtualFile>)value2, libraryOrderEntry.getRootFiles(OrderRootType.CLASSES));
                    LibraryRuntimeClasspathScope.addAll((ObjectIntHashMap<? super VirtualFile>)value2, libraryOrderEntry.getRootFiles(OrderRootType.SOURCES));
                }
                return value2;
            }

            public ObjectIntHashMap<VirtualFile> visitModuleSourceOrderEntry(@NotNull ModuleSourceOrderEntry moduleSourceOrderEntry, ObjectIntHashMap<VirtualFile> value2) {
                processedModules.add(moduleSourceOrderEntry.getOwnerModule());
                LibraryRuntimeClasspathScope.addAll((ObjectIntHashMap<? super VirtualFile>)value2, moduleSourceOrderEntry.getRootModel().getSourceRoots());
                return value2;
            }

            public ObjectIntHashMap<VirtualFile> visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, ObjectIntHashMap<VirtualFile> value2) {
                Module depModule = moduleOrderEntry.getModule();
                if (depModule != null) {
                    LibraryRuntimeClasspathScope.addAll((ObjectIntHashMap<? super VirtualFile>)value2, ModuleRootManager.getInstance((Module)depModule).getSourceRoots());
                }
                return value2;
            }

            public ObjectIntHashMap<VirtualFile> visitJdkOrderEntry(@NotNull JdkOrderEntry jdkOrderEntry, ObjectIntHashMap<VirtualFile> value2) {
                Sdk jdk = jdkOrderEntry.getJdk();
                if (jdk != null && processedSdk.add(jdk)) {
                    LibraryRuntimeClasspathScope.addAll((ObjectIntHashMap<? super VirtualFile>)value2, jdkOrderEntry.getRootFiles(OrderRootType.CLASSES));
                    LibraryRuntimeClasspathScope.addAll((ObjectIntHashMap<? super VirtualFile>)value2, jdkOrderEntry.getRootFiles(OrderRootType.SOURCES));
                }
                return value2;
            }
        }, this.myEntries);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        return this.myEntries.contains((Object)this.getFileRoot(file2));
    }

    @Nullable
    private VirtualFile getFileRoot(@NotNull VirtualFile file2) {
        if (this.myIndex.isInContent(file2) || this.myIndex.isInLibrarySource(file2)) {
            return this.myIndex.getSourceRootForFile(file2);
        }
        if (this.myIndex.isInLibraryClasses(file2)) {
            return this.myIndex.getClassRootForFile(file2);
        }
        return null;
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        int i2;
        if (file1.equals(file2)) {
            return 0;
        }
        VirtualFile r1 = this.getFileRoot(file1);
        VirtualFile r2 = this.getFileRoot(file2);
        int i1 = this.myEntries.get((Object)r1);
        if (i1 == (i2 = this.myEntries.get((Object)r2))) {
            return 0;
        }
        if (i1 == -1) {
            return -1;
        }
        if (i2 == -1) {
            return 1;
        }
        return i2 - i1;
    }

    @NotNull
    public List<VirtualFile> getRoots() {
        if (this.myEntries.isEmpty()) {
            return Collections.emptyList();
        }
        VirtualFile[] result2 = new VirtualFile[this.myEntries.size()];
        this.myEntries.forEachEntry((a, b) -> {
            result2[b] = a;
            return true;
        });
        return Arrays.asList(result2);
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        return false;
    }

    public boolean isSearchInLibraries() {
        return true;
    }

    private static void addAll(ObjectIntHashMap<? super VirtualFile> entries, VirtualFile[] files2) {
        for (VirtualFile file2 : files2) {
            if (entries.contains((Object)file2)) continue;
            entries.put((Object)file2, entries.size());
        }
    }

    private static /* synthetic */ boolean lambda$new$0(Set processedModules, OrderEntry orderEntry) {
        if (orderEntry instanceof ModuleOrderEntry) {
            Module module = ((ModuleOrderEntry)orderEntry).getModule();
            return module != null && !processedModules.contains(module);
        }
        return true;
    }
}

