/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.ConfigurationErrorDescription;
import com.intellij.openapi.module.ProjectLoadingErrorsNotifier;
import com.intellij.openapi.util.Disposer;
import java.util.Collection;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public class ProjectLoadingErrorsHeadlessNotifier
extends ProjectLoadingErrorsNotifier {
    private static Consumer<? super ConfigurationErrorDescription> ourErrorHandler;

    public static void setErrorHandler(Consumer<? super ConfigurationErrorDescription> errorHandler, Disposable parentDisposable) {
        ourErrorHandler = errorHandler;
        Disposer.register((Disposable)parentDisposable, () -> {
            ourErrorHandler = null;
        });
    }

    @Override
    public void registerError(@NotNull ConfigurationErrorDescription errorDescription) {
        if (ourErrorHandler == null) {
            throw new RuntimeException(errorDescription.getDescription());
        }
        ourErrorHandler.accept(errorDescription);
    }

    @Override
    public void registerErrors(@NotNull Collection<? extends ConfigurationErrorDescription> errorDescriptions) {
        for (ConfigurationErrorDescription configurationErrorDescription : errorDescriptions) {
            this.registerError(configurationErrorDescription);
        }
    }
}

