/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.icons.AllIcons;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.WebModuleTypeBase;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebModuleBuilder<T>
extends ModuleBuilder {
    public static final String GROUP_NAME = "JavaScript";
    public static final Icon ICON = AllIcons.Nodes.PpWeb;
    private final WebProjectTemplate<T> myTemplate;
    protected final NotNullLazyValue<ProjectGeneratorPeer<T>> myGeneratorPeerLazyValue;

    public WebModuleBuilder(@NotNull WebProjectTemplate<T> template) {
        this.myTemplate = template;
        this.myGeneratorPeerLazyValue = this.myTemplate.createLazyPeer();
    }

    public WebModuleBuilder() {
        this.myTemplate = null;
        this.myGeneratorPeerLazyValue = null;
    }

    public void setupRootModel(@NotNull ModifiableRootModel modifiableRootModel) throws ConfigurationException {
        this.doAddContentEntry(modifiableRootModel);
    }

    public ModuleType getModuleType() {
        return WebModuleTypeBase.getInstance();
    }

    public String getPresentableName() {
        return this.getGroupName();
    }

    public boolean isTemplateBased() {
        return true;
    }

    public String getGroupName() {
        return GROUP_NAME;
    }

    public Icon getNodeIcon() {
        return this.myTemplate != null ? this.myTemplate.getIcon() : ICON;
    }

    @Nullable
    public Module commitModule(@NotNull Project project, @Nullable ModifiableModuleModel model) {
        Module module = super.commitModule(project, model);
        if (module != null && this.myTemplate != null) {
            this.doGenerate(this.myTemplate, module);
        }
        return module;
    }

    private void doGenerate(@NotNull WebProjectTemplate<T> template, @NotNull Module module) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        VirtualFile[] contentRoots = moduleRootManager.getContentRoots();
        VirtualFile dir = module.getProject().getBaseDir();
        if (contentRoots.length > 0 && contentRoots[0] != null) {
            dir = contentRoots[0];
        }
        template.generateProject(module.getProject(), dir, ((ProjectGeneratorPeer)this.myGeneratorPeerLazyValue.getValue()).getSettings(), module);
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        if (this.myTemplate == null) {
            return super.modifySettingsStep(settingsStep);
        }
        ((ProjectGeneratorPeer)this.myGeneratorPeerLazyValue.getValue()).buildUI(settingsStep);
        return new ModuleWizardStep(){

            public JComponent getComponent() {
                return null;
            }

            public void updateDataModel() {
            }

            public boolean validate() throws ConfigurationException {
                ValidationInfo info = ((ProjectGeneratorPeer)WebModuleBuilder.this.myGeneratorPeerLazyValue.getValue()).validate();
                if (info != null) {
                    throw new ConfigurationException(info.message);
                }
                return true;
            }
        };
    }
}

