/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.ui.customization.ActionUrl;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.openapi.actionSystem.AbbreviationManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionStub;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.ActionShortcutRestrictions;
import com.intellij.openapi.keymap.impl.KeymapImpl;
import com.intellij.openapi.keymap.impl.ui.Group;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ActionsTreeUtil {
    private static final Logger LOG = Logger.getInstance(ActionsTreeUtil.class);
    @Deprecated
    public static final String MAIN_MENU_TITLE = "Main menu";
    @NonNls
    private static final String EDITOR_PREFIX = "Editor";

    private ActionsTreeUtil() {
    }

    @NotNull
    public static Map<String, String> createPluginActionsMap() {
        HashSet<PluginId> visited = new HashSet<PluginId>();
        Object2ObjectOpenHashMap result2 = new Object2ObjectOpenHashMap();
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            PluginId id2 = descriptor2.getPluginId();
            visited.add(id2);
            if (PluginManagerCore.CORE_ID == id2) continue;
            for (String actionId : actionManager.getPluginActions(id2)) {
                result2.put(actionId, descriptor2.getName());
            }
        }
        for (PluginId id3 : PluginId.getRegisteredIdList()) {
            if (visited.contains(id3)) continue;
            for (String actionId : actionManager.getPluginActions(id3)) {
                result2.put(actionId, id3.getIdString());
            }
        }
        return result2;
    }

    @NotNull
    private static Group createPluginsActionsGroup(Condition<? super AnAction> filtered2) {
        AnAction anAction;
        String[] pluginActions;
        Group pluginGroup;
        Group pluginsGroup = new Group(KeyMapBundle.message((String)"plugins.group.title", (Object[])new Object[0]), null, null);
        KeymapManagerEx keymapManager2 = KeymapManagerEx.getInstanceEx();
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        ArrayList<IdeaPluginDescriptor> plugins = new ArrayList<IdeaPluginDescriptor>(Arrays.asList(PluginManagerCore.getPlugins()));
        plugins.sort(Comparator.comparing(PluginDescriptor::getName));
        ObjectOpenHashSet collected = new ObjectOpenHashSet(plugins.size());
        for (IdeaPluginDescriptor plugin : plugins) {
            collected.add(plugin.getPluginId());
            if (plugin.getName().equals("IDEA CORE")) continue;
            pluginGroup = new Group(plugin.getName(), null, null);
            pluginActions = actionManager.getPluginActions(plugin.getPluginId());
            if (pluginActions.length == 0) continue;
            Arrays.sort(pluginActions, Comparator.comparing(ActionsTreeUtil::getTextToCompare));
            for (String pluginAction : pluginActions) {
                if (keymapManager2.getBoundActions().contains(pluginAction)) continue;
                anAction = actionManager.getActionOrStub(pluginAction);
                if (filtered2 != null && !filtered2.value((Object)anAction)) continue;
                pluginGroup.addActionId(pluginAction);
            }
            if (pluginGroup.getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        for (PluginId pluginId : PluginId.getRegisteredIdList()) {
            if (collected.contains(pluginId)) continue;
            pluginGroup = new Group(pluginId.getIdString(), null, null);
            pluginActions = actionManager.getPluginActions(pluginId);
            if (pluginActions.length == 0) continue;
            for (String pluginAction : pluginActions) {
                if (keymapManager2.getBoundActions().contains(pluginAction)) continue;
                anAction = actionManager.getActionOrStub(pluginAction);
                if (filtered2 != null && !filtered2.value((Object)anAction)) continue;
                pluginGroup.addActionId(pluginAction);
            }
            if (pluginGroup.getSize() <= 0) continue;
            pluginsGroup.addGroup(pluginGroup);
        }
        return pluginsGroup;
    }

    private static Group createMainMenuGroup(Condition<? super AnAction> filtered2) {
        Group group = new Group(ActionsTreeUtil.getMainMenuTitle(), "MainMenu", AllIcons.Nodes.KeymapMainMenu);
        ActionGroup mainMenuGroup = (ActionGroup)ActionManager.getInstance().getActionOrStub("MainMenu");
        ActionsTreeUtil.fillGroupIgnorePopupFlag(mainMenuGroup, group, filtered2);
        return group;
    }

    @NotNull
    private static Condition<AnAction> wrapFilter(@Nullable Condition<? super AnAction> filter2, Keymap keymap2, ActionManager actionManager) {
        ActionShortcutRestrictions shortcutRestrictions = ActionShortcutRestrictions.getInstance();
        return action2 -> {
            String id2;
            if (action2 == null) {
                return false;
            }
            String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            if (id2 != null) {
                if (!Registry.is((String)"keymap.show.alias.actions")) {
                    boolean bound;
                    String binding = ActionsTreeUtil.getActionBinding(keymap2, id2);
                    boolean bl = bound = binding != null && actionManager.getAction(binding) != null && !ActionsTreeUtil.hasAssociatedShortcutsInHierarchy(id2, keymap2);
                    if (bound) {
                        return false;
                    }
                }
                if (!shortcutRestrictions.getForActionId((String)id2).allowChanging) {
                    return false;
                }
            }
            return filter2 == null || filter2.value(action2);
        };
    }

    private static boolean hasAssociatedShortcutsInHierarchy(String id2, Keymap keymap2) {
        while (keymap2 != null) {
            if (((KeymapImpl)keymap2).hasOwnActionId(id2)) {
                return true;
            }
            keymap2 = keymap2.getParent();
        }
        return false;
    }

    private static void fillGroupIgnorePopupFlag(ActionGroup actionGroup, Group group, Condition<? super AnAction> filtered2) {
        AnAction[] mainMenuTopGroups;
        for (AnAction action2 : mainMenuTopGroups = ActionsTreeUtil.getActions(actionGroup)) {
            Group subGroup;
            if (!(action2 instanceof ActionGroup) || (subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, false, filtered2)).getSize() <= 0) continue;
            group.addGroup(subGroup);
        }
    }

    public static Group createGroup(ActionGroup actionGroup, boolean ignore, Condition<? super AnAction> filtered2) {
        return ActionsTreeUtil.createGroup(actionGroup, ActionsTreeUtil.getName((AnAction)actionGroup), actionGroup.getTemplatePresentation().getIcon(), null, ignore, filtered2);
    }

    private static String getName(AnAction action2) {
        String id2;
        String name = action2.getTemplatePresentation().getText();
        if (name != null && !name.isEmpty()) {
            return name;
        }
        String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
        if (id2 != null) {
            return id2;
        }
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group = (DefaultActionGroup)action2;
            if (group.getChildrenCount() == 0) {
                return "Empty group";
            }
            for (AnAction child2 : children2 = group.getChildActionsOrStubs()) {
                if (child2 instanceof Separator) continue;
                return "group." + ActionsTreeUtil.getName(child2);
            }
            return "Empty unnamed group";
        }
        return action2.getClass().getName();
    }

    public static Group createGroup(ActionGroup actionGroup, String groupName, Icon icon2, Icon openIcon, boolean ignore, Condition<? super AnAction> filtered2) {
        return ActionsTreeUtil.createGroup(actionGroup, groupName, icon2, openIcon, ignore, filtered2, true);
    }

    public static Group createGroup(ActionGroup actionGroup, String groupName, Icon icon2, Icon openIcon, boolean ignore, Condition<? super AnAction> filtered2, boolean normalizeSeparators) {
        AnAction[] children2;
        ActionManager actionManager = ActionManager.getInstance();
        Group group = new Group(groupName, actionManager.getId((AnAction)actionGroup), icon2);
        for (AnAction action2 : children2 = ActionsTreeUtil.getActions(actionGroup)) {
            String id2;
            if (action2 == null) {
                LOG.error(groupName + " contains null actions");
                continue;
            }
            if (action2 instanceof ActionGroup) {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, ActionsTreeUtil.getName(action2), null, null, ignore, filtered2, normalizeSeparators);
                if (!ignore && !((ActionGroup)action2).isPopup()) {
                    group.addAll(subGroup);
                    continue;
                }
                if (subGroup.getSize() <= 0 && filtered2 != null && !filtered2.value((Object)action2)) continue;
                group.addGroup(subGroup);
                continue;
            }
            if (action2 instanceof Separator) {
                group.addSeparator();
                continue;
            }
            String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            if (id2 == null || filtered2 != null && !filtered2.value((Object)action2)) continue;
            group.addActionId(id2);
        }
        if (normalizeSeparators) {
            group.normalizeSeparators();
        }
        return group;
    }

    @NotNull
    public static Group createCorrectedGroup(@NotNull ActionGroup actionGroup, @NotNull String groupName, @NotNull List<String> path, @NotNull List<ActionUrl> actionUrls) {
        path.add(groupName);
        ActionManager actionManager = ActionManager.getInstance();
        Group group = new Group(groupName, actionManager.getId((AnAction)actionGroup), null);
        ArrayList children2 = ContainerUtil.newArrayList((Object[])ActionsTreeUtil.getActions(actionGroup));
        for (ActionUrl actionUrl : actionUrls) {
            AnAction anAction;
            AnAction componentAction;
            if (!path.equals(actionUrl.getGroupPath()) || (componentAction = actionUrl.getComponentAction()) == null) continue;
            if (actionUrl.getActionType() == 1) {
                if (children2.size() > actionUrl.getAbsolutePosition()) {
                    children2.add(actionUrl.getAbsolutePosition(), componentAction);
                    continue;
                }
                children2.add(componentAction);
                continue;
            }
            if (actionUrl.getActionType() != -1 || children2.size() <= actionUrl.getAbsolutePosition() || ((anAction = (AnAction)children2.get(actionUrl.getAbsolutePosition())).getTemplatePresentation().getText() == null ? componentAction.getTemplatePresentation().getText() != null && componentAction.getTemplatePresentation().getText().length() > 0 : !anAction.getTemplatePresentation().getText().equals(componentAction.getTemplatePresentation().getText()))) continue;
            children2.remove(actionUrl.getAbsolutePosition());
        }
        for (AnAction action2 : children2) {
            if (action2 instanceof ActionGroup) {
                group.addGroup(ActionsTreeUtil.createCorrectedGroup((ActionGroup)action2, ActionsTreeUtil.getName(action2), path, actionUrls));
                continue;
            }
            if (action2 instanceof Separator) {
                group.addSeparator();
                continue;
            }
            String id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2);
            if (id2 == null) continue;
            group.addActionId(id2);
        }
        path.remove(path.size() - 1);
        return group;
    }

    private static Group createEditorActionsGroup(Condition<? super AnAction> filtered2) {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup editorGroup = (DefaultActionGroup)actionManager.getActionOrStub("EditorActions");
        ArrayList ids = new ArrayList();
        ActionsTreeUtil.addEditorActions(filtered2, editorGroup, ids);
        Collections.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"editor.actions.group.title", (Object[])new Object[0]), "EditorActions", AllIcons.Nodes.KeymapEditor);
        for (String id2 : ids) {
            group.addActionId(id2);
        }
        return group;
    }

    @Nullable
    private static String getActionBinding(Keymap keymap2, String id2) {
        if (keymap2 == null) {
            return null;
        }
        Keymap parent = keymap2.getParent();
        String result2 = KeymapManagerEx.getInstanceEx().getActionBinding(id2);
        if (result2 == null && parent != null) {
            result2 = KeymapManagerEx.getInstanceEx().getActionBinding(id2);
        }
        return result2;
    }

    private static void addEditorActions(Condition<? super AnAction> filtered2, DefaultActionGroup editorGroup, ArrayList<? super String> ids) {
        AnAction[] editorActions = editorGroup.getChildActionsOrStubs();
        ActionManager actionManager = ActionManager.getInstance();
        for (AnAction editorAction : editorActions) {
            String actionId;
            if (editorAction instanceof DefaultActionGroup) {
                ActionsTreeUtil.addEditorActions(filtered2, (DefaultActionGroup)editorAction, ids);
                continue;
            }
            String string = actionId = editorAction instanceof ActionStub ? ((ActionStub)editorAction).getId() : actionManager.getId(editorAction);
            if (actionId == null || filtered2 != null && !filtered2.value((Object)editorAction)) continue;
            ids.add(actionId);
        }
    }

    private static Group createExtensionGroup(Condition<AnAction> filtered2, Project project, KeymapExtension provider) {
        return (Group)provider.createGroup(filtered2, project);
    }

    private static Group createMacrosGroup(Condition<? super AnAction> filtered2) {
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Object[] ids = actionManager.getActionIds("Macro.");
        Arrays.sort(ids);
        Group group = new Group(KeyMapBundle.message((String)"macros.group.title", (Object[])new Object[0]), null, null);
        for (Object id2 : ids) {
            if (filtered2 != null && !filtered2.value((Object)actionManager.getActionOrStub((String)id2))) continue;
            group.addActionId((String)id2);
        }
        return group;
    }

    private static Group createQuickListsGroup(Condition<? super AnAction> filtered2, String filter2, boolean forceFiltering, QuickList[] quickLists) {
        Arrays.sort(quickLists, Comparator.comparing(QuickList::getActionId));
        Group group = new Group(KeyMapBundle.message((String)"quick.lists.group.title", (Object[])new Object[0]), null, null);
        for (QuickList quickList : quickLists) {
            if ((filtered2 == null || !filtered2.value((Object)ActionManagerEx.getInstanceEx().getAction(quickList.getActionId()))) && !SearchUtil.isComponentHighlighted(quickList.getName(), filter2, forceFiltering, null) && (filtered2 != null || !StringUtil.isEmpty((String)filter2))) continue;
            group.addQuickList(quickList);
        }
        return group;
    }

    @NotNull
    private static Group createOtherGroup(@Nullable Condition<? super AnAction> filtered2, Group addedActions, @Nullable Keymap keymap2) {
        String[] registeredActionIds;
        addedActions.initIds();
        ObjectOpenHashSet result2 = new ObjectOpenHashSet();
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        if (keymap2 != null) {
            for (String id3 : keymap2.getActionIdList()) {
                if (id3.startsWith(EDITOR_PREFIX) && actionManager.getActionOrStub("$" + id3.substring(6)) != null || id3.startsWith("QuickList.") || addedActions.containsId(id3)) continue;
                result2.add(id3);
            }
        }
        KeymapManagerEx keymapManager2 = KeymapManagerEx.getInstanceEx();
        for (String id4 : registeredActionIds = actionManager.getActionIds("")) {
            AnAction actionOrStub = actionManager.getActionOrStub(id4);
            if (actionOrStub instanceof ActionGroup && !((ActionGroup)actionOrStub).canBePerformed(DataManager.getInstance().getDataContext()) || id4.startsWith("QuickList.") || addedActions.containsId(id4) || result2.contains(id4) || keymapManager2.getBoundActions().contains(id4)) continue;
            result2.add(id4);
        }
        ActionsTreeUtil.filterOtherActionsGroup((Set<String>)result2);
        Group group = new Group(KeyMapBundle.message((String)"other.group.title", (Object[])new Object[0]), AllIcons.Nodes.KeymapOther);
        AnAction[] groupedActions = ActionsTreeUtil.getActions("Other.KeymapGroup");
        for (AnAction action2 : groupedActions) {
            ActionsTreeUtil.addAction(group, action2, filtered2);
        }
        result2.removeAll(group.initIds());
        for (String id5 : ContainerUtil.sorted((Collection)result2, (id1, id2) -> ActionsTreeUtil.getTextToCompare(id1).compareToIgnoreCase(ActionsTreeUtil.getTextToCompare(id2)))) {
            if (filtered2 != null && !filtered2.value((Object)actionManager.getActionOrStub(id5))) continue;
            group.addActionId(id5);
        }
        return group;
    }

    private static String getTextToCompare(String id2) {
        AnAction action2 = ActionManager.getInstance().getActionOrStub(id2);
        if (action2 == null) {
            return id2;
        }
        String text = action2.getTemplatePresentation().getText();
        return text != null ? text : id2;
    }

    private static void filterOtherActionsGroup(Set<String> actions) {
        ActionsTreeUtil.filterOutGroup(actions, "GenerateGroup");
        ActionsTreeUtil.filterOutGroup(actions, "NewGroup");
        ActionsTreeUtil.filterOutGroup(actions, "ChangeScheme");
    }

    private static void filterOutGroup(Set<String> actions, String groupId2) {
        if (groupId2 == null) {
            throw new IllegalArgumentException();
        }
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action2 = actionManager.getActionOrStub(groupId2);
        if (action2 instanceof DefaultActionGroup) {
            AnAction[] children2;
            DefaultActionGroup group = (DefaultActionGroup)action2;
            for (AnAction child2 : children2 = group.getChildActionsOrStubs()) {
                String childId;
                String string = childId = child2 instanceof ActionStub ? ((ActionStub)child2).getId() : actionManager.getId(child2);
                if (childId == null) continue;
                if (child2 instanceof DefaultActionGroup) {
                    ActionsTreeUtil.filterOutGroup(actions, childId);
                    continue;
                }
                actions.remove(childId);
            }
        }
    }

    public static DefaultMutableTreeNode createNode(Group group) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(group);
        for (Object child2 : group.getChildren()) {
            if (child2 instanceof Group) {
                DefaultMutableTreeNode childNode = ActionsTreeUtil.createNode((Group)child2);
                node.add(childNode);
                continue;
            }
            LOG.assertTrue(child2 != null);
            node.add(new DefaultMutableTreeNode(child2));
        }
        return node;
    }

    public static Group createMainGroup(Project project, Keymap keymap2, QuickList[] quickLists) {
        return ActionsTreeUtil.createMainGroup(project, keymap2, quickLists, null, false, null);
    }

    public static Group createMainGroup(Project project, Keymap keymap2, QuickList[] quickLists, String filter2, boolean forceFiltering, Condition<? super AnAction> filtered2) {
        Condition<AnAction> wrappedFilter = ActionsTreeUtil.wrapFilter(filtered2, keymap2, ActionManager.getInstance());
        Group mainGroup = new Group(KeyMapBundle.message((String)"all.actions.group.title", (Object[])new Object[0]), null, null);
        mainGroup.addGroup(ActionsTreeUtil.createEditorActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createMainMenuGroup(wrappedFilter));
        for (KeymapExtension extension : KeymapExtension.EXTENSION_POINT_NAME.getExtensionList()) {
            Group group = ActionsTreeUtil.createExtensionGroup(wrappedFilter, project, extension);
            if (group == null) continue;
            mainGroup.addGroup(group);
        }
        mainGroup.addGroup(ActionsTreeUtil.createMacrosGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createQuickListsGroup(wrappedFilter, filter2, forceFiltering, quickLists));
        mainGroup.addGroup(ActionsTreeUtil.createPluginsActionsGroup(wrappedFilter));
        mainGroup.addGroup(ActionsTreeUtil.createOtherGroup(wrappedFilter, mainGroup, keymap2));
        if (!StringUtil.isEmpty((String)filter2) || filtered2 != null) {
            ArrayList<Object> list2 = mainGroup.getChildren();
            Iterator<Object> i2 = list2.iterator();
            while (i2.hasNext()) {
                Group group;
                Object o = i2.next();
                if (!(o instanceof Group) || (group = (Group)o).getSize() != 0 || SearchUtil.isComponentHighlighted(group.getName(), filter2, forceFiltering, null)) continue;
                i2.remove();
            }
        }
        return mainGroup;
    }

    private static Condition<AnAction> isActionFiltered(String filter2, boolean force) {
        return action2 -> {
            String id2;
            if (filter2 == null) {
                return true;
            }
            if (action2 == null) {
                return false;
            }
            action2 = ActionsTreeUtil.tryUnstubAction(action2);
            String insensitiveFilter = StringUtil.toLowerCase((String)filter2);
            ArrayList<String> options2 = new ArrayList<String>();
            options2.add(action2.getTemplatePresentation().getText());
            options2.add(action2.getTemplatePresentation().getDescription());
            String string = id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
            if (id2 != null) {
                options2.add(id2);
                options2.addAll(AbbreviationManager.getInstance().getAbbreviations(id2));
            }
            for (String text : options2) {
                String lowerText;
                if (text == null || !SearchUtil.isComponentHighlighted(lowerText = StringUtil.toLowerCase((String)text), insensitiveFilter, force, null) && !lowerText.contains(insensitiveFilter)) continue;
                return true;
            }
            return false;
        };
    }

    private static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Shortcut shortcut) {
        return ActionsTreeUtil.isActionFiltered(actionManager, keymap2, (Condition<? super Shortcut>)((Condition)sc -> sc != null && sc.startsWith(shortcut)));
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Condition<? super Shortcut> predicat) {
        return action2 -> {
            Shortcut[] actionShortcuts;
            if (action2 == null) {
                return false;
            }
            for (Shortcut actionShortcut : actionShortcuts = keymap2.getShortcuts(action2 instanceof ActionStub ? ((ActionStub)action2).getId() : actionManager.getId(action2))) {
                if (!predicat.value((Object)actionShortcut)) continue;
                return true;
            }
            return false;
        };
    }

    public static Condition<AnAction> isActionFiltered(ActionManager actionManager, Keymap keymap2, Shortcut shortcut, String filter2, boolean force) {
        return filter2 != null && filter2.length() > 0 ? ActionsTreeUtil.isActionFiltered(filter2, force) : (shortcut != null ? ActionsTreeUtil.isActionFiltered(actionManager, keymap2, shortcut) : null);
    }

    public static void addAction(KeymapGroup group, AnAction action2, Condition<? super AnAction> filtered2) {
        ActionsTreeUtil.addAction(group, action2, filtered2, false);
    }

    public static void addAction(KeymapGroup group, AnAction action2, Condition<? super AnAction> filtered2, boolean forceNonPopup) {
        if (action2 instanceof ActionGroup) {
            if (forceNonPopup) {
                AnAction[] actions;
                for (AnAction childAction : actions = ActionsTreeUtil.getActions((ActionGroup)action2)) {
                    ActionsTreeUtil.addAction(group, childAction, filtered2, true);
                }
            } else {
                Group subGroup = ActionsTreeUtil.createGroup((ActionGroup)action2, false, filtered2);
                if (subGroup.getSize() > 0) {
                    group.addGroup((KeymapGroup)subGroup);
                }
            }
        } else if (action2 instanceof Separator) {
            if (group instanceof Group) {
                ((Group)group).addSeparator();
            }
        } else if (filtered2 == null || filtered2.value((Object)action2)) {
            String id2 = action2 instanceof ActionStub ? ((ActionStub)action2).getId() : ActionManager.getInstance().getId(action2);
            group.addActionId(id2);
        }
    }

    public static AnAction[] getActions(@NonNls String actionGroup) {
        return ActionsTreeUtil.getActions((ActionGroup)ActionManager.getInstance().getActionOrStub(actionGroup));
    }

    public static AnAction[] getActions(ActionGroup group) {
        return group instanceof DefaultActionGroup ? ((DefaultActionGroup)group).getChildActionsOrStubs() : group.getChildren(null);
    }

    @NotNull
    private static AnAction tryUnstubAction(@NotNull AnAction action2) {
        AnAction newAction;
        if (action2 instanceof ActionStub && (newAction = ActionManager.getInstance().getActionOrStub(((ActionStub)action2).getId())) != null) {
            return newAction;
        }
        return action2;
    }

    public static String getMainMenuTitle() {
        return KeyMapBundle.message((String)"main.menu.action.title", (Object[])new Object[0]);
    }

    public static String getMainToolbar() {
        return KeyMapBundle.message((String)"main.toolbar.title", (Object[])new Object[0]);
    }

    public static String getEditorPopup() {
        return KeyMapBundle.message((String)"editor.popup.menu.title", (Object[])new Object[0]);
    }

    public static String getEditorGutterPopupMenu() {
        return KeyMapBundle.message((String)"editor.gutter.popup.menu", (Object[])new Object[0]);
    }

    public static String getScopeViewPopupMenu() {
        return KeyMapBundle.message((String)"scope.view.popup.menu", (Object[])new Object[0]);
    }

    public static String getNavigationBarPopupMenu() {
        return KeyMapBundle.message((String)"navigation.bar.popup.menu", (Object[])new Object[0]);
    }

    public static String getNavigationBarToolbar() {
        return KeyMapBundle.message((String)"navigation.bar.toolbar", (Object[])new Object[0]);
    }

    public static String getEditorTabPopup() {
        return KeyMapBundle.message((String)"editor.tab.popup.menu.title", (Object[])new Object[0]);
    }

    public static String getFavoritesPopup() {
        return KeyMapBundle.message((String)"favorites.popup.title", (Object[])new Object[0]);
    }

    public static String getProjectViewPopup() {
        return KeyMapBundle.message((String)"project.view.popup.menu.title", (Object[])new Object[0]);
    }

    public static String getCommanderPopup() {
        return KeyMapBundle.message((String)"commender.view.popup.menu.title", (Object[])new Object[0]);
    }

    public static String getJ2EEPopup() {
        return KeyMapBundle.message((String)"j2ee.view.popup.menu.title", (Object[])new Object[0]);
    }
}

