/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.FileSystemInterface;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.BitUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.NotNullFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.BoundedTaskExecutor;
import com.intellij.util.containers.ConcurrentPackedBitsArray;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSetQueue;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

class FileTypeDetectionService
implements Disposable {
    private static final Logger LOG = Logger.getInstance(FileTypeDetectionService.class);
    private static final Key<String> DETECTED_FROM_CONTENT_FILE_TYPE_KEY = Key.create((String)"DETECTED_FROM_CONTENT_FILE_TYPE_KEY");
    private static final byte AUTO_DETECTED_AS_TEXT_MASK = 1;
    private static final byte AUTO_DETECTED_AS_BINARY_MASK = 2;
    private static final byte AUTO_DETECT_WAS_RUN_MASK = 4;
    private static final byte ATTRIBUTES_WERE_LOADED_MASK = 8;
    private final AtomicInteger counterAutoDetect = new AtomicInteger();
    private final AtomicLong elapsedAutoDetect = new AtomicLong();
    private static final int CHUNK_SIZE = 10;
    private static boolean RE_DETECT_ASYNC = !ApplicationManager.getApplication().isUnitTestMode();
    private final Executor reDetectExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"FileTypeManager Redetect Pool", (Executor)PooledThreadExecutor.INSTANCE, (int)1, (Disposable)this);
    private final HashSetQueue<VirtualFile> filesToRedetect = new HashSetQueue();
    private volatile FileAttribute autoDetectedAttribute;
    private final AtomicInteger fileTypeChangedCount;
    private final ConcurrentPackedBitsArray packedFlags = new ConcurrentPackedBitsArray(4);
    private int cachedDetectFileBufferSize = -1;
    private volatile boolean myRestrictCachedDetectedFileTypeAccess;
    private final FileTypeManagerImpl myFileTypeManager;

    FileTypeDetectionService(@NotNull FileTypeManagerImpl fileTypeManager) {
        this.myFileTypeManager = fileTypeManager;
        int fileTypeChangedCounter = PropertiesComponent.getInstance().getInt("fileTypeChangedCounter", 0);
        this.fileTypeChangedCount = new AtomicInteger(fileTypeChangedCounter);
        this.autoDetectedAttribute = new FileAttribute("AUTO_DETECTION_CACHE_ATTRIBUTE", fileTypeChangedCounter, true);
        VirtualFileManager.getInstance().addAsyncFileListener(new AsyncFileListener(){

            @Nullable
            public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
                final Set files2 = ContainerUtil.map2Set(events, event -> {
                    VirtualFile filtered2;
                    ProgressManager.checkCanceled();
                    VirtualFile file2 = event instanceof VFileCreateEvent || this.isReparseEvent((VFileEvent)event) ? null : event.getFile();
                    VirtualFile virtualFile = filtered2 = file2 != null && FileTypeDetectionService.this.wasAutoDetectedBefore(file2) && FileTypeDetectionService.isDetectable(file2) ? file2 : null;
                    if (FileTypeManagerImpl.toLog()) {
                        FileTypeManagerImpl.log("F: after() VFS event " + event + "; filtered file: " + filtered2 + " (file: " + file2 + "; wasAutoDetectedBefore(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeDetectionService.this.wasAutoDetectedBefore(file2))) + "; isDetectable(file): " + (file2 == null ? null : Boolean.valueOf(FileTypeDetectionService.isDetectable(file2))) + "; file.getLength(): " + (file2 == null ? null : Long.valueOf(file2.getLength())) + "; file.isValid(): " + (file2 == null ? null : Boolean.valueOf(file2.isValid())) + "; file.is(VFileProperty.SPECIAL): " + (file2 == null ? null : Boolean.valueOf(file2.is(VFileProperty.SPECIAL))) + "; packedFlags.get(id): " + (file2 instanceof VirtualFileWithId ? FileTypeDetectionService.readableFlags(FileTypeDetectionService.this.packedFlags.get(((VirtualFileWithId)file2).getId())) : null) + "; file.getFileSystem():" + (file2 == null ? null : file2.getFileSystem()) + ")");
                    }
                    return filtered2;
                });
                files2.remove(null);
                if (FileTypeManagerImpl.toLog()) {
                    FileTypeManagerImpl.log("F: after() VFS events: " + events + "; files: " + files2);
                }
                ProgressManager.checkCanceled();
                if (!files2.isEmpty() && RE_DETECT_ASYNC) {
                    if (FileTypeManagerImpl.toLog()) {
                        FileTypeManagerImpl.log("F: after() queued to redetect: " + files2);
                    }
                    for (VirtualFile file2 : files2) {
                        FileTypeDetectionService.this.ensureReDetected(file2);
                    }
                    if (!files2.isEmpty()) {
                        return new AsyncFileListener.ChangeApplier(){

                            public void beforeVfsChange() {
                                FileTypeDetectionService.this.myRestrictCachedDetectedFileTypeAccess = true;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void afterVfsChange() {
                                try {
                                    HashSetQueue hashSetQueue = FileTypeDetectionService.this.filesToRedetect;
                                    synchronized (hashSetQueue) {
                                        if (FileTypeDetectionService.this.filesToRedetect.addAll(files2)) {
                                            FileTypeDetectionService.this.awakeReDetectExecutor();
                                        }
                                    }
                                }
                                finally {
                                    FileTypeDetectionService.this.myRestrictCachedDetectedFileTypeAccess = false;
                                }
                            }
                        };
                    }
                }
                return null;
            }

            private boolean isReparseEvent(@NotNull VFileEvent event) {
                return event instanceof VFilePropertyChangeEvent && "FileContentUtilCore.saveOrReload".equals(event.getRequestor());
            }
        }, (Disposable)this);
        FileTypeRegistry.FileTypeDetector.EP_NAME.addChangeListener(() -> {
            this.cachedDetectFileBufferSize = -1;
            this.clearCaches();
        }, (Disposable)this);
        Application app = ApplicationManager.getApplication();
        Disposer.register((Disposable)app, (Disposable)this);
    }

    @NotNull
    FileType getOrDetectFromContent(@NotNull VirtualFile file2, byte @Nullable [] content2) {
        if (!FileTypeDetectionService.isDetectable(file2)) {
            return UnknownFileType.INSTANCE;
        }
        if (this.myRestrictCachedDetectedFileTypeAccess) {
            try {
                return this.detectFromContent(file2, content2);
            }
            catch (IOException e) {
                return UnknownFileType.INSTANCE;
            }
        }
        this.ensureReDetected(file2);
        if (file2 instanceof VirtualFileWithId) {
            boolean autoDetectWasRun;
            int id2 = ((VirtualFileWithId)file2).getId();
            long flags = this.packedFlags.get(id2);
            if (!BitUtil.isSet((long)flags, (long)8L)) {
                flags = this.readFlagsFromCache(file2);
                flags = BitUtil.set((long)flags, (long)8L, (boolean)true);
                this.packedFlags.set(id2, flags);
                if (FileTypeManagerImpl.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): readFlagsFromCache() = " + FileTypeDetectionService.readableFlags(flags));
                }
            }
            if (autoDetectWasRun = BitUtil.isSet((long)flags, (long)4L)) {
                FileType type = FileTypeDetectionService.textOrBinaryFromCachedFlags(flags);
                if (FileTypeManagerImpl.toLog()) {
                    FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): cached type = " + (type == null ? null : type.getName()) + "; packedFlags.get(id):" + FileTypeDetectionService.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                if (type != null) {
                    return type;
                }
            }
        }
        FileType fileType = this.getFileTypeDetectedFromContent(file2);
        if (FileTypeManagerImpl.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) = " + (fileType == null ? null : fileType.getName()));
        }
        if (fileType == null) {
            try {
                fileType = this.detectFromContentAndCache(file2, content2);
            }
            catch (IOException e) {
                fileType = UnknownFileType.INSTANCE;
            }
        }
        if (FileTypeManagerImpl.toLog()) {
            FileTypeManagerImpl.log("F: getOrDetectFromContent(" + file2.getName() + "): getFileType after detect run = " + fileType.getName());
        }
        return fileType;
    }

    void loadState(Element state) {
        String fileTypeChangedCounterStr = JDOMExternalizer.readString((Element)state, (String)"fileTypeChangedCounter");
        if (fileTypeChangedCounterStr != null) {
            int fileTypeChangedCounter = StringUtilRt.parseInt((String)fileTypeChangedCounterStr, (int)0);
            this.fileTypeChangedCount.set(fileTypeChangedCounter);
            this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(this.fileTypeChangedCount.get());
        }
    }

    void clearCaches() {
        this.packedFlags.clear();
        this.clearPersistentAttributes();
        if (FileTypeManagerImpl.toLog()) {
            FileTypeManagerImpl.log("F: clearCaches()");
        }
    }

    public void dispose() {
        LOG.info(String.format("%s auto-detected files. Detection took %s ms", this.counterAutoDetect, this.elapsedAutoDetect));
    }

    static boolean isDetectable(@NotNull VirtualFile file2) {
        if (file2.isDirectory() || !file2.isValid() || file2.is(VFileProperty.SPECIAL) || file2.getLength() == 0L) {
            return false;
        }
        return file2.getFileSystem() instanceof FileSystemInterface;
    }

    private byte readFlagsFromCache(@NotNull VirtualFile file2) {
        boolean wasAutoDetectRun = false;
        byte status = 0;
        try (DataInputStream stream = this.autoDetectedAttribute.readAttribute(file2);){
            status = stream == null ? (byte)0 : stream.readByte();
            wasAutoDetectRun = stream != null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        status = BitUtil.set((byte)status, (byte)4, (boolean)wasAutoDetectRun);
        return (byte)(status & 7);
    }

    private void writeFlagsToCache(@NotNull VirtualFile file2, int flags) {
        try (DataOutputStream stream = this.autoDetectedAttribute.writeAttribute(file2);){
            stream.writeByte(flags & 3);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private void clearPersistentAttributes() {
        int count = this.fileTypeChangedCount.incrementAndGet();
        this.autoDetectedAttribute = this.autoDetectedAttribute.newVersion(count);
        PropertiesComponent.getInstance().setValue("fileTypeChangedCounter", Integer.toString(count));
        if (FileTypeManagerImpl.toLog()) {
            FileTypeManagerImpl.log("F: clearPersistentAttributes()");
        }
    }

    private void cacheAutoDetectedFileType(@NotNull VirtualFile file2, @NotNull FileType fileType) {
        boolean wasAutodetectedAsText = fileType == PlainTextFileType.INSTANCE;
        boolean wasAutodetectedAsBinary = fileType == UnknownFileType.INSTANCE;
        int flags = BitUtil.set((int)0, (int)1, (boolean)wasAutodetectedAsText);
        flags = BitUtil.set((int)flags, (int)2, (boolean)wasAutodetectedAsBinary);
        this.writeFlagsToCache(file2, flags);
        if (file2 instanceof VirtualFileWithId) {
            int id2 = ((VirtualFileWithId)file2).getId();
            flags = BitUtil.set((int)flags, (int)4, (boolean)true);
            flags = BitUtil.set((int)flags, (int)8, (boolean)true);
            this.packedFlags.set(id2, (long)flags);
            if (wasAutodetectedAsText || wasAutodetectedAsBinary) {
                file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                if (FileTypeManagerImpl.toLog()) {
                    FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeDetectionService.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                return;
            }
        }
        file2.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, (Object)fileType.getName());
        if (FileTypeManagerImpl.toLog()) {
            FileTypeManagerImpl.log("F: cacheAutoDetectedFileType(" + file2.getName() + ") cached to " + fileType.getName() + " flags = " + FileTypeDetectionService.readableFlags(flags) + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
        }
    }

    private void awakeReDetectExecutor() {
        this.reDetectExecutor.execute(() -> {
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(10);
            HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
            synchronized (hashSetQueue) {
                VirtualFile file2;
                for (int i2 = 0; i2 < 10 && (file2 = (VirtualFile)this.filesToRedetect.poll()) != null; ++i2) {
                    files2.add(file2);
                }
            }
            if (files2.size() == 10) {
                this.awakeReDetectExecutor();
            }
            this.reDetect(files2);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureReDetected(@NotNull VirtualFile file2) {
        boolean submitted;
        ProgressManager.checkCanceled();
        HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
        synchronized (hashSetQueue) {
            submitted = this.filesToRedetect.remove((Object)file2);
        }
        if (submitted) {
            this.reDetect(Collections.singleton(file2));
        }
    }

    @Nullable
    private FileType getFileTypeDetectedFromContent(VirtualFile file2) {
        String fileTypeName = (String)file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY);
        return fileTypeName == null ? null : this.myFileTypeManager.findFileTypeByName(fileTypeName);
    }

    private void reDetect(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2.isEmpty()) {
            return;
        }
        try {
            ArrayList<VirtualFile> changed2 = new ArrayList<VirtualFile>();
            ArrayList<VirtualFile> crashed = new ArrayList<VirtualFile>();
            for (VirtualFile virtualFile : files2) {
                FileType after2;
                FileType before;
                block12: {
                    if (FileTypeManagerImpl.toLog()) {
                        FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") " + virtualFile.getName());
                    }
                    int id2 = ((VirtualFileWithId)virtualFile).getId();
                    long flags = this.packedFlags.get(id2);
                    before = (FileType)ObjectUtils.notNull((Object)FileTypeDetectionService.textOrBinaryFromCachedFlags(flags), (Object)ObjectUtils.notNull((Object)this.getFileTypeDetectedFromContent(virtualFile), (Object)PlainTextFileType.INSTANCE));
                    after2 = this.myFileTypeManager.getByFile(virtualFile);
                    if (FileTypeManagerImpl.toLog()) {
                        FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") prepare to redetect. flags: " + FileTypeDetectionService.readableFlags(flags) + "; beforeType: " + before.getName() + "; afterByFileType: " + (after2 == null ? null : after2.getName()));
                    }
                    if (after2 == null || FileTypeManagerImpl.mightBeReplacedByDetectedFileType(after2)) {
                        try {
                            after2 = this.detectFromContentAndCache(virtualFile, null);
                            break block12;
                        }
                        catch (IOException e) {
                            crashed.add(virtualFile);
                            if (!FileTypeManagerImpl.toLog()) continue;
                            FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") before: " + before.getName() + "; after: crashed with " + e.getMessage() + "; now getFileType()=" + virtualFile.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                            continue;
                        }
                    }
                    virtualFile.putUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY, null);
                    flags = 0L;
                    this.packedFlags.set(id2, flags);
                }
                if (FileTypeManagerImpl.toLog()) {
                    FileTypeManagerImpl.log("F: reDetect(" + virtualFile.getName() + ") before: " + before.getName() + "; after: " + after2.getName() + "; now getFileType()=" + virtualFile.getFileType().getName() + "; getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY): " + (String)virtualFile.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY));
                }
                if (before == after2) continue;
                changed2.add(virtualFile);
            }
            if (!changed2.isEmpty()) {
                FileTypeDetectionService.reparseLater(changed2);
            }
            if (!crashed.isEmpty()) {
                AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> FileTypeDetectionService.reparseLater(crashed), 10L, TimeUnit.SECONDS);
            }
        }
        catch (ProcessCanceledException e) {
            LOG.error("ProcessCanceledException should not be thrown while re-detection", new Attachment[]{new Attachment("pce", (Throwable)e)});
            throw e;
        }
    }

    private boolean wasAutoDetectedBefore(@NotNull VirtualFile file2) {
        if (file2.getUserData(DETECTED_FROM_CONTENT_FILE_TYPE_KEY) != null) {
            return true;
        }
        if (file2 instanceof VirtualFileWithId) {
            int id2 = ((VirtualFileWithId)file2).getId();
            return (this.packedFlags.get(id2) & 6L) == 4L;
        }
        return false;
    }

    @NotNull
    private FileType detectFromContentAndCache(@NotNull VirtualFile file2, byte @Nullable [] content2) throws IOException {
        long start2 = System.currentTimeMillis();
        FileType fileType = this.detectFromContent(file2, content2);
        this.cacheAutoDetectedFileType(file2, fileType);
        this.counterAutoDetect.incrementAndGet();
        long elapsed = System.currentTimeMillis() - start2;
        this.elapsedAutoDetect.addAndGet(elapsed);
        return fileType;
    }

    private static int readSafely(@NotNull InputStream stream, byte @NotNull [] buffer, int length) throws IOException {
        int n = stream.read(buffer, 0, length);
        if (n <= 0) {
            if (FileTypeManagerImpl.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): inputStream.read() returned " + n + "; retrying with read action. stream=" + FileTypeDetectionService.streamInfo(stream));
            }
            n = (Integer)ReadAction.compute(() -> stream.read(buffer, 0, length));
            if (FileTypeManagerImpl.toLog()) {
                FileTypeManagerImpl.log("F: processFirstBytes(): under read action inputStream.read() returned " + n + "; stream=" + FileTypeDetectionService.streamInfo(stream));
            }
        }
        return n;
    }

    @NotNull
    private FileType detectFromContent(@NotNull VirtualFile file2, byte @Nullable [] content2) throws IOException {
        FileType fileType;
        block28: {
            List detectors = FileTypeRegistry.FileTypeDetector.EP_NAME.getExtensionList();
            if (content2 != null) {
                fileType = this.detect(file2, content2, content2.length, detectors);
            } else {
                try (InputStream inputStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                    if (FileTypeManagerImpl.toLog()) {
                        FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): inputStream=" + FileTypeDetectionService.streamInfo(inputStream));
                    }
                    int fileLength = (int)file2.getLength();
                    int bufferLength = this.getDetectFileBufferSize();
                    byte[] buffer = fileLength <= 20480 ? FileUtilRt.getThreadLocalBuffer() : new byte[Math.min(fileLength, bufferLength)];
                    int n = FileTypeDetectionService.readSafely(inputStream, buffer, buffer.length);
                    fileType = this.detect(file2, buffer, n, detectors);
                    if (!FileTypeManagerImpl.toLog()) break block28;
                    try (InputStream newStream = ((FileSystemInterface)file2.getFileSystem()).getInputStream(file2);){
                        byte[] buffer2 = new byte[50];
                        int n2 = newStream.read(buffer2, 0, buffer2.length);
                        FileTypeManagerImpl.log("F: detectFromContentAndCache(" + file2.getName() + "): result: " + fileType.getName() + "; stream: " + FileTypeDetectionService.streamInfo(inputStream) + "; newStream: " + FileTypeDetectionService.streamInfo(newStream) + "; read: " + n2 + "; buffer: " + Arrays.toString(buffer2));
                    }
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(file2 + "; type=" + fileType.getDescription() + "; " + this.counterAutoDetect);
        }
        return fileType;
    }

    @NotNull
    private FileType detect(@NotNull VirtualFile file2, byte @NotNull [] bytes, int length, @NotNull List<? extends FileTypeRegistry.FileTypeDetector> detectors) {
        if (length <= 0) {
            return UnknownFileType.INSTANCE;
        }
        return LoadTextUtil.processTextFromBinaryPresentationOrNull(bytes, length, file2, true, true, (FileType)PlainTextFileType.INSTANCE, (NotNullFunction<? super CharSequence, ? extends FileType>)((NotNullFunction)text -> {
            if (FileTypeManagerImpl.toLog()) {
                FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): bytes length=" + length + "; isText=" + (text != null) + "; text='" + (text == null ? null : StringUtil.first((CharSequence)text, (int)100, (boolean)true)) + "', detectors=" + detectors);
            }
            Object detected = null;
            ByteArraySequence firstBytes = new ByteArraySequence(bytes, 0, length);
            for (FileTypeRegistry.FileTypeDetector detector : detectors) {
                try {
                    detected = detector.detect(file2, (ByteSequence)firstBytes, text);
                }
                catch (ProcessCanceledException e) {
                    LOG.error("Detector " + detector + " (" + detector.getClass() + ") threw PCE. Bad detector, bad!", (Throwable)new RuntimeException(e));
                }
                catch (Exception e) {
                    LOG.error("Detector " + detector + " (" + detector.getClass() + ") exception occurred:", (Throwable)e);
                }
                if (detected == null) continue;
                if (!FileTypeManagerImpl.toLog()) break;
                FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): detector " + detector + " type as " + detected.getName());
                break;
            }
            if (detected == null && text != null) {
                detected = (FileType)this.myFileTypeManager.myPatternsTable.findAssociatedFileTypeByHashBang(text);
            }
            if (detected == null) {
                Object object = detected = text == null ? UnknownFileType.INSTANCE : PlainTextFileType.INSTANCE;
                if (FileTypeManagerImpl.toLog()) {
                    FileTypeManagerImpl.log("F: detectFromContentAndCache.processFirstBytes(" + file2.getName() + "): no detector was able to detect. assigned " + detected.getName());
                }
            }
            return detected;
        }));
    }

    private int getDetectFileBufferSize() {
        int bufferLength = this.cachedDetectFileBufferSize;
        if (bufferLength == -1) {
            List detectors = FileTypeRegistry.FileTypeDetector.EP_NAME.getExtensionList();
            for (int i2 = 0; i2 < detectors.size(); ++i2) {
                FileTypeRegistry.FileTypeDetector detector = (FileTypeRegistry.FileTypeDetector)detectors.get(i2);
                bufferLength = Math.max(bufferLength, detector.getDesiredContentPrefixLength());
            }
            if (bufferLength <= 0) {
                bufferLength = FileUtilRt.getUserContentLoadLimit();
            }
            this.cachedDetectFileBufferSize = bufferLength;
        }
        return bufferLength;
    }

    @NotNull
    private static String readableFlags(long flags) {
        String result2 = "";
        if (BitUtil.isSet((long)flags, (long)8L)) {
            result2 = result2 + "ATTRIBUTES_WERE_LOADED_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)4L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECT_WAS_RUN_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)2L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_BINARY_MASK";
        }
        if (BitUtil.isSet((long)flags, (long)1L)) {
            result2 = result2 + (result2.isEmpty() ? "" : " | ") + "AUTO_DETECTED_AS_TEXT_MASK";
        }
        return result2;
    }

    @Nullable
    private static FileType textOrBinaryFromCachedFlags(long flags) {
        return BitUtil.isSet((long)flags, (long)1L) ? PlainTextFileType.INSTANCE : (BitUtil.isSet((long)flags, (long)2L) ? UnknownFileType.INSTANCE : null);
    }

    private static void reparseLater(@NotNull List<? extends VirtualFile> changed2) {
        ApplicationManager.getApplication().invokeLater(() -> FileContentUtilCore.reparseFiles((Collection)changed2), ApplicationManager.getApplication().getDisposed());
    }

    @NonNls
    private static Object streamInfo(@NotNull InputStream stream) throws IOException {
        if (stream instanceof BufferedInputStream) {
            InputStream in = (InputStream)ReflectionUtil.getField(stream.getClass(), (Object)stream, InputStream.class, (String)"in");
            byte[] buf = (byte[])ReflectionUtil.getField(stream.getClass(), (Object)stream, byte[].class, (String)"buf");
            int count = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"count");
            int pos = (Integer)ReflectionUtil.getField(stream.getClass(), (Object)stream, Integer.TYPE, (String)"pos");
            return "BufferedInputStream(buf=" + (buf == null ? null : Arrays.toString(Arrays.copyOf(buf, count))) + ", count=" + count + ", pos=" + pos + ", in=" + FileTypeDetectionService.streamInfo(in) + ")";
        }
        if (stream instanceof FileInputStream) {
            String path = (String)ReflectionUtil.getField(stream.getClass(), (Object)stream, String.class, (String)"path");
            FileChannel channel = (FileChannel)ReflectionUtil.getField(stream.getClass(), (Object)stream, FileChannel.class, (String)"channel");
            boolean closed = (Boolean)ReflectionUtil.getField(stream.getClass(), (Object)stream, Boolean.TYPE, (String)"closed");
            int available = stream.available();
            File file2 = new File(path);
            return "FileInputStream(path=" + path + ", available=" + available + ", closed=" + closed + ", channel=" + channel + ", channel.size=" + (channel == null ? null : Long.valueOf(channel.size())) + ", file.exists=" + file2.exists() + ", file.content='" + FileUtil.loadFile((File)file2) + "')";
        }
        return stream;
    }

    void drainReDetectQueue() {
        try {
            ((BoundedTaskExecutor)this.reDetectExecutor).waitAllTasksExecuted(1L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    Collection<VirtualFile> dumpReDetectQueue() {
        HashSetQueue<VirtualFile> hashSetQueue = this.filesToRedetect;
        synchronized (hashSetQueue) {
            return new ArrayList<VirtualFile>((Collection<VirtualFile>)this.filesToRedetect);
        }
    }

    static void reDetectAsync(boolean enable) {
        RE_DETECT_ASYNC = enable;
    }
}

