/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeInsight.daemon.impl.TextEditorBackgroundHighlighter;
import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.fileEditor.impl.text.CodeFoldingState;
import com.intellij.openapi.fileEditor.impl.text.PsiAwareTextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import java.util.function.Supplier;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PsiAwareTextEditorProvider
extends TextEditorProvider {
    @NonNls
    private static final String FOLDING_ELEMENT = "folding";

    @Override
    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        return new PsiAwareTextEditorImpl(project, file2, this);
    }

    @Override
    @NotNull
    public FileEditorState readState(@NotNull Element element2, @NotNull Project project, @NotNull VirtualFile file2) {
        TextEditorState state = (TextEditorState)super.readState(element2, project, file2);
        Element child2 = element2.getChild(FOLDING_ELEMENT);
        if (child2 != null) {
            Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
            if (document == null) {
                state.setDelayedFoldState(new MyDelayedFoldingState(project, file2, child2));
            } else {
                state.setFoldingState(CodeFoldingManager.getInstance(project).readFoldingState(child2, document));
            }
        }
        return state;
    }

    @Override
    public void writeState(@NotNull FileEditorState _state, @NotNull Project project, @NotNull Element element2) {
        super.writeState(_state, project, element2);
        TextEditorState state = (TextEditorState)_state;
        CodeFoldingState foldingState = state.getFoldingState();
        if (foldingState != null) {
            Element e = new Element(FOLDING_ELEMENT);
            try {
                CodeFoldingManager.getInstance(project).writeFoldingState(foldingState, e);
            }
            catch (WriteExternalException writeExternalException) {
                // empty catch block
            }
            if (!JDOMUtil.isEmpty((Element)e)) {
                element2.addContent(e);
            }
        } else {
            Supplier<CodeFoldingState> delayedProducer = state.getDelayedFoldState();
            if (delayedProducer instanceof MyDelayedFoldingState) {
                element2.addContent(((MyDelayedFoldingState)delayedProducer).getSerializedState());
            }
        }
    }

    @Override
    @NotNull
    protected TextEditorState getStateImpl(Project project, @NotNull Editor editor, @NotNull FileEditorStateLevel level) {
        TextEditorState state = super.getStateImpl(project, editor, level);
        if (FileEditorStateLevel.FULL == level) {
            if (project != null && !project.isDisposed() && !editor.isDisposed() && project.isInitialized()) {
                state.setFoldingState(CodeFoldingManager.getInstance(project).saveFoldingState(editor));
            } else {
                state.setFoldingState(null);
            }
        }
        return state;
    }

    @Override
    protected void setStateImpl(Project project, Editor editor, TextEditorState state, boolean exactState) {
        super.setStateImpl(project, editor, state, exactState);
        CodeFoldingState foldState = state.getFoldingState();
        if (project != null && foldState != null && AsyncEditorLoader.isEditorLoaded(editor)) {
            if (!PsiDocumentManager.getInstance((Project)project).isCommitted(editor.getDocument())) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                LOG.error("File should be parsed when changing editor state, otherwise UI might be frozen for a considerable time");
            }
            editor.getFoldingModel().runBatchFoldingOperation(() -> CodeFoldingManager.getInstance(project).restoreFoldingState(editor, foldState));
        }
    }

    @Override
    @NotNull
    protected TextEditorProvider.EditorWrapper createWrapperForEditor(@NotNull Editor editor) {
        return new PsiAwareEditorWrapper(editor);
    }

    private static final class MyDelayedFoldingState
    implements Supplier<CodeFoldingState> {
        private final Project myProject;
        private final VirtualFile myFile;
        private final Element mySerializedState;

        private MyDelayedFoldingState(Project project, VirtualFile file2, Element state) {
            this.myProject = project;
            this.myFile = file2;
            this.mySerializedState = JDOMUtil.internElement((Element)state);
        }

        @Override
        public CodeFoldingState get() {
            Document document = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
            return document == null ? null : CodeFoldingManager.getInstance(this.myProject).readFoldingState(this.mySerializedState, document);
        }

        private Element getSerializedState() {
            return this.mySerializedState.clone();
        }
    }

    private final class PsiAwareEditorWrapper
    extends TextEditorProvider.EditorWrapper {
        private final TextEditorBackgroundHighlighter myBackgroundHighlighter;

        private PsiAwareEditorWrapper(Editor editor) {
            super(PsiAwareTextEditorProvider.this, editor);
            Project project = editor.getProject();
            this.myBackgroundHighlighter = project == null ? null : new TextEditorBackgroundHighlighter(project, editor);
        }

        @Override
        public BackgroundEditorHighlighter getBackgroundHighlighter() {
            return this.myBackgroundHighlighter;
        }

        @Override
        public boolean isValid() {
            return !this.getEditor().isDisposed();
        }
    }
}

