/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.text;

import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.text.TextEditorComponent;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class AsyncEditorLoader {
    private static final ExecutorService ourExecutor = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"AsyncEditorLoader Pool", (int)2);
    private static final Key<AsyncEditorLoader> ASYNC_LOADER = Key.create((String)"ASYNC_LOADER");
    private static final int SYNCHRONOUS_LOADING_WAITING_TIME_MS = 200;
    private static final int DOCUMENT_COMMIT_WAITING_TIME_MS = 5000;
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final TextEditorImpl myTextEditor;
    @NotNull
    private final TextEditorComponent myEditorComponent;
    @NotNull
    private final TextEditorProvider myProvider;
    private final List<Runnable> myDelayedActions = new ArrayList<Runnable>();
    private TextEditorState myDelayedState;
    private final AtomicBoolean myLoadingFinished = new AtomicBoolean();

    AsyncEditorLoader(@NotNull TextEditorImpl textEditor, @NotNull TextEditorComponent component2, @NotNull TextEditorProvider provider) {
        this.myProvider = provider;
        this.myTextEditor = textEditor;
        this.myProject = textEditor.myProject;
        this.myEditorComponent = component2;
        this.myEditor = textEditor.getEditor();
        this.myEditor.putUserData(ASYNC_LOADER, (Object)this);
        this.myEditorComponent.getContentPanel().setVisible(false);
    }

    void start() {
        Runnable continuation;
        ApplicationManager.getApplication().assertIsDispatchThread();
        Future<Runnable> asyncLoading = this.scheduleLoading();
        boolean showProgress = true;
        if (this.worthWaiting() && (continuation = AsyncEditorLoader.resultInTimeOrNull(asyncLoading)) != null) {
            showProgress = false;
            this.loadingFinished(continuation);
        }
        if (showProgress) {
            this.myEditorComponent.startLoading();
        }
    }

    private Future<Runnable> scheduleLoading() {
        long commitDeadline = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(5000L);
        CompletableFuture<Runnable> future2 = new CompletableFuture<Runnable>();
        ReadAction.nonBlocking(() -> {
            this.waitForCommit(commitDeadline);
            Runnable runnable2 = (Runnable)ProgressManager.getInstance().computePrioritized(() -> {
                try {
                    return this.myTextEditor.loadEditorInBackground();
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (IndexOutOfBoundsException e) {
                    Attachment filePathAttachment = new Attachment("filePath.txt", this.myTextEditor.getFile().toString());
                    Attachment threadDumpAttachment = new Attachment("threadDump.txt", ThreadDumper.dumpThreadsToString());
                    threadDumpAttachment.setIncluded(true);
                    Logger.getInstance(AsyncEditorLoader.class).error("Error during async editor loading", (Throwable)e, new Attachment[]{filePathAttachment, threadDumpAttachment});
                    return null;
                }
                catch (Exception e) {
                    Logger.getInstance(AsyncEditorLoader.class).error("Error during async editor loading", (Throwable)e);
                    return null;
                }
            });
            future2.complete(runnable2);
            return runnable2;
        }).expireWith((Disposable)this.myEditorComponent).expireWith((Disposable)this.myProject).finishOnUiThread(ModalityState.any(), result2 -> this.loadingFinished((Runnable)result2)).submit((Executor)ourExecutor);
        return future2;
    }

    private void waitForCommit(long commitDeadlineNs) {
        Document document = this.myEditor.getDocument();
        PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)this.myProject);
        if (!pdm.isCommitted(document) && System.nanoTime() < commitDeadlineNs) {
            Semaphore semaphore = new Semaphore(1);
            pdm.performForCommittedDocument(document, () -> ((Semaphore)semaphore).up());
            while (System.nanoTime() < commitDeadlineNs && !semaphore.waitFor(10L)) {
                ProgressManager.checkCanceled();
            }
        }
    }

    private boolean isDone() {
        return this.myLoadingFinished.get();
    }

    private boolean worthWaiting() {
        return !PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments() && !ApplicationManager.getApplication().isWriteAccessAllowed() && !EditorsSplitters.isOpenedInBulk(this.myTextEditor.myFile);
    }

    private static <T> T resultInTimeOrNull(@NotNull Future<T> future2) {
        try {
            return future2.get(200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException exception) {
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private void loadingFinished(Runnable continuation) {
        if (!this.myLoadingFinished.compareAndSet(false, true)) {
            return;
        }
        this.myEditor.putUserData(ASYNC_LOADER, null);
        if (this.myEditorComponent.isDisposed()) {
            return;
        }
        if (continuation != null) {
            continuation.run();
        }
        this.myEditorComponent.loadingFinished();
        if (this.myDelayedState != null && PsiDocumentManager.getInstance((Project)this.myProject).isCommitted(this.myEditor.getDocument())) {
            TextEditorState state = new TextEditorState();
            state.RELATIVE_CARET_POSITION = Integer.MAX_VALUE;
            state.setFoldingState(this.myDelayedState.getFoldingState());
            this.myProvider.setStateImpl(this.myProject, this.myEditor, state, true);
            this.myDelayedState = null;
        }
        for (Runnable runnable2 : this.myDelayedActions) {
            this.myEditor.getScrollingModel().disableAnimation();
            runnable2.run();
        }
        this.myDelayedActions.clear();
        this.myEditor.getScrollingModel().enableAnimation();
        if (FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor() == this.myEditor) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocusInProject((Component)this.myTextEditor.getPreferredFocusedComponent(), this.myProject);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateNotifications(this.myTextEditor.myFile);
    }

    public static void performWhenLoaded(@NotNull Editor editor, @NotNull Runnable runnable2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        AsyncEditorLoader loader = (AsyncEditorLoader)editor.getUserData(ASYNC_LOADER);
        if (loader == null) {
            runnable2.run();
        } else {
            loader.myDelayedActions.add(runnable2);
        }
    }

    @NotNull
    TextEditorState getEditorState(@NotNull FileEditorStateLevel level) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TextEditorState state = this.myProvider.getStateImpl(this.myProject, this.myEditor, level);
        if (!this.isDone() && this.myDelayedState != null) {
            state.setDelayedFoldState(this.myDelayedState::getFoldingState);
        }
        return state;
    }

    void setEditorState(@NotNull TextEditorState state, boolean exactState) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (!this.isDone()) {
            this.myDelayedState = state;
        }
        this.myProvider.setStateImpl(this.myProject, this.myEditor, state, exactState);
    }

    public static boolean isEditorLoaded(@NotNull Editor editor) {
        return editor.getUserData(ASYNC_LOADER) == null;
    }
}

