/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl.http;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.BaseRemoteFileEditor;
import com.intellij.openapi.fileEditor.impl.http.RemoteFilePanel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfoImpl;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HttpFileEditor
extends BaseRemoteFileEditor {
    private final RemoteFilePanel myPanel;

    HttpFileEditor(@NotNull Project project, @NotNull HttpVirtualFile virtualFile) {
        super(project);
        this.myPanel = new RemoteFilePanel(project, virtualFile, this);
        RemoteFileInfoImpl fileInfo = (RemoteFileInfoImpl)virtualFile.getFileInfo();
        assert (fileInfo != null);
        fileInfo.download().onSuccess(file2 -> ApplicationManager.getApplication().invokeLater(() -> this.contentLoaded(), this.myProject.getDisposed())).onError(throwable -> this.contentRejected());
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel.getMainPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        TextEditor textEditor = this.myPanel.getFileEditor();
        if (textEditor != null) {
            return textEditor.getPreferredFocusedComponent();
        }
        return this.myPanel.getMainPanel();
    }

    @NotNull
    public String getName() {
        return "Http";
    }

    public void selectNotify() {
        this.myPanel.selectNotify();
    }

    public void deselectNotify() {
        this.myPanel.deselectNotify();
    }

    @Override
    @Nullable
    protected TextEditor getTextEditor() {
        return this.myPanel.getFileEditor();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myPanel.dispose();
    }
}

