/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.UniqueVFilePathBuilder;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.UniqueNameBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import gnu.trove.THashSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UniqueVFilePathBuilderImpl
extends UniqueVFilePathBuilder {
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameBuilderCacheKey = Key.create((String)"project's.short.file.name.builder");
    private static final Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> ourShortNameOpenedBuilderCacheKey = Key.create((String)"project's.short.file.name.opened.builder");
    private static final UniqueNameBuilder<VirtualFile> ourEmptyBuilder = new UniqueNameBuilder(null, null, -1);

    @NotNull
    public String getUniqueVirtualFilePath(@NotNull Project project, @NotNull VirtualFile file2, @NotNull GlobalSearchScope scope) {
        return UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, file2, false, scope);
    }

    @NotNull
    public String getUniqueVirtualFilePath(@NotNull Project project, @NotNull VirtualFile vFile) {
        return this.getUniqueVirtualFilePath(project, vFile, GlobalSearchScope.projectScope((Project)project));
    }

    @NotNull
    public String getUniqueVirtualFilePathWithinOpenedFileEditors(@NotNull Project project, @NotNull VirtualFile vFile) {
        return UniqueVFilePathBuilderImpl.getUniqueVirtualFilePath(project, vFile, true, GlobalSearchScope.projectScope((Project)project));
    }

    private static String getUniqueVirtualFilePath(Project project, VirtualFile file2, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        UniqueNameBuilder<VirtualFile> builder2 = UniqueVFilePathBuilderImpl.getUniqueVirtualFileNameBuilder(project, file2, skipNonOpenedFiles, scope);
        if (builder2 != null) {
            return builder2.getShortPath((Object)file2);
        }
        return file2 instanceof VirtualFilePathWrapper ? file2.getPresentableName() : file2.getName();
    }

    @Nullable
    private static UniqueNameBuilder<VirtualFile> getUniqueVirtualFileNameBuilder(Project project, VirtualFile file2, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        String fileName;
        UniqueNameBuilder<VirtualFile> uniqueNameBuilderForShortName;
        ConcurrentMap scope2ValueMap;
        Map valueMap;
        Key<CachedValue<Map<GlobalSearchScope, Map<String, UniqueNameBuilder<VirtualFile>>>>> key = skipNonOpenedFiles ? ourShortNameOpenedBuilderCacheKey : ourShortNameBuilderCacheKey;
        CachedValue data2 = (CachedValue)project.getUserData(key);
        if (data2 == null) {
            data2 = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result(new ConcurrentHashMap(2), new Object[]{DumbService.getInstance((Project)project), UniqueVFilePathBuilderImpl.getFilenameIndexModificationTracker(project), FileEditorManagerImpl.OPEN_FILE_SET_MODIFICATION_COUNT}), false);
            project.putUserData(key, (Object)data2);
        }
        if ((valueMap = (Map)(scope2ValueMap = (ConcurrentMap)data2.getValue()).get(scope)) == null) {
            valueMap = (Map)ConcurrencyUtil.cacheOrGet((ConcurrentMap)scope2ValueMap, (Object)scope, (Object)ContainerUtil.createConcurrentSoftValueMap());
        }
        if ((uniqueNameBuilderForShortName = (UniqueNameBuilder<VirtualFile>)valueMap.get(fileName = file2.getName())) == null) {
            UniqueNameBuilder<VirtualFile> builder2 = UniqueVFilePathBuilderImpl.filesWithTheSameName(fileName, project, skipNonOpenedFiles, scope);
            valueMap.put(fileName, builder2 != null ? builder2 : ourEmptyBuilder);
            uniqueNameBuilderForShortName = builder2;
        } else if (uniqueNameBuilderForShortName == ourEmptyBuilder) {
            uniqueNameBuilderForShortName = null;
        }
        if (uniqueNameBuilderForShortName != null && uniqueNameBuilderForShortName.contains((Object)file2)) {
            return uniqueNameBuilderForShortName;
        }
        return null;
    }

    @NotNull
    private static ModificationTracker getFilenameIndexModificationTracker(@NotNull Project project) {
        return () -> (Long)UniqueVFilePathBuilderImpl.disableIndexUpToDateCheckInEdt(() -> FileBasedIndex.getInstance().getIndexModificationStamp(FilenameIndex.NAME, project));
    }

    @Nullable
    private static UniqueNameBuilder<VirtualFile> filesWithTheSameName(String fileName, Project project, boolean skipNonOpenedFiles, GlobalSearchScope scope) {
        THashSet filesWithSameName = skipNonOpenedFiles ? Collections.emptySet() : UniqueVFilePathBuilderImpl.getFilesByNameFromIndex(fileName, project, scope);
        THashSet setOfFilesWithTheSameName = new THashSet(filesWithSameName);
        for (VirtualFile openFile2 : FileEditorManager.getInstance((Project)project).getOpenFiles()) {
            if (!openFile2.getName().equals(fileName)) continue;
            setOfFilesWithTheSameName.add((Object)openFile2);
        }
        if (!skipNonOpenedFiles) {
            for (VirtualFile recentlyEditedFile : EditorHistoryManager.getInstance(project).getFileList()) {
                if (!recentlyEditedFile.getName().equals(fileName)) continue;
                setOfFilesWithTheSameName.add((Object)recentlyEditedFile);
            }
        }
        if ((filesWithSameName = setOfFilesWithTheSameName).size() > 1) {
            String path = project.getBasePath();
            path = path == null ? "" : FileUtil.toSystemIndependentName((String)path);
            UniqueNameBuilder builder2 = new UniqueNameBuilder(path, File.separator, 25);
            for (VirtualFile virtualFile : filesWithSameName) {
                String presentablePath = virtualFile instanceof VirtualFilePathWrapper ? ((VirtualFilePathWrapper)virtualFile).getPresentablePath() : virtualFile.getPath();
                builder2.addPath((Object)virtualFile, presentablePath);
            }
            return builder2;
        }
        return null;
    }

    @NotNull
    private static Collection<VirtualFile> getFilesByNameFromIndex(@NotNull String fileName, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (!DumbService.isDumb((Project)project)) {
            Collection rawDataFromIndex = (Collection)UniqueVFilePathBuilderImpl.disableIndexUpToDateCheckInEdt(() -> FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope));
            return ContainerUtil.filter((Collection)rawDataFromIndex, f -> fileName.equals(f.getName()));
        }
        Ref filesFromIndex = Ref.create();
        FileBasedIndex.getInstance().ignoreDumbMode(() -> filesFromIndex.set((Object)FilenameIndex.getVirtualFilesByName((Project)project, (String)fileName, (GlobalSearchScope)scope)), DumbModeAccessType.RELIABLE_DATA_ONLY);
        return (Collection)filesFromIndex.get();
    }

    private static <T, E extends Throwable> T disableIndexUpToDateCheckInEdt(@NotNull ThrowableComputable<T, E> computable) throws E {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return (T)(ApplicationManager.getApplication().isDispatchThread() ? FileBasedIndexImpl.disableUpToDateCheckIn(computable) : computable.compute());
    }
}

