/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReopenClosedTabAction
extends AnAction {
    public ReopenClosedTabAction() {
        super(ActionsBundle.messagePointer((String)"action.ReopenClosedTabAction.text", (Object[])new Object[0]));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        EditorWindow window = ReopenClosedTabAction.getEditorWindow(e);
        if (window != null) {
            window.restoreClosedTab();
        }
    }

    @Nullable
    private static EditorWindow getEditorWindow(@NotNull AnActionEvent e) {
        EditorsSplitters splitters;
        Component component2 = (Component)e.getData(PlatformDataKeys.CONTEXT_COMPONENT);
        if (component2 != null && (splitters = (EditorsSplitters)((Object)ComponentUtil.getParentOfType(EditorsSplitters.class, (Component)component2))) != null) {
            return splitters.getCurrentWindow();
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e) {
        EditorWindow window = ReopenClosedTabAction.getEditorWindow(e);
        e.getPresentation().setEnabledAndVisible(window != null && window.hasClosedTabs());
    }
}

