/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.AppTopics;
import com.intellij.CommonBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.PrioritizedDocumentListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.editor.impl.FrozenDocument;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileEditor.impl.MemoryDiskConflictResolver;
import com.intellij.openapi.fileEditor.impl.text.TextEditorImpl;
import com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseHandler;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.psi.AbstractFileViewProvider;
import com.intellij.psi.ExternalChangeAction;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.FileContentUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentManagerImpl
extends FileDocumentManager
implements SafeWriteRequestor {
    private static final Logger LOG = Logger.getInstance(FileDocumentManagerImpl.class);
    public static final Key<Document> HARD_REF_TO_DOCUMENT_KEY = Key.create((String)"HARD_REF_TO_DOCUMENT_KEY");
    public static final Key<Object> NOT_RELOADABLE_DOCUMENT_KEY = new Key("NOT_RELOADABLE_DOCUMENT_KEY");
    private static final Key<String> LINE_SEPARATOR_KEY = Key.create((String)"LINE_SEPARATOR_KEY");
    private static final Key<VirtualFile> FILE_KEY = Key.create((String)"FILE_KEY");
    private static final Key<Boolean> MUST_RECOMPUTE_FILE_TYPE = Key.create((String)"Must recompute file type");
    private static final Key<Boolean> BIG_FILE_PREVIEW = Key.create((String)"BIG_FILE_PREVIEW");
    private final Set<Document> myUnsavedDocuments = ContainerUtil.newConcurrentSet();
    private static final Object lock = new Object();
    private final FileDocumentManagerListener myMultiCaster;
    private final TrailingSpacesStripper myTrailingSpacesStripper = new TrailingSpacesStripper();
    private boolean myOnClose;
    private volatile MemoryDiskConflictResolver myConflictResolver = new MemoryDiskConflictResolver();
    private final PrioritizedDocumentListener myPhysicalDocumentChangeTracker = new PrioritizedDocumentListener(){

        @Override
        public int getPriority() {
            return Integer.MIN_VALUE;
        }

        public void documentChanged(@NotNull DocumentEvent e) {
            Runnable currentCommand;
            Project project;
            Document document = e.getDocument();
            if (!ApplicationManager.getApplication().hasWriteAction(ExternalChangeAction.ExternalDocumentChange.class)) {
                FileDocumentManagerImpl.this.myUnsavedDocuments.add(document);
            }
            Project project2 = project = (currentCommand = CommandProcessor.getInstance().getCurrentCommand()) == null ? null : CommandProcessor.getInstance().getCurrentCommandProject();
            if (project == null) {
                project = ProjectUtil.guessProjectForFile((VirtualFile)FileDocumentManagerImpl.this.getFile(document));
            }
            String lineSeparator = CodeStyle.getProjectOrDefaultSettings((Project)project).getLineSeparator();
            document.putUserData(LINE_SEPARATOR_KEY, (Object)lineSeparator);
            if (FileDocumentManagerImpl.areTooManyDocumentsInTheQueue(FileDocumentManagerImpl.this.myUnsavedDocuments)) {
                FileDocumentManagerImpl.this.saveAllDocumentsLater();
            }
        }
    };
    private final Map<VirtualFile, Document> myDocumentCache = ContainerUtil.createConcurrentWeakValueMap();
    @Deprecated
    public static boolean ourConflictsSolverEnabled = true;

    public FileDocumentManagerImpl() {
        InvocationHandler handler2 = (__, method2, args) -> {
            if (method2.getDeclaringClass() != FileDocumentManagerListener.class) {
                throw new UnsupportedOperationException(method2.toString());
            }
            this.multiCast(method2, args);
            return null;
        };
        ClassLoader loader = FileDocumentManagerListener.class.getClassLoader();
        this.myMultiCaster = (FileDocumentManagerListener)Proxy.newProxyInstance(loader, new Class[]{FileDocumentManagerListener.class}, handler2);
        ApplicationManager.getApplication().getMessageBus().connect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                DocumentImpl.processQueue();
            }
        });
    }

    private static void unwrapAndRethrow(@NotNull Exception e) {
        Exception unwrapped = e;
        if (e instanceof InvocationTargetException) {
            unwrapped = e.getCause() == null ? e : e.getCause();
        }
        ExceptionUtil.rethrowUnchecked((Throwable)unwrapped);
        LOG.error((Throwable)unwrapped);
    }

    private void multiCast(@NotNull Method method2, Object[] args) {
        try {
            method2.invoke(ApplicationManager.getApplication().getMessageBus().syncPublisher(AppTopics.FILE_DOCUMENT_SYNC), args);
        }
        catch (ClassCastException e) {
            LOG.error("Arguments: " + Arrays.toString(args), (Throwable)e);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
        for (FileDocumentManagerListener listener2 : FileDocumentManagerImpl.getListeners()) {
            try {
                method2.invoke((Object)listener2, args);
            }
            catch (Exception e) {
                FileDocumentManagerImpl.unwrapAndRethrow(e);
            }
        }
        try {
            method2.invoke((Object)this.myTrailingSpacesStripper, args);
        }
        catch (Exception e) {
            FileDocumentManagerImpl.unwrapAndRethrow(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Document getDocument(@NotNull VirtualFile file2) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        DocumentEx document = (DocumentEx)this.getCachedDocument(file2);
        if (document == null) {
            if (!file2.isValid() || file2.isDirectory() || FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                return null;
            }
            boolean tooLarge = FileUtilRt.isTooLarge((long)file2.getLength());
            if (file2.getFileType().isBinary() && tooLarge) {
                return null;
            }
            CharSequence text = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerImpl.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
            Object object = lock;
            synchronized (object) {
                document = (DocumentEx)this.getCachedDocument(file2);
                if (document != null) {
                    return document;
                }
                document = (DocumentEx)FileDocumentManagerImpl.createDocument(text, file2);
                document.setModificationStamp(file2.getModificationStamp());
                document.putUserData(BIG_FILE_PREVIEW, tooLarge ? Boolean.TRUE : null);
                FileType fileType = file2.getFileType();
                document.setReadOnly(tooLarge || !file2.isWritable() || fileType.isBinary());
                if (!(file2 instanceof LightVirtualFile) && !(file2.getFileSystem() instanceof NonPhysicalFileSystem)) {
                    document.addDocumentListener(this.myPhysicalDocumentChangeTracker);
                }
                if (file2 instanceof LightVirtualFile) {
                    FileDocumentManagerImpl.registerDocument(document, file2);
                } else {
                    document.putUserData(FILE_KEY, file2);
                    this.cacheDocument(file2, document);
                }
            }
            this.myMultiCaster.fileContentLoaded(file2, (Document)document);
        }
        return document;
    }

    public static boolean areTooManyDocumentsInTheQueue(@NotNull Collection<? extends Document> documents) {
        if (documents.size() > 100) {
            return true;
        }
        int totalSize = 0;
        for (Document document : documents) {
            if ((totalSize += document.getTextLength()) <= FileUtilRt.LARGE_FOR_CONTENT_LOADING) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static Document createDocument(@NotNull CharSequence text, @NotNull VirtualFile file2) {
        boolean acceptSlashR = file2 instanceof LightVirtualFile && StringUtil.indexOf((CharSequence)text, (char)'\r') >= 0;
        boolean freeThreaded = Boolean.TRUE.equals(file2.getUserData(AbstractFileViewProvider.FREE_THREADED));
        DocumentImpl document = (DocumentImpl)((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(text, acceptSlashR, freeThreaded);
        document.documentCreatedFrom(file2);
        return document;
    }

    @Nullable
    public Document getCachedDocument(@NotNull VirtualFile file2) {
        Document hard = (Document)file2.getUserData(HARD_REF_TO_DOCUMENT_KEY);
        return hard != null ? hard : this.getDocumentFromCache(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocument(@NotNull Document document, @NotNull VirtualFile virtualFile) {
        Object object = lock;
        synchronized (object) {
            document.putUserData(FILE_KEY, (Object)virtualFile);
            virtualFile.putUserData(HARD_REF_TO_DOCUMENT_KEY, (Object)document);
        }
    }

    @Nullable
    public VirtualFile getFile(@NotNull Document document) {
        if (document instanceof FrozenDocument) {
            return null;
        }
        return (VirtualFile)document.getUserData(FILE_KEY);
    }

    public void dropAllUnsavedDocuments() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new RuntimeException("This method is only for test mode!");
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.myUnsavedDocuments.isEmpty()) {
            this.myUnsavedDocuments.clear();
            this.myMultiCaster.unsavedDocumentsDropped();
        }
    }

    private void saveAllDocumentsLater() {
        ApplicationManager.getApplication().invokeLater(() -> {
            Document[] unsavedDocuments;
            for (Document document : unsavedDocuments = this.getUnsavedDocuments()) {
                Project project;
                VirtualFile file2 = this.getFile(document);
                if (file2 == null || (project = ProjectUtil.guessProjectForFile((VirtualFile)file2)) == null || PsiDocumentManager.getInstance((Project)project).isDocumentBlockedByPsi(document)) continue;
                this.saveDocument(document);
            }
        });
    }

    public void saveAllDocuments() {
        this.saveAllDocuments(true);
    }

    public void saveAllDocuments(boolean isExplicit) {
        this.saveDocuments(null, isExplicit);
    }

    public void saveDocuments(@NotNull Predicate<Document> filter2) {
        this.saveDocuments(filter2, true);
    }

    private void saveDocuments(@Nullable Predicate<Document> filter2, boolean isExplicit) {
        int count;
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myMultiCaster.beforeAllDocumentsSaving();
        if (this.myUnsavedDocuments.isEmpty()) {
            return;
        }
        HashMap<Document, IOException> failedToSave = new HashMap<Document, IOException>();
        HashSet<Document> vetoed = new HashSet<Document>();
        do {
            count = 0;
            for (Document document : this.myUnsavedDocuments) {
                if (filter2 != null && !filter2.test(document) || failedToSave.containsKey(document) || vetoed.contains(document)) continue;
                try {
                    this.doSaveDocument(document, isExplicit);
                }
                catch (IOException e) {
                    failedToSave.put(document, e);
                }
                catch (SaveVetoException e) {
                    vetoed.add(document);
                }
                ++count;
            }
        } while (count != 0);
        if (!failedToSave.isEmpty()) {
            this.handleErrorsOnSave(failedToSave);
        }
    }

    public void saveDocument(@NotNull Document document) {
        this.saveDocument(document, true);
    }

    public void saveDocument(@NotNull Document document, boolean explicit) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        if (!this.myUnsavedDocuments.contains(document)) {
            return;
        }
        try {
            this.doSaveDocument(document, explicit);
        }
        catch (IOException e) {
            this.handleErrorsOnSave(Collections.singletonMap(document, e));
        }
        catch (SaveVetoException saveVetoException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocumentAsIs(@NotNull Document document) {
        VirtualFile file2 = this.getFile(document);
        boolean spaceStrippingEnabled = true;
        if (file2 != null) {
            spaceStrippingEnabled = TrailingSpacesStripper.isEnabled(file2);
            TrailingSpacesStripper.setEnabled(file2, false);
        }
        try {
            this.saveDocument(document);
        }
        finally {
            if (file2 != null) {
                TrailingSpacesStripper.setEnabled(file2, spaceStrippingEnabled);
            }
        }
    }

    private void doSaveDocument(@NotNull Document document, boolean isExplicit) throws IOException, SaveVetoException {
        VirtualFile file2 = this.getFile(document);
        if (LOG.isTraceEnabled()) {
            LOG.trace("saving: " + file2);
        }
        if (file2 == null || file2 instanceof LightVirtualFile || file2.isValid() && !this.isFileModified(file2)) {
            this.removeFromUnsaved(document);
            return;
        }
        if (file2.isValid() && FileDocumentManagerImpl.needsRefresh(file2)) {
            LOG.trace("  refreshing...");
            file2.refresh(false, false);
            if (!this.myUnsavedDocuments.contains(document)) {
                return;
            }
        }
        if (!this.maySaveDocument(file2, document, isExplicit)) {
            throw new SaveVetoException();
        }
        LOG.trace("  writing...");
        WriteAction.run(() -> this.doSaveDocumentInWriteAction(document, file2));
        LOG.trace("  done");
    }

    private boolean maySaveDocument(@NotNull VirtualFile file2, @NotNull Document document, boolean isExplicit) {
        return !this.myConflictResolver.hasConflict(file2) && FileDocumentSynchronizationVetoer.EP_NAME.getExtensionList().stream().allMatch(vetoer -> vetoer.maySaveDocument(document, isExplicit));
    }

    private void doSaveDocumentInWriteAction(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (!file2.isValid()) {
            this.removeFromUnsaved(document);
            return;
        }
        if (!file2.equals(this.getFile(document))) {
            FileDocumentManagerImpl.registerDocument(document, file2);
        }
        boolean saveNeeded = false;
        Exception ioException = null;
        try {
            saveNeeded = FileDocumentManagerImpl.isSaveNeeded(document, file2);
        }
        catch (IOException | RuntimeException e) {
            ioException = e;
        }
        if (!saveNeeded) {
            if (document instanceof DocumentEx) {
                ((DocumentEx)document).setModificationStamp(file2.getModificationStamp());
            }
            this.removeFromUnsaved(document);
            FileDocumentManagerImpl.updateModifiedProperty(file2);
            if (ioException instanceof IOException) {
                throw (IOException)ioException;
            }
            if (ioException instanceof RuntimeException) {
                throw (RuntimeException)ioException;
            }
            return;
        }
        PomModelImpl.guardPsiModificationsIn(() -> {
            this.myMultiCaster.beforeDocumentSaving(document);
            LOG.assertTrue(file2.isValid());
            String text = document.getText();
            String lineSeparator = FileDocumentManagerImpl.getLineSeparator(document, file2);
            if (!lineSeparator.equals("\n")) {
                text = StringUtil.convertLineSeparators((String)text, (String)lineSeparator);
            }
            Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
            LoadTextUtil.write(project, file2, (Object)this, text, document.getModificationStamp());
            this.myUnsavedDocuments.remove(document);
            LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
            this.myTrailingSpacesStripper.clearLineModificationFlags(document);
        });
    }

    private static void updateModifiedProperty(@NotNull VirtualFile file2) {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
            for (FileEditor editor : fileEditorManager.getAllEditors(file2)) {
                if (!(editor instanceof TextEditorImpl)) continue;
                ((TextEditorImpl)editor).updateModifiedProperty();
            }
        }
    }

    private void removeFromUnsaved(@NotNull Document document) {
        this.myUnsavedDocuments.remove(document);
        this.myMultiCaster.unsavedDocumentDropped(document);
        LOG.assertTrue(!this.myUnsavedDocuments.contains(document));
    }

    private static boolean isSaveNeeded(@NotNull Document document, @NotNull VirtualFile file2) throws IOException {
        if (file2.getFileType().isBinary() || document.getTextLength() > 1000000) {
            return true;
        }
        byte[] bytes = file2.contentsToByteArray();
        CharSequence loaded = LoadTextUtil.getTextByBinaryPresentation(bytes, file2, false, false);
        return !Comparing.equal((CharSequence)document.getCharsSequence(), (CharSequence)loaded);
    }

    private static boolean needsRefresh(@NotNull VirtualFile file2) {
        VirtualFileSystem fs = file2.getFileSystem();
        return fs instanceof NewVirtualFileSystem && file2.getTimeStamp() != ((NewVirtualFileSystem)fs).getTimeStamp(file2);
    }

    @NotNull
    public static String getLineSeparator(@NotNull Document document, @NotNull VirtualFile file2) {
        String lineSeparator = file2.getDetectedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = (String)document.getUserData(LINE_SEPARATOR_KEY);
            assert (lineSeparator != null) : document;
        }
        return lineSeparator;
    }

    @NotNull
    public String getLineSeparator(@Nullable VirtualFile file2, @Nullable Project project) {
        String lineSeparator;
        String string = lineSeparator = file2 == null ? null : file2.getDetectedLineSeparator();
        if (lineSeparator == null) {
            lineSeparator = CodeStyle.getProjectOrDefaultSettings((Project)project).getLineSeparator();
        }
        return lineSeparator;
    }

    public boolean requestWriting(@NotNull Document document, Project project) {
        return this.requestWritingStatus(document, project).hasWriteAccess();
    }

    @NotNull
    public FileDocumentManager.WriteAccessStatus requestWritingStatus(@NotNull Document document, @Nullable Project project) {
        VirtualFile file2 = FileDocumentManagerImpl.getInstance().getFile(document);
        if (project != null && file2 != null && file2.isValid()) {
            if (file2.getFileType().isBinary()) {
                return FileDocumentManager.WriteAccessStatus.NON_WRITABLE;
            }
            ReadonlyStatusHandler.OperationStatus writableStatus = ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(Collections.singletonList(file2));
            if (writableStatus.hasReadonlyFiles()) {
                return new FileDocumentManager.WriteAccessStatus(writableStatus.getReadonlyFilesMessage());
            }
            assert (file2.isWritable()) : file2;
        }
        if (document.isWritable()) {
            return FileDocumentManager.WriteAccessStatus.WRITABLE;
        }
        document.fireReadOnlyModificationAttempt();
        return FileDocumentManager.WriteAccessStatus.NON_WRITABLE;
    }

    public void reloadFiles(VirtualFile ... files2) {
        for (VirtualFile file2 : files2) {
            Document doc;
            if (!file2.exists() || (doc = this.getCachedDocument(file2)) == null) continue;
            this.reloadFromDisk(doc);
        }
    }

    public void reloadBinaryFiles() {
        List binaries = ContainerUtil.filter(this.myDocumentCache.keySet(), file2 -> file2.getFileType().isBinary());
        FileContentUtilCore.reparseFiles((Collection)binaries);
    }

    public Document @NotNull [] getUnsavedDocuments() {
        if (this.myUnsavedDocuments.isEmpty()) {
            return Document.EMPTY_ARRAY;
        }
        ArrayList<Document> list2 = new ArrayList<Document>(this.myUnsavedDocuments);
        return list2.toArray(Document.EMPTY_ARRAY);
    }

    public boolean isDocumentUnsaved(@NotNull Document document) {
        return this.myUnsavedDocuments.contains(document);
    }

    public boolean isFileModified(@NotNull VirtualFile file2) {
        Document doc = this.getCachedDocument(file2);
        return doc != null && this.isDocumentUnsaved(doc) && doc.getModificationStamp() != file2.getModificationStamp();
    }

    public boolean isPartialPreviewOfALargeFile(@NotNull Document document) {
        return document.getUserData(BIG_FILE_PREVIEW) == Boolean.TRUE;
    }

    private void propertyChanged(@NotNull VFilePropertyChangeEvent event) {
        Document document;
        VirtualFile file2 = event.getFile();
        if ("writable".equals(event.getPropertyName())) {
            Document document2 = this.getCachedDocument(file2);
            if (document2 != null) {
                ApplicationManager.getApplication().runWriteAction(() -> document2.setReadOnly(!file2.isWritable()));
            }
        } else if ("name".equals(event.getPropertyName()) && (document = this.getCachedDocument(file2)) != null) {
            if (FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                this.unbindFileFromDocument(file2, document);
            } else if ("FileContentUtilCore.saveOrReload".equals(event.getRequestor()) && FileDocumentManagerImpl.isBinaryWithDecompiler(file2)) {
                this.reloadFromDisk(document);
            }
        }
    }

    private void unbindFileFromDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        this.removeDocumentFromCache(file2);
        file2.putUserData(HARD_REF_TO_DOCUMENT_KEY, null);
        document.putUserData(FILE_KEY, null);
    }

    private static boolean isBinaryWithDecompiler(@NotNull VirtualFile file2) {
        FileType ft = file2.getFileType();
        return ft.isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(ft) != null;
    }

    private static boolean isBinaryWithoutDecompiler(@NotNull VirtualFile file2) {
        FileType fileType = file2.getFileType();
        return fileType.isBinary() && BinaryFileTypeDecompilers.getInstance().forFileType(fileType) == null;
    }

    public void contentsChanged(@NotNull VFileContentChangeEvent event) {
        VirtualFile virtualFile = event.getFile();
        Document document = this.getCachedDocument(virtualFile);
        if (event.isFromSave()) {
            return;
        }
        if (document == null || FileDocumentManagerImpl.isBinaryWithDecompiler(virtualFile)) {
            this.myMultiCaster.fileWithNoDocumentChanged(virtualFile);
        }
        if (!(document == null || document.getModificationStamp() != event.getOldModificationStamp() && this.isDocumentUnsaved(document))) {
            this.reloadFromDisk(document);
        }
    }

    public void reloadFromDisk(final @NotNull Document document) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        final VirtualFile file2 = this.getFile(document);
        assert (file2 != null);
        if (!file2.isValid()) {
            return;
        }
        if (!this.fireBeforeFileContentReload(file2, document)) {
            return;
        }
        final Project project = ProjectLocator.getInstance().guessProjectForFile(file2);
        final boolean[] isReloadable = new boolean[]{FileDocumentManagerImpl.isReloadable(file2, document, project)};
        if (isReloadable[0]) {
            CommandProcessor.getInstance().executeCommand(project, () -> ApplicationManager.getApplication().runWriteAction((Runnable)new ExternalChangeAction.ExternalDocumentChange(document, project){

                @Override
                public void run() {
                    if (!FileDocumentManagerImpl.isBinaryWithoutDecompiler(file2)) {
                        LoadTextUtil.clearCharsetAutoDetectionReason(file2);
                        file2.setBOM(null);
                        file2.setCharset(null, null, false);
                        boolean wasWritable = document.isWritable();
                        document.setReadOnly(false);
                        boolean tooLarge = FileUtilRt.isTooLarge((long)file2.getLength());
                        isReloadable[0] = FileDocumentManagerImpl.isReloadable(file2, document, project);
                        if (isReloadable[0]) {
                            CharSequence reloaded2 = tooLarge ? LoadTextUtil.loadText(file2, FileDocumentManagerImpl.getPreviewCharCount(file2)) : LoadTextUtil.loadText(file2);
                            ((DocumentEx)document).replaceText(reloaded2, file2.getModificationStamp());
                            document.putUserData(BIG_FILE_PREVIEW, (Object)(tooLarge ? Boolean.TRUE : null));
                        }
                        document.setReadOnly(!wasWritable);
                    }
                }
            }), UIBundle.message((String)"file.cache.conflict.action", (Object[])new Object[0]), null, UndoConfirmationPolicy.REQUEST_CONFIRMATION);
        }
        if (isReloadable[0]) {
            this.myMultiCaster.fileContentReloaded(file2, document);
        } else {
            this.unbindFileFromDocument(file2, document);
            this.myMultiCaster.fileWithNoDocumentChanged(file2);
        }
        this.myUnsavedDocuments.remove(document);
    }

    private static boolean isReloadable(@NotNull VirtualFile file2, @NotNull Document document, @Nullable Project project) {
        PsiFile cachedPsiFile = project == null ? null : PsiDocumentManager.getInstance((Project)project).getCachedPsiFile(document);
        return !(FileUtilRt.isTooLarge((long)file2.getLength()) && file2.getFileType().isBinary() || cachedPsiFile != null && !(cachedPsiFile instanceof PsiFileImpl) && !FileDocumentManagerImpl.isBinaryWithDecompiler(file2) || document.getUserData(NOT_RELOADABLE_DOCUMENT_KEY) != null);
    }

    void setAskReloadFromDisk(@NotNull Disposable disposable2, @NotNull MemoryDiskConflictResolver newProcessor) {
        MemoryDiskConflictResolver old = this.myConflictResolver;
        this.myConflictResolver = newProcessor;
        Disposer.register((Disposable)disposable2, () -> {
            this.myConflictResolver = old;
        });
    }

    private void fileDeleted(@NotNull VFileDeleteEvent event) {
        Document doc = this.getCachedDocument(event.getFile());
        if (doc != null) {
            this.myTrailingSpacesStripper.documentDeleted(doc);
        }
    }

    public static boolean recomputeFileTypeIfNecessary(@NotNull VirtualFile virtualFile) {
        if (virtualFile.getUserData(MUST_RECOMPUTE_FILE_TYPE) != null) {
            virtualFile.getFileType();
            virtualFile.putUserData(MUST_RECOMPUTE_FILE_TYPE, null);
            return true;
        }
        return false;
    }

    private boolean fireBeforeFileContentReload(@NotNull VirtualFile file2, @NotNull Document document) {
        for (FileDocumentSynchronizationVetoer vetoer : FileDocumentSynchronizationVetoer.EP_NAME.getExtensionList()) {
            try {
                if (vetoer.mayReloadFileContent(file2, document)) continue;
                return false;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
        this.myMultiCaster.beforeFileContentReload(file2, document);
        return true;
    }

    @NotNull
    private static List<FileDocumentManagerListener> getListeners() {
        return FileDocumentManagerListener.EP_NAME.getExtensionList();
    }

    private static int getPreviewCharCount(@NotNull VirtualFile file2) {
        Charset charset = EncodingManager.getInstance().getEncoding(file2, false);
        float bytesPerChar = charset == null ? 2.0f : charset.newEncoder().averageBytesPerChar();
        return (int)((float)FileUtilRt.LARGE_FILE_PREVIEW_SIZE / bytesPerChar);
    }

    private void handleErrorsOnSave(@NotNull Map<Document, IOException> failures) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            IOException ioException = (IOException)ContainerUtil.getFirstItem(failures.values());
            if (ioException != null) {
                throw new RuntimeException(ioException);
            }
            return;
        }
        for (Map.Entry<Document, IOException> entry : failures.entrySet()) {
            LOG.warn("file: " + this.getFile(entry.getKey()), (Throwable)entry.getValue());
        }
        final String text = StringUtil.join(failures.values(), Throwable::getMessage, (String)"\n");
        DialogWrapper dialog2 = new DialogWrapper(null){
            {
                super(x0);
                this.init();
                this.setTitle(UIBundle.message((String)"cannot.save.files.dialog.title", (Object[])new Object[0]));
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.myOKAction.putValue("Name", UIBundle.message((String)(FileDocumentManagerImpl.this.myOnClose ? "cannot.save.files.dialog.ignore.changes" : "cannot.save.files.dialog.revert.changes"), (Object[])new Object[0]));
                this.myOKAction.putValue("DefaultAction", null);
                if (!FileDocumentManagerImpl.this.myOnClose) {
                    this.myCancelAction.putValue("Name", CommonBundle.getCloseButtonText());
                }
            }

            protected JComponent createCenterPanel() {
                JPanel panel2 = new JPanel(new BorderLayout(0, 5));
                panel2.add((Component)new JLabel(UIBundle.message((String)"cannot.save.files.dialog.message", (Object[])new Object[0])), "North");
                JTextPane area = new JTextPane();
                area.setText(text);
                area.setEditable(false);
                area.setMinimumSize(new Dimension(area.getMinimumSize().width, 50));
                panel2.add((Component)new JBScrollPane((Component)area, 22, 31), "Center");
                return panel2;
            }
        };
        if (dialog2.showAndGet()) {
            for (Document document : failures.keySet()) {
                this.reloadFromDisk(document);
            }
        }
    }

    protected void cacheDocument(@NotNull VirtualFile file2, @NotNull Document document) {
        this.myDocumentCache.put(file2, document);
    }

    protected void removeDocumentFromCache(@NotNull VirtualFile file2) {
        this.myDocumentCache.remove(file2);
    }

    protected Document getDocumentFromCache(@NotNull VirtualFile file2) {
        return this.myDocumentCache.get(file2);
    }

    static final class MyAsyncFileListener
    implements AsyncFileListener {
        private final FileDocumentManagerImpl myFileDocumentManager = (FileDocumentManagerImpl)FileDocumentManager.getInstance();

        MyAsyncFileListener() {
        }

        public AsyncFileListener.ChangeApplier prepareChange(final @NotNull List<? extends VFileEvent> events) {
            final ArrayList<VirtualFile> toRecompute = new ArrayList<VirtualFile>();
            final HashMap<VirtualFile, Document> strongRefsToDocuments = new HashMap<VirtualFile, Document>();
            final List contentChanges = ContainerUtil.findAll(events, VFileContentChangeEvent.class);
            for (VFileContentChangeEvent event : contentChanges) {
                long lastRecordedLength;
                ProgressManager.checkCanceled();
                VirtualFile virtualFile = event.getFile();
                if (virtualFile instanceof VirtualFileWithId && (lastRecordedLength = PersistentFS.getInstance().getLastRecordedLength(virtualFile)) == 0L && FileTypeRegistry.getInstance().isFileOfType(virtualFile, UnknownFileType.INSTANCE)) {
                    toRecompute.add(virtualFile);
                }
                this.prepareForRangeMarkerUpdate(strongRefsToDocuments, virtualFile);
            }
            return new AsyncFileListener.ChangeApplier(){

                public void beforeVfsChange() {
                    for (VFileContentChangeEvent event : contentChanges) {
                        this.prepareForRangeMarkerUpdate(strongRefsToDocuments, event.getFile());
                        if (!ourConflictsSolverEnabled) continue;
                        myFileDocumentManager.myConflictResolver.beforeContentChange(event);
                    }
                    for (VirtualFile file2 : toRecompute) {
                        file2.putUserData(MUST_RECOMPUTE_FILE_TYPE, (Object)Boolean.TRUE);
                    }
                }

                public void afterVfsChange() {
                    for (VFileEvent event : events) {
                        if (event instanceof VFileContentChangeEvent && ((VFileContentChangeEvent)event).getFile().isValid()) {
                            myFileDocumentManager.contentsChanged((VFileContentChangeEvent)event);
                            continue;
                        }
                        if (event instanceof VFileDeleteEvent && ((VFileDeleteEvent)event).getFile().isValid()) {
                            myFileDocumentManager.fileDeleted((VFileDeleteEvent)event);
                            continue;
                        }
                        if (!(event instanceof VFilePropertyChangeEvent) || !((VFilePropertyChangeEvent)event).getFile().isValid()) continue;
                        myFileDocumentManager.propertyChanged((VFilePropertyChangeEvent)event);
                    }
                    ObjectUtils.reachabilityFence((Object)strongRefsToDocuments);
                }
            };
        }

        private void prepareForRangeMarkerUpdate(Map<VirtualFile, Document> strongRefsToDocuments, VirtualFile virtualFile) {
            Document document = this.myFileDocumentManager.getCachedDocument(virtualFile);
            if (document == null && DocumentImpl.areRangeMarkersRetainedFor(virtualFile)) {
                document = this.myFileDocumentManager.getDocument(virtualFile);
            }
            if (document != null) {
                strongRefsToDocuments.put(virtualFile, document);
            }
        }
    }

    private static class SaveVetoException
    extends Exception {
        private SaveVetoException() {
        }
    }

    static final class MyProjectCloseHandler
    implements ProjectCloseHandler {
        MyProjectCloseHandler() {
        }

        public boolean canClose(@NotNull Project project) {
            FileDocumentManagerImpl manager = (FileDocumentManagerImpl)FileDocumentManager.getInstance();
            if (!manager.myUnsavedDocuments.isEmpty()) {
                manager.myOnClose = true;
                try {
                    manager.saveAllDocuments();
                }
                finally {
                    manager.myOnClose = false;
                }
            }
            return manager.myUnsavedDocuments.isEmpty();
        }
    }
}

