/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.ex.FileEditorWithProvider;
import com.intellij.openapi.fileEditor.impl.HistoryEntry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="editorHistoryManager", storages={@Storage(value="$PRODUCT_WORKSPACE_FILE$"), @Storage(value="$WORKSPACE_FILE$", deprecated=true)})
public final class EditorHistoryManager
implements PersistentStateComponent<Element>,
Disposable {
    private static final Logger LOG = Logger.getInstance(EditorHistoryManager.class);
    private final Project myProject;
    private final List<HistoryEntry> myEntriesList = new ArrayList<HistoryEntry>();

    public static EditorHistoryManager getInstance(@NotNull Project project) {
        return (EditorHistoryManager)project.getService(EditorHistoryManager.class);
    }

    EditorHistoryManager(@NotNull Project project) {
        this.myProject = project;
        SimpleMessageBusConnection connection = project.getMessageBus().simpleConnect();
        connection.subscribe(UISettingsListener.TOPIC, uiSettings -> this.trimToSize());
        connection.subscribe(FileEditorManagerListener.Before.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener.Before(){

            public void beforeFileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                EditorHistoryManager.this.updateHistoryEntry(file2, false);
            }
        });
        connection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new MyEditorManagerListener());
        FileEditorProvider.EP_FILE_EDITOR_PROVIDER.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<FileEditorProvider>(){

            public void extensionRemoved(@NotNull FileEditorProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                EditorHistoryManager.this.myEntriesList.forEach(e -> e.onProviderRemoval(provider));
            }
        }, (Disposable)this);
    }

    private synchronized void removeEntry(@NotNull HistoryEntry entry) {
        if (this.myEntriesList.remove(entry)) {
            entry.destroy();
        }
    }

    private synchronized void moveOnTop(@NotNull HistoryEntry entry) {
        this.myEntriesList.remove(entry);
        this.myEntriesList.add(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fileOpenedImpl(@NotNull VirtualFile file2, @Nullable FileEditor fallbackEditor, @Nullable FileEditorProvider fallbackProvider) {
        FileEditorProvider[] oldProviders;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (VirtualFileManager.getInstance().findFileByUrl(file2.getUrl()) == null) {
            return;
        }
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file2);
        Object[] editors = (FileEditor[])editorsWithProviders.getFirst();
        LOG.assertTrue(editors.length == (oldProviders = (FileEditorProvider[])editorsWithProviders.getSecond()).length, (Object)"Different number of editors and providers");
        if (editors.length <= 0 && fallbackEditor != null && fallbackProvider != null) {
            editors = new FileEditor[]{fallbackEditor};
            oldProviders = new FileEditorProvider[]{fallbackProvider};
        }
        if (editors.length <= 0) {
            return;
        }
        FileEditor selectedEditor = editorManager.getSelectedEditor(file2);
        if (selectedEditor == null) {
            selectedEditor = fallbackEditor;
        }
        LOG.assertTrue(selectedEditor != null);
        int selectedProviderIndex = ArrayUtilRt.find((Object[])editors, (Object)selectedEditor);
        LOG.assertTrue(selectedProviderIndex != -1, (Object)("Can't find " + selectedEditor + " among " + Arrays.asList(editors)));
        HistoryEntry entry = this.getEntry(file2);
        if (entry != null) {
            this.moveOnTop(entry);
        } else {
            FileEditorState[] states = new FileEditorState[editors.length];
            FileEditorProvider[] providers = new FileEditorProvider[editors.length];
            for (int i2 = states.length - 1; i2 >= 0; --i2) {
                FileEditorProvider provider = oldProviders[i2];
                LOG.assertTrue(provider != null);
                providers[i2] = provider;
                Object editor = editors[i2];
                if (!editor.isValid()) continue;
                states[i2] = editor.getState(FileEditorStateLevel.FULL);
            }
            EditorHistoryManager editorHistoryManager = this;
            synchronized (editorHistoryManager) {
                this.myEntriesList.add(HistoryEntry.createHeavy(this.myProject, file2, providers, states, providers[selectedProviderIndex]));
            }
            this.trimToSize();
        }
    }

    public void updateHistoryEntry(@NotNull VirtualFile file2, boolean changeEntryOrderOnly) {
        this.updateHistoryEntry(file2, null, null, changeEntryOrderOnly);
    }

    private void updateHistoryEntry(@NotNull VirtualFile file2, @Nullable FileEditor fileEditor, @Nullable FileEditorProvider fileEditorProvider, boolean changeEntryOrderOnly) {
        FileEditorWithProvider selectedEditorWithProvider;
        FileEditorProvider[] providers;
        FileEditor[] editors;
        FileEditorManagerEx editorManager = FileEditorManagerEx.getInstanceEx(this.myProject);
        if (fileEditor == null || fileEditorProvider == null) {
            Pair<FileEditor[], FileEditorProvider[]> editorsWithProviders = editorManager.getEditorsWithProviders(file2);
            editors = (FileEditor[])editorsWithProviders.getFirst();
            providers = (FileEditorProvider[])editorsWithProviders.getSecond();
        } else {
            editors = new FileEditor[]{fileEditor};
            providers = new FileEditorProvider[]{fileEditorProvider};
        }
        if (editors.length == 0) {
            return;
        }
        HistoryEntry entry = this.getEntry(file2);
        if (entry == null) {
            if (file2.isValid()) {
                this.fileOpenedImpl(file2, fileEditor, fileEditorProvider);
            }
            return;
        }
        if (!changeEntryOrderOnly) {
            for (int i2 = editors.length - 1; i2 >= 0; --i2) {
                FileEditor editor = editors[i2];
                FileEditorProvider provider = providers[i2];
                if (provider == null || !editor.isValid()) continue;
                FileEditorState oldState = entry.getState(provider);
                FileEditorState newState2 = editor.getState(FileEditorStateLevel.FULL);
                if (newState2.equals(oldState)) continue;
                entry.putState(provider, newState2);
            }
        }
        if ((selectedEditorWithProvider = editorManager.getSelectedEditorWithProvider(file2)) != null) {
            entry.setSelectedProvider(selectedEditorWithProvider.getProvider());
            LOG.assertTrue(entry.getSelectedProvider() != null);
            if (changeEntryOrderOnly) {
                this.moveOnTop(entry);
            }
        }
    }

    public synchronized VirtualFile @NotNull [] getFiles() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(this.myEntriesList.size());
        for (HistoryEntry entry : this.myEntriesList) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        return VfsUtilCore.toVirtualFileArray(result2);
    }

    @VisibleForTesting
    public synchronized void removeAllFiles() {
        for (HistoryEntry entry : this.myEntriesList) {
            entry.destroy();
        }
        this.myEntriesList.clear();
    }

    @NotNull
    public synchronized List<VirtualFile> getFileList() {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        for (HistoryEntry entry : this.myEntriesList) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null) continue;
            result2.add(file2);
        }
        return result2;
    }

    @Deprecated
    @NotNull
    public synchronized LinkedHashSet<VirtualFile> getFileSet() {
        return new LinkedHashSet<VirtualFile>(this.getFileList());
    }

    public synchronized boolean hasBeenOpen(@NotNull VirtualFile f) {
        for (HistoryEntry each : this.myEntriesList) {
            if (!f.equals(each.getFile())) continue;
            return true;
        }
        return false;
    }

    public synchronized void removeFile(@NotNull VirtualFile file2) {
        HistoryEntry entry = this.getEntry(file2);
        if (entry != null) {
            this.removeEntry(entry);
        }
    }

    public FileEditorState getState(@NotNull VirtualFile file2, @NotNull FileEditorProvider provider) {
        HistoryEntry entry = this.getEntry(file2);
        return entry != null ? entry.getState(provider) : null;
    }

    FileEditorProvider getSelectedProvider(@NotNull VirtualFile file2) {
        HistoryEntry entry = this.getEntry(file2);
        return entry != null ? entry.getSelectedProvider() : null;
    }

    private synchronized HistoryEntry getEntry(@NotNull VirtualFile file2) {
        for (int i2 = this.myEntriesList.size() - 1; i2 >= 0; --i2) {
            HistoryEntry entry = this.myEntriesList.get(i2);
            VirtualFile entryFile = entry.getFile();
            if (!file2.equals(entryFile)) continue;
            return entry;
        }
        return null;
    }

    private synchronized void trimToSize() {
        int limit = UISettings.getInstance().getRecentFilesLimit() + 1;
        while (this.myEntriesList.size() > limit) {
            HistoryEntry removed = this.myEntriesList.remove(0);
            removed.destroy();
        }
    }

    public synchronized void loadState(@NotNull Element state) {
        this.removeAllFiles();
        LinkedHashMap<String, Element> fileToElement = new LinkedHashMap<String, Element>();
        for (Element e : state.getChildren("entry")) {
            String file2 = e.getAttributeValue("file");
            fileToElement.remove(file2);
            fileToElement.put(file2, e);
        }
        for (Element e : fileToElement.values()) {
            try {
                this.myEntriesList.add(HistoryEntry.createHeavy(this.myProject, e));
            }
            catch (ProcessCanceledException file2) {
            }
            catch (Exception anyException) {
                LOG.error((Throwable)anyException);
            }
        }
    }

    public synchronized Element getState() {
        Element element2 = new Element("state");
        VirtualFile[] openFiles = FileEditorManager.getInstance((Project)this.myProject).getOpenFiles();
        for (int i2 = openFiles.length - 1; i2 >= 0; --i2) {
            VirtualFile file2 = openFiles[i2];
            if (this.getEntry(file2) == null) continue;
            this.updateHistoryEntry(file2, false);
        }
        for (HistoryEntry entry : this.myEntriesList) {
            entry.writeExternal(element2, this.myProject);
        }
        return element2;
    }

    public synchronized void dispose() {
        this.removeAllFiles();
    }

    private final class MyEditorManagerListener
    implements FileEditorManagerListener {
        private MyEditorManagerListener() {
        }

        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            EditorHistoryManager.this.fileOpenedImpl(file2, null, null);
        }

        public void selectionChanged(@NotNull FileEditorManagerEvent event) {
            PsiDocumentManager.getInstance((Project)EditorHistoryManager.this.myProject).performWhenAllCommitted(() -> {
                VirtualFile newFile;
                FileEditor newEditor = event.getNewEditor();
                if (newEditor != null && !newEditor.isValid()) {
                    return;
                }
                VirtualFile oldFile = event.getOldFile();
                if (oldFile != null) {
                    EditorHistoryManager.this.updateHistoryEntry(oldFile, event.getOldEditor(), event.getOldProvider(), false);
                }
                if ((newFile = event.getNewFile()) != null) {
                    EditorHistoryManager.this.updateHistoryEntry(newFile, true);
                }
            });
        }
    }

    static final class EditorHistoryManagerStartUpActivity
    implements StartupActivity.DumbAware {
        EditorHistoryManagerStartUpActivity() {
        }

        public void runActivity(@NotNull Project project) {
            EditorHistoryManager.getInstance(project);
        }
    }
}

