/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.ActivateToolWindowAction;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.impl.ProjectFrameHelper;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorEmptyTextPainter {
    public void paintEmptyText(@NotNull JComponent splitters, @NotNull Graphics g) {
        UISettings.setupAntialiasing((Graphics)g);
        UIUtil.TextPainter painter = EditorEmptyTextPainter.createTextPainter();
        this.advertiseActions(splitters, painter);
        painter.draw(g, (width, height) -> {
            Dimension s = splitters.getSize();
            int w = (s.width - width) / 2;
            int h = (int)((double)s.height * this.heightRatio());
            return Couple.of((Object)w, (Object)h);
        });
    }

    protected double heightRatio() {
        return 0.375;
    }

    protected void advertiseActions(@NotNull JComponent splitters, @NotNull UIUtil.TextPainter painter) {
        this.appendSearchEverywhere(painter);
        this.appendToolWindow(painter, IdeBundle.message((String)"empty.text.project.view", (Object[])new Object[0]), "Project", splitters);
        this.appendAction(painter, IdeBundle.message((String)"empty.text.go.to.file", (Object[])new Object[0]), this.getActionShortcutText("GotoFile"));
        this.appendAction(painter, IdeBundle.message((String)"empty.text.recent.files", (Object[])new Object[0]), this.getActionShortcutText("RecentFiles"));
        this.appendAction(painter, IdeBundle.message((String)"empty.text.navigation.bar", (Object[])new Object[0]), this.getActionShortcutText("ShowNavBar"));
        this.appendDnd(painter);
    }

    protected void appendDnd(@NotNull UIUtil.TextPainter painter) {
        this.appendLine(painter, IdeBundle.message((String)"empty.text.drop.files.to.open", (Object[])new Object[0]));
    }

    protected void appendSearchEverywhere(@NotNull UIUtil.TextPainter painter) {
        Shortcut[] shortcuts = KeymapUtil.getActiveKeymapShortcuts((String)"SearchEverywhere").getShortcuts();
        String message = IdeBundle.message((String)"double.ctrl.or.shift.shortcut", (Object[])new Object[]{SystemInfo.isMac ? "\u21e7" : "Shift"});
        this.appendAction(painter, IdeBundle.message((String)"empty.text.search.everywhere", (Object[])new Object[0]), shortcuts.length == 0 ? message : KeymapUtil.getShortcutsText((Shortcut[])shortcuts));
    }

    protected void appendToolWindow(@NotNull UIUtil.TextPainter painter, @NotNull @Nls String action2, @NotNull String toolWindowId, @NotNull JComponent splitters) {
        if (!EditorEmptyTextPainter.isToolwindowVisible(splitters, toolWindowId)) {
            String activateActionId = ActivateToolWindowAction.getActionIdForToolWindow(toolWindowId);
            this.appendAction(painter, action2, this.getActionShortcutText(activateActionId));
        }
    }

    protected void appendAction(@NotNull UIUtil.TextPainter painter, @NotNull @Nls String action2, @Nullable String shortcut) {
        if (StringUtil.isEmpty((String)shortcut)) {
            return;
        }
        this.appendLine(painter, action2 + " <shortcut>" + shortcut + "</shortcut>");
    }

    protected void appendLine(@NotNull UIUtil.TextPainter painter, @NotNull String line) {
        painter.appendLine(line);
    }

    @NotNull
    protected String getActionShortcutText(@NonNls @NotNull String actionId) {
        return KeymapUtil.getFirstKeyboardShortcutText((String)actionId);
    }

    protected static boolean isToolwindowVisible(@NotNull JComponent splitters, @NotNull String toolwindowId) {
        Project project;
        ProjectFrameHelper frame = ProjectFrameHelper.getFrameHelper(SwingUtilities.getWindowAncestor(splitters));
        if (frame != null && (project = frame.getProject()) != null) {
            if (!project.isInitialized()) {
                return true;
            }
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(toolwindowId);
            return toolWindow != null && toolWindow.isVisible();
        }
        return false;
    }

    @NotNull
    public static UIUtil.TextPainter createTextPainter() {
        return new UIUtil.TextPainter().withLineSpacing(1.8f).withColor((Color)JBColor.namedColor((String)"Editor.foreground", (Color)new JBColor((Color)Gray._80, (Color)Gray._160))).withFont((Font)JBUI.Fonts.label((float)16.0f));
    }
}

