/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileChooser.ex;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FileNodeDescriptor
extends NodeDescriptor {
    private FileElement myFileElement;
    private final Icon myOriginalIcon;
    private final String myComment;

    public FileNodeDescriptor(Project project, @NotNull FileElement element2, NodeDescriptor parentDescriptor, Icon closedIcon, String name, String comment) {
        super(project, parentDescriptor);
        this.myOriginalIcon = closedIcon;
        this.myComment = comment;
        this.myFileElement = element2;
        this.myName = name;
    }

    public boolean update() {
        VirtualFile file2;
        boolean changed2 = false;
        if (this.myName == null || this.myComment == null) {
            String newName = this.myFileElement.toString();
            if (!newName.equals(this.myName)) {
                changed2 = true;
            }
            this.myName = newName;
        }
        if ((file2 = this.myFileElement.getFile()) == null) {
            return true;
        }
        this.setIcon(this.myOriginalIcon);
        if (this.myFileElement.isHidden()) {
            this.setIcon(IconLoader.getTransparentIcon((Icon)this.getIcon()));
        }
        this.myColor = this.myFileElement.isHidden() ? SimpleTextAttributes.DARK_TEXT.getFgColor() : null;
        return changed2;
    }

    @NotNull
    public final FileElement getElement() {
        return this.myFileElement;
    }

    protected final void setElement(FileElement descriptor2) {
        this.myFileElement = descriptor2;
    }

    public String getComment() {
        return this.myComment;
    }
}

