/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.file.exclude;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileWithId;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

class PersistentFileSetManager
implements PersistentStateComponent<Element> {
    private static final String FILE_ELEMENT = "file";
    private static final String PATH_ATTR = "url";
    private final Set<VirtualFile> myFiles = new THashSet();

    PersistentFileSetManager() {
    }

    protected boolean addFile(@NotNull VirtualFile file2) {
        if (!(file2 instanceof VirtualFileWithId) || file2.isDirectory()) {
            return false;
        }
        this.myFiles.add(file2);
        this.onFileAdded(file2);
        return true;
    }

    protected boolean containsFile(@NotNull VirtualFile file2) {
        return this.myFiles.contains(file2);
    }

    protected boolean removeFile(@NotNull VirtualFile file2) {
        boolean isRemoved = this.myFiles.remove(file2);
        if (isRemoved) {
            this.onFileRemoved(file2);
        }
        return isRemoved;
    }

    protected void onFileAdded(@NotNull VirtualFile file2) {
    }

    protected void onFileRemoved(@NotNull VirtualFile file2) {
    }

    @NotNull
    public Collection<VirtualFile> getFiles() {
        return this.myFiles;
    }

    @NotNull
    private Collection<VirtualFile> getSortedFiles() {
        ArrayList<VirtualFile> sortedFiles = new ArrayList<VirtualFile>(this.myFiles);
        sortedFiles.sort(Comparator.comparing(file2 -> StringUtil.toLowerCase((String)file2.getPath())));
        return sortedFiles;
    }

    public Element getState() {
        Element root = new Element("root");
        for (VirtualFile vf : this.getSortedFiles()) {
            Element vfElement = new Element(FILE_ELEMENT);
            Attribute filePathAttr = new Attribute(PATH_ATTR, VfsUtilCore.pathToUrl((String)vf.getPath()));
            vfElement.setAttribute(filePathAttr);
            root.addContent(vfElement);
        }
        return root;
    }

    public void loadState(@NotNull Element state) {
        THashSet oldFiles = new THashSet(this.myFiles);
        this.myFiles.clear();
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        for (Object child2 : state.getChildren(FILE_ELEMENT)) {
            String filePath;
            VirtualFile vf;
            Element fileElement;
            Attribute filePathAttr;
            if (!(child2 instanceof Element) || (filePathAttr = (fileElement = (Element)child2).getAttribute(PATH_ATTR)) == null || (vf = vfManager.findFileByUrl(filePath = filePathAttr.getValue())) == null) continue;
            this.myFiles.add(vf);
        }
        for (VirtualFile file2 : this.myFiles) {
            if (oldFiles.contains(file2)) continue;
            this.onFileAdded(file2);
        }
        for (VirtualFile file2 : oldFiles) {
            if (this.myFiles.contains(file2)) continue;
            this.onFileRemoved(file2);
        }
    }
}

