/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@Order(value=30)
public class RunConfigurationsNode
extends ExternalSystemNode<Void> {
    private final ModuleData myModuleData;

    public RunConfigurationsNode(@NotNull ExternalProjectsView externalProjectsView, ModuleNode parent) {
        super(externalProjectsView, parent, null);
        this.myModuleData = (ModuleData)parent.getData();
    }

    protected void update(@NotNull PresentationData presentation2) {
        super.update(presentation2);
        presentation2.setIcon(AllIcons.Nodes.ConfigFolder);
    }

    @Override
    public String getName() {
        return this.message("external.system.view.nodes.run_configurations.name", new Object[0]);
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.hasChildren();
    }

    @Override
    @NotNull
    protected List<? extends ExternalSystemNode<?>> doBuildChildren() {
        ArrayList<RunConfigurationNode> runConfigurationNodes = new ArrayList<RunConfigurationNode>();
        AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(this.myModuleData.getOwner());
        if (configurationType == null) {
            return Collections.emptyList();
        }
        THashSet settings = new THashSet((Collection)RunManager.getInstance((Project)this.myProject).getConfigurationSettingsList((ConfigurationType)configurationType));
        String directory = FileUtil.toCanonicalPath((String)this.myModuleData.getLinkedExternalProjectPath());
        for (RunnerAndConfigurationSettings cfg : settings) {
            ExternalSystemRunConfiguration externalSystemRunConfiguration = (ExternalSystemRunConfiguration)cfg.getConfiguration();
            if (!directory.equals(FileUtil.toCanonicalPath((String)externalSystemRunConfiguration.getSettings().getExternalProjectPath()))) continue;
            runConfigurationNodes.add(new RunConfigurationNode(this.getExternalProjectsView(), this, cfg));
        }
        return runConfigurationNodes;
    }

    public void updateRunConfigurations() {
        this.cleanUpCache();
        this.getExternalProjectsView().updateUpTo(this);
    }
}

