/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.util;

import com.intellij.build.BuildBundle;
import com.intellij.build.BuildConsoleUtils;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildEventDispatcher;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.SyncViewManager;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.EventResult;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.impl.AbstractBuildEvent;
import com.intellij.build.events.impl.FailureImpl;
import com.intellij.build.events.impl.FailureResultImpl;
import com.intellij.build.events.impl.FinishBuildEventImpl;
import com.intellij.build.events.impl.FinishEventImpl;
import com.intellij.build.events.impl.OutputBuildEventImpl;
import com.intellij.build.events.impl.ProgressBuildEventImpl;
import com.intellij.build.events.impl.SkippedResultImpl;
import com.intellij.build.events.impl.StartBuildEventImpl;
import com.intellij.build.events.impl.StartEventImpl;
import com.intellij.build.events.impl.SuccessResultImpl;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.internal.statistic.IdeActivity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.execution.ExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalSystemTaskExecutionSettings;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTask;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationEvent;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListenerAdapter;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemBuildEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemTaskExecutionEvent;
import com.intellij.openapi.externalSystem.model.task.event.Failure;
import com.intellij.openapi.externalSystem.model.task.event.FailureResult;
import com.intellij.openapi.externalSystem.model.task.event.OperationResult;
import com.intellij.openapi.externalSystem.model.task.event.SkippedResult;
import com.intellij.openapi.externalSystem.model.task.event.SuccessResult;
import com.intellij.openapi.externalSystem.service.ImportCanceledException;
import com.intellij.openapi.externalSystem.service.execution.AbstractExternalSystemTaskConfigurationType;
import com.intellij.openapi.externalSystem.service.execution.DefaultExternalSystemExecutionConsoleManager;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemEventDispatcher;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemProcessHandler;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.externalSystem.service.execution.ProgressExecutionMode;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemResolveProjectTask;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectRefreshCallback;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.externalSystem.service.project.manage.ContentRootDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.externalSystem.task.TaskCallback;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowEP;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ExternalSystemUtil {
    private static final Logger LOG = Logger.getInstance(ExternalSystemUtil.class);
    @NotNull
    private static final Map<String, String> RUNNER_IDS = new HashMap<String, String>();
    public static final TObjectHashingStrategy<Pair<ProjectSystemId, File>> HASHING_STRATEGY = new TObjectHashingStrategy<Pair<ProjectSystemId, File>>(){

        public int computeHashCode(Pair<ProjectSystemId, File> object) {
            return ((ProjectSystemId)object.first).hashCode() + FileUtil.fileHashCode((File)((File)object.second));
        }

        public boolean equals(Pair<ProjectSystemId, File> o1, Pair<ProjectSystemId, File> o2) {
            return ((ProjectSystemId)o1.first).equals(o2.first) && FileUtil.filesEqual((File)((File)o1.second), (File)((File)o2.second));
        }
    };

    private ExternalSystemUtil() {
    }

    public static int fileHashCode(@Nullable File file2) {
        int hash;
        try {
            hash = FileUtil.pathHashCode((String)(file2 == null ? null : file2.getCanonicalPath()));
        }
        catch (IOException e) {
            LOG.warn("unable to get canonical file path", (Throwable)e);
            hash = FileUtil.fileHashCode((File)file2);
        }
        return hash;
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        try {
            return FileUtil.pathsEqual((String)(file1 == null ? null : file1.getCanonicalPath()), (String)(file2 == null ? null : file2.getCanonicalPath()));
        }
        catch (IOException e) {
            LOG.warn("unable to get canonical file path", (Throwable)e);
            return FileUtil.filesEqual((File)file1, (File)file2);
        }
    }

    public static void ensureToolWindowInitialized(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        try {
            ToolWindowManager manager = ToolWindowManager.getInstance((Project)project);
            if (!(manager instanceof ToolWindowManagerEx)) {
                return;
            }
            ToolWindowManagerEx managerEx = (ToolWindowManagerEx)manager;
            String id2 = externalSystemId.getReadableName();
            ToolWindow window = manager.getToolWindow(id2);
            if (window != null) {
                return;
            }
            for (ToolWindowEP bean : ToolWindowEP.EP_NAME.getExtensionList()) {
                if (!id2.equals(bean.id)) continue;
                managerEx.initToolWindow(bean);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Unable to initialize %s tool window", externalSystemId.getReadableName()), (Throwable)e);
        }
    }

    @Nullable
    public static ToolWindow ensureToolWindowContentInitialized(@NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        return ToolWindowManager.getInstance((Project)project).getToolWindow(externalSystemId.getReadableName());
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, boolean force) {
        ExternalSystemUtil.refreshProjects(project, externalSystemId, force, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    @Deprecated
    public static void refreshProjects(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, boolean force, @NotNull ProgressExecutionMode progressExecutionMode) {
        ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project, externalSystemId).forceWhenUptodate(force).use(progressExecutionMode));
    }

    public static void refreshProjects(@NotNull ImportSpecBuilder specBuilder) {
        ExternalSystemUtil.refreshProjects(specBuilder.build());
    }

    public static void refreshProjects(@NotNull ImportSpec spec) {
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)spec.getExternalSystemId());
        if (manager == null) {
            return;
        }
        AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)spec.getProject());
        Collection projectsSettings = settings.getLinkedProjectsSettings();
        if (projectsSettings.isEmpty()) {
            return;
        }
        ExternalProjectRefreshCallback callback2 = spec.getCallback() == null ? new MyMultiExternalProjectRefreshCallback(spec.getProject()) : spec.getCallback();
        HashSet<String> toRefresh = new HashSet<String>();
        for (ExternalProjectSettings setting : projectsSettings) {
            toRefresh.add(setting.getExternalProjectPath());
        }
        if (!toRefresh.isEmpty()) {
            ExternalSystemNotificationManager.getInstance(spec.getProject()).clearNotifications(null, NotificationSource.PROJECT_SYNC, spec.getExternalSystemId());
            for (String path : toRefresh) {
                ExternalSystemUtil.refreshProject(path, new ImportSpecBuilder(spec).callback(callback2));
            }
        }
    }

    @NotNull
    private static String extractDetails(@NotNull Throwable e) {
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)e);
        if (unwrapped instanceof ExternalSystemException) {
            return ((ExternalSystemException)unwrapped).getOriginalReason();
        }
        return ExternalSystemApiUtil.stacktraceAsString((Throwable)e);
    }

    public static void refreshProject(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        ImportSpecBuilder builder2 = new ImportSpecBuilder(project, externalSystemId).use(progressExecutionMode);
        if (isPreviewMode) {
            builder2.usePreviewMode();
        }
        ExternalSystemUtil.refreshProject(externalProjectPath, builder2);
    }

    public static void refreshProject(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, @NotNull ExternalProjectRefreshCallback callback2, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        ImportSpecBuilder builder2 = new ImportSpecBuilder(project, externalSystemId).callback(callback2).use(progressExecutionMode);
        if (isPreviewMode) {
            builder2.usePreviewMode();
        }
        ExternalSystemUtil.refreshProject(externalProjectPath, builder2);
    }

    public static void refreshProject(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull String externalProjectPath, @NotNull ExternalProjectRefreshCallback callback2, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode, boolean reportRefreshError) {
        ImportSpecBuilder builder2 = new ImportSpecBuilder(project, externalSystemId).callback(callback2).use(progressExecutionMode);
        if (isPreviewMode) {
            builder2.usePreviewMode();
        }
        if (!reportRefreshError) {
            builder2.dontReportRefreshErrors();
        }
        ExternalSystemUtil.refreshProject(externalProjectPath, builder2);
    }

    public static void refreshProject(@NotNull String externalProjectPath, @NotNull ImportSpecBuilder importSpecBuilder) {
        ExternalSystemUtil.refreshProject(externalProjectPath, importSpecBuilder.build());
    }

    public static void refreshProject(final @NotNull String externalProjectPath, final @NotNull ImportSpec importSpec) {
        final Project project = importSpec.getProject();
        final ProjectSystemId externalSystemId = importSpec.getExternalSystemId();
        final ExternalProjectRefreshCallback callback2 = importSpec.getCallback();
        final boolean isPreviewMode = importSpec.isPreviewMode();
        ProgressExecutionMode progressExecutionMode = importSpec.getProgressExecutionMode();
        final boolean reportRefreshError = importSpec.isReportRefreshError();
        final File projectFile = new File(externalProjectPath);
        final String projectName = projectFile.isFile() ? projectFile.getParentFile().getName() : projectFile.getName();
        AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)project, (ProjectSystemId)externalSystemId);
        AbstractExternalSystemLocalSettings.SyncType syncType = isPreviewMode ? AbstractExternalSystemLocalSettings.SyncType.PREVIEW : (localSettings.getProjectSyncType().get(externalProjectPath) == AbstractExternalSystemLocalSettings.SyncType.PREVIEW ? AbstractExternalSystemLocalSettings.SyncType.IMPORT : AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT);
        localSettings.getProjectSyncType().put(externalProjectPath, syncType);
        final ExternalSystemResolveProjectTask resolveProjectTask = new ExternalSystemResolveProjectTask(project, externalProjectPath, importSpec);
        final TaskUnderProgress refreshProjectStructureTask = new TaskUnderProgress(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                IdeActivity activity = ExternalSystemStatUtilKt.importActivityStarted(project, externalSystemId, data2 -> {});
                try {
                    DumbService.getInstance((Project)project).suspendIndexingAndRun(title, () -> this.executeImpl(indicator));
                }
                finally {
                    activity.finished();
                }
            }

            private void executeImpl(@NotNull ProgressIndicator indicator) {
                ExternalSystemProcessingManager processingManager;
                if (project.isDisposed()) {
                    return;
                }
                if (indicator instanceof ProgressIndicatorEx) {
                    ((ProgressIndicatorEx)indicator).addStateDelegate(new AbstractProgressIndicatorExBase(){

                        @Override
                        public void cancel() {
                            super.cancel();
                            this.cancelImport();
                        }
                    });
                }
                if ((processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class)).findTask(ExternalSystemTaskType.RESOLVE_PROJECT, externalSystemId, externalProjectPath) != null) {
                    if (callback2 != null) {
                        callback2.onFailure(resolveProjectTask.getId(), ExternalSystemBundle.message((String)"error.resolve.already.running", (Object[])new Object[]{externalProjectPath}), null);
                    }
                    return;
                }
                if (!(callback2 instanceof MyMultiExternalProjectRefreshCallback)) {
                    ExternalSystemNotificationManager.getInstance(project).clearNotifications(null, NotificationSource.PROJECT_SYNC, externalSystemId);
                }
                ExternalSystemTaskActivator externalSystemTaskActivator = ExternalProjectsManagerImpl.getInstance(project).getTaskActivator();
                if (!isPreviewMode && !externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.BEFORE_SYNC)) {
                    return;
                }
                final ExternalSystemProcessHandler processHandler2 = new ExternalSystemProcessHandler(resolveProjectTask, projectName + " import"){

                    @Override
                    protected void destroyProcessImpl() {
                        this.cancelImport();
                        this.closeInput();
                    }
                };
                final ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler> consoleManager = ExternalSystemUtil.getConsoleManagerFor(resolveProjectTask);
                final ExecutionConsole consoleView = consoleManager.attachExecutionConsole(project, (ExternalSystemTask)resolveProjectTask, null, (ProcessHandler)processHandler2);
                if (consoleView != null) {
                    Disposer.register((Disposable)project, (Disposable)consoleView);
                } else {
                    Disposer.register((Disposable)project, (Disposable)processHandler2);
                }
                final Ref finishSyncEventSupplier = Ref.create();
                final SyncViewManager syncViewManager = (SyncViewManager)ServiceManager.getService((Project)project, SyncViewManager.class);
                try (final ExternalSystemEventDispatcher eventDispatcher = new ExternalSystemEventDispatcher(resolveProjectTask.getId(), syncViewManager, false);){
                    ExternalSystemTaskNotificationListenerAdapter taskListener = new ExternalSystemTaskNotificationListenerAdapter(){

                        public void onStart(@NotNull ExternalSystemTaskId id2, String workingDir) {
                            long eventTime = System.currentTimeMillis();
                            if (isPreviewMode) {
                                return;
                            }
                            DefaultBuildDescriptor buildDescriptor = new DefaultBuildDescriptor(id2, projectName, externalProjectPath, eventTime).withProcessHandler(processHandler2, null).withContentDescriptor(() -> {
                                if (consoleView == null) {
                                    return null;
                                }
                                boolean activateToolWindow2 = ExternalSystemUtil.isNewProject(project);
                                BuildContentDescriptor contentDescriptor = new BuildContentDescriptor(consoleView, (ProcessHandler)processHandler2, consoleView.getComponent(), ExternalSystemBundle.message((String)"build.event.title.sync", (Object[])new Object[0]));
                                contentDescriptor.setActivateToolWindowWhenAdded(activateToolWindow2);
                                contentDescriptor.setActivateToolWindowWhenFailed(reportRefreshError);
                                contentDescriptor.setAutoFocusContent(reportRefreshError);
                                return contentDescriptor;
                            });
                            Filter[] filters = consoleManager.getCustomExecutionFilters(project, (ExternalSystemTask)resolveProjectTask, null);
                            Arrays.stream(filters).forEach(buildDescriptor::withExecutionFilter);
                            eventDispatcher.onEvent(id2, new StartBuildEventImpl(buildDescriptor, BuildBundle.message("build.event.message.syncing", new Object[0])));
                        }

                        public void onTaskOutput(@NotNull ExternalSystemTaskId id2, @NotNull String text, boolean stdOut) {
                            processHandler2.notifyTextAvailable(text, stdOut ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR);
                            eventDispatcher.setStdOut(stdOut);
                            eventDispatcher.append(text);
                        }

                        public void onFailure(@NotNull ExternalSystemTaskId id2, @NotNull Exception e) {
                            String title = ExternalSystemBundle.message((String)"notification.project.refresh.fail.title", (Object[])new Object[]{externalSystemId.getReadableName(), projectName});
                            DataProvider dataProvider = BuildConsoleUtils.getDataProvider((Object)id2, syncViewManager);
                            FailureResultImpl failureResult = ExternalSystemUtil.createFailureResult(title, e, externalSystemId, project, dataProvider);
                            finishSyncEventSupplier.set(() -> new FinishBuildEventImpl(id2, null, System.currentTimeMillis(), BuildBundle.message("build.status.failed", new Object[0]), (EventResult)failureResult));
                            processHandler2.notifyProcessTerminated(1);
                        }

                        public void onSuccess(@NotNull ExternalSystemTaskId id2) {
                            finishSyncEventSupplier.set(() -> new FinishBuildEventImpl(id2, null, System.currentTimeMillis(), BuildBundle.message("build.status.finished", new Object[0]), (EventResult)new SuccessResultImpl()));
                            processHandler2.notifyProcessTerminated(0);
                        }

                        public void onStatusChange(@NotNull ExternalSystemTaskNotificationEvent event) {
                            if (isPreviewMode) {
                                return;
                            }
                            if (event instanceof ExternalSystemBuildEvent) {
                                BuildEvent buildEvent = ((ExternalSystemBuildEvent)event).getBuildEvent();
                                eventDispatcher.onEvent(event.getId(), buildEvent);
                            } else if (event instanceof ExternalSystemTaskExecutionEvent) {
                                BuildEvent buildEvent = ExternalSystemUtil.convert((ExternalSystemTaskExecutionEvent)event);
                                eventDispatcher.onEvent(event.getId(), buildEvent);
                            }
                        }
                    };
                    LOG.info("External project [" + externalProjectPath + "] resolution task started");
                    long startTS = System.currentTimeMillis();
                    resolveProjectTask.execute(indicator, new ExternalSystemTaskNotificationListener[]{taskListener});
                    LOG.info("External project [" + externalProjectPath + "] resolution task executed in " + (System.currentTimeMillis() - startTS) + " ms.");
                    this.handExecutionResult(externalSystemTaskActivator, eventDispatcher, (Ref<Supplier<FinishBuildEvent>>)finishSyncEventSupplier);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private void handExecutionResult(@NotNull ExternalSystemTaskActivator externalSystemTaskActivator, @NotNull BuildEventDispatcher eventDispatcher, @NotNull Ref<Supplier<FinishBuildEvent>> finishSyncEventSupplier) {
                VirtualFile virtualFile;
                Throwable error;
                block15: {
                    VirtualFile virtualFile2;
                    block14: {
                        VirtualFile virtualFile3;
                        if (project.isDisposed()) {
                            return;
                        }
                        try {
                            ExternalProjectInfo externalProjectData;
                            error = resolveProjectTask.getError();
                            if (error != null) break block14;
                            if (callback2 != null && (externalProjectData = ProjectDataManagerImpl.getInstance().getExternalProjectData(project, externalSystemId, externalProjectPath)) != null) {
                                DataNode externalProject = externalProjectData.getExternalProjectStructure();
                                if (externalProject != null && importSpec.shouldCreateDirectoriesForEmptyContentRoots()) {
                                    externalProject.putUserData(ContentRootDataService.CREATE_EMPTY_DIRECTORIES, (Object)Boolean.TRUE);
                                }
                                callback2.onSuccess(resolveProjectTask.getId(), externalProject);
                            }
                            if (!isPreviewMode) {
                                externalSystemTaskActivator.runTasks(externalProjectPath, ExternalSystemTaskActivator.Phase.AFTER_SYNC);
                            }
                            if (isPreviewMode) return;
                        }
                        catch (Throwable throwable) {
                            VirtualFile virtualFile4;
                            if (isPreviewMode) throw throwable;
                            boolean isNewProject = ExternalSystemUtil.isNewProject(project);
                            if (isNewProject && (virtualFile4 = VfsUtil.findFileByIoFile((File)projectFile, (boolean)false)) != null) {
                                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile4});
                            }
                            project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                            project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                            eventDispatcher.onEvent(resolveProjectTask.getId(), (BuildEvent)this.getSyncFinishEvent(finishSyncEventSupplier));
                            throw throwable;
                        }
                        boolean isNewProject = ExternalSystemUtil.isNewProject(project);
                        if (isNewProject && (virtualFile3 = VfsUtil.findFileByIoFile((File)projectFile, (boolean)false)) != null) {
                            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile3});
                        }
                        project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                        project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                        eventDispatcher.onEvent(resolveProjectTask.getId(), (BuildEvent)this.getSyncFinishEvent(finishSyncEventSupplier));
                        return;
                    }
                    if (!(error instanceof ImportCanceledException)) break block15;
                    if (isPreviewMode) return;
                    boolean isNewProject = ExternalSystemUtil.isNewProject(project);
                    if (isNewProject && (virtualFile2 = VfsUtil.findFileByIoFile((File)projectFile, (boolean)false)) != null) {
                        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile2});
                    }
                    project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                    project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                    eventDispatcher.onEvent(resolveProjectTask.getId(), (BuildEvent)this.getSyncFinishEvent(finishSyncEventSupplier));
                    return;
                }
                String message = ExternalSystemApiUtil.buildErrorMessage((Throwable)error);
                if (StringUtil.isEmpty((String)message)) {
                    message = String.format("Can't resolve %s project at '%s'. Reason: %s", externalSystemId.getReadableName(), externalProjectPath, message);
                }
                if (callback2 != null) {
                    callback2.onFailure(resolveProjectTask.getId(), message, ExternalSystemUtil.extractDetails(error));
                }
                if (isPreviewMode) return;
                boolean isNewProject = ExternalSystemUtil.isNewProject(project);
                if (isNewProject && (virtualFile = VfsUtil.findFileByIoFile((File)projectFile, (boolean)false)) != null) {
                    VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
                }
                project.putUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT, null);
                project.putUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT, null);
                eventDispatcher.onEvent(resolveProjectTask.getId(), (BuildEvent)this.getSyncFinishEvent(finishSyncEventSupplier));
            }

            @NotNull
            private FinishBuildEvent getSyncFinishEvent(@NotNull Ref<? extends Supplier<FinishBuildEvent>> finishSyncEventSupplier) {
                Exception exception = null;
                Supplier finishBuildEventSupplier = (Supplier)finishSyncEventSupplier.get();
                if (finishBuildEventSupplier != null) {
                    try {
                        return (FinishBuildEvent)finishBuildEventSupplier.get();
                    }
                    catch (Exception e) {
                        exception = e;
                    }
                }
                String message = "Sync finish event has not been received";
                LOG.warn(message, (Throwable)exception);
                return new FinishBuildEventImpl(resolveProjectTask.getId(), null, System.currentTimeMillis(), BuildBundle.message("build.status.failed", new Object[0]), (EventResult)new FailureResultImpl(new Exception(message, exception)));
            }

            private void cancelImport() {
                resolveProjectTask.cancel(new ExternalSystemTaskNotificationListener[0]);
            }
        };
        TransactionGuard.getInstance().assertWriteSafeContext(ModalityState.defaultModalityState());
        ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManager)FileDocumentManager.getInstance()).saveAllDocuments());
        switch (progressExecutionMode) {
            case NO_PROGRESS_SYNC: 
            case NO_PROGRESS_ASYNC: {
                throw new ExternalSystemException("Please, use progress for the project import!");
            }
            case MODAL_SYNC: {
                String title = ExternalSystemBundle.message((String)"progress.import.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                new Task.Modal(project, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        refreshProjectStructureTask.execute(indicator);
                    }
                }.queue();
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                new Task.Backgroundable(project, title){

                    public void run(@NotNull ProgressIndicator indicator) {
                        refreshProjectStructureTask.execute(indicator);
                    }
                }.queue();
                break;
            }
            case START_IN_FOREGROUND_ASYNC: {
                String title = ExternalSystemBundle.message((String)"progress.refresh.text", (Object[])new Object[]{projectName, externalSystemId.getReadableName()});
                new Task.Backgroundable(project, title, true, PerformInBackgroundOption.DEAF){

                    public void run(@NotNull ProgressIndicator indicator) {
                        refreshProjectStructureTask.execute(indicator);
                    }
                }.queue();
            }
        }
    }

    public static boolean isNewProject(Project project) {
        return project.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE || project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
    }

    @ApiStatus.Internal
    @NotNull
    public static FailureResultImpl createFailureResult(@NotNull String title, @NotNull Exception exception, @NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull DataProvider dataProvider) {
        ExternalSystemNotificationManager notificationManager2 = ExternalSystemNotificationManager.getInstance(project);
        NotificationData notificationData = notificationManager2.createNotification(title, exception, externalSystemId, project, dataProvider);
        if (notificationData == null) {
            return new FailureResultImpl();
        }
        return ExternalSystemUtil.createFailureResult(exception, externalSystemId, project, notificationManager2, notificationData);
    }

    @NotNull
    private static FailureResultImpl createFailureResult(@NotNull Exception exception, @NotNull ProjectSystemId externalSystemId, @NotNull Project project, @NotNull ExternalSystemNotificationManager notificationManager2, @NotNull NotificationData notificationData) {
        VirtualFile virtualFile;
        NotificationGroup registeredGroup;
        ExternalProjectsView externalProjectsView;
        if (notificationData.isBalloonNotification()) {
            notificationManager2.showNotification(externalSystemId, notificationData);
            return new FailureResultImpl(exception);
        }
        NotificationGroup group = notificationData.getBalloonGroup() == null ? ((externalProjectsView = ExternalProjectsManagerImpl.getInstance(project).getExternalProjectsView(externalSystemId)) instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)externalProjectsView).getNotificationGroup() : null) : ((registeredGroup = NotificationGroup.findRegisteredGroup((String)notificationData.getBalloonGroup())) != null ? registeredGroup : NotificationGroup.balloonGroup((String)notificationData.getBalloonGroup()));
        int line = notificationData.getLine() - 1;
        int column = notificationData.getColumn() - 1;
        VirtualFile virtualFile2 = virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        Object navigatable = notificationData.getNavigatable() == null || notificationData.getNavigatable() instanceof NonNavigatable ? (virtualFile != null ? new OpenFileDescriptor(project, virtualFile, line, column) : NonNavigatable.INSTANCE) : notificationData.getNavigatable();
        Notification notification = group == null ? new Notification(externalSystemId.getReadableName() + " build", notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener()) : group.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener());
        return new FailureResultImpl(Collections.singletonList(new FailureImpl(notificationData.getMessage(), exception, notification, (Navigatable)navigatable)));
    }

    public static BuildEvent convert(ExternalSystemTaskExecutionEvent taskExecutionEvent) {
        AbstractBuildEvent buildEvent;
        ExternalSystemProgressEvent progressEvent = taskExecutionEvent.getProgressEvent();
        String displayName = progressEvent.getDescriptor().getDisplayName();
        long eventTime = progressEvent.getDescriptor().getEventTime();
        Object parentEventId = ObjectUtils.chooseNotNull((Object)progressEvent.getParentEventId(), (Object)taskExecutionEvent.getId());
        if (progressEvent instanceof ExternalSystemStartEvent) {
            buildEvent = new StartEventImpl(progressEvent.getEventId(), parentEventId, eventTime, displayName);
        } else if (progressEvent instanceof ExternalSystemFinishEvent) {
            Object eventResult;
            OperationResult operationResult = ((ExternalSystemFinishEvent)progressEvent).getOperationResult();
            if (operationResult instanceof FailureResult) {
                SmartList failures = new SmartList();
                for (Failure failure : ((FailureResult)operationResult).getFailures()) {
                    failures.add(ExternalSystemUtil.convert(failure));
                }
                eventResult = new FailureResultImpl((List<com.intellij.build.events.Failure>)failures);
            } else {
                eventResult = operationResult instanceof SkippedResult ? new SkippedResultImpl() : (operationResult instanceof SuccessResult ? new SuccessResultImpl(((SuccessResult)operationResult).isUpToDate()) : new SuccessResultImpl());
            }
            buildEvent = new FinishEventImpl(progressEvent.getEventId(), parentEventId, eventTime, displayName, (EventResult)eventResult);
        } else if (progressEvent instanceof ExternalSystemStatusEvent) {
            ExternalSystemStatusEvent statusEvent = (ExternalSystemStatusEvent)progressEvent;
            buildEvent = new ProgressBuildEventImpl(progressEvent.getEventId(), progressEvent.getParentEventId(), eventTime, displayName, statusEvent.getTotal(), statusEvent.getProgress(), statusEvent.getUnit());
        } else {
            buildEvent = new OutputBuildEventImpl((Object)progressEvent.getEventId(), parentEventId, displayName, true);
        }
        String hint = progressEvent.getDescriptor().getHint();
        buildEvent.setHint(hint);
        return buildEvent;
    }

    private static com.intellij.build.events.Failure convert(Failure failure) {
        SmartList causes = new SmartList();
        for (Failure cause : failure.getCauses()) {
            causes.add(ExternalSystemUtil.convert(cause));
        }
        return new FailureImpl(failure.getMessage(), failure.getDescription(), (List<? extends com.intellij.build.events.Failure>)causes);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        ExternalSystemUtil.runTask(taskSettings, executorId, project, externalSystemId, null, ProgressExecutionMode.IN_BACKGROUND_ASYNC);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable TaskCallback callback2, @NotNull ProgressExecutionMode progressExecutionMode) {
        ExternalSystemUtil.runTask(taskSettings, executorId, project, externalSystemId, callback2, progressExecutionMode, true);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId, @NotNull Project project, @NotNull ProjectSystemId externalSystemId, @Nullable TaskCallback callback2, @NotNull ProgressExecutionMode progressExecutionMode, boolean activateToolWindowBeforeRun) {
        ExternalSystemUtil.runTask(taskSettings, executorId, project, externalSystemId, callback2, progressExecutionMode, activateToolWindowBeforeRun, null);
    }

    public static void runTask(@NotNull ExternalSystemTaskExecutionSettings taskSettings, final @NotNull String executorId, final @NotNull Project project, @NotNull ProjectSystemId externalSystemId, final @Nullable TaskCallback callback2, @NotNull ProgressExecutionMode progressExecutionMode, boolean activateToolWindowBeforeRun, @Nullable UserDataHolderBase userData) {
        final ExecutionEnvironment environment = ExternalSystemUtil.createExecutionEnvironment(project, externalSystemId, taskSettings, executorId);
        if (environment == null) {
            LOG.warn("Execution environment for " + externalSystemId + " is null");
            return;
        }
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = environment.getRunnerAndConfigurationSettings();
        assert (runnerAndConfigurationSettings != null);
        runnerAndConfigurationSettings.setActivateToolWindowBeforeRun(activateToolWindowBeforeRun);
        if (userData != null) {
            ExternalSystemRunConfiguration runConfiguration = (ExternalSystemRunConfiguration)runnerAndConfigurationSettings.getConfiguration();
            userData.copyUserDataTo((UserDataHolderBase)runConfiguration);
        }
        final TaskUnderProgress task2 = new TaskUnderProgress(){

            @Override
            public void execute(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                final Semaphore targetDone = new Semaphore();
                final Ref result2 = new Ref((Object)false);
                Disposable disposable2 = Disposer.newDisposable();
                project.getMessageBus().connect(disposable2).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

                    public void processStartScheduled(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                        if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                            targetDone.down();
                        }
                    }

                    public void processNotStarted(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal) {
                        if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                            targetDone.up();
                        }
                    }

                    public void processTerminated(@NotNull String executorIdLocal, @NotNull ExecutionEnvironment environmentLocal, @NotNull ProcessHandler handler2, int exitCode) {
                        if (executorId.equals(executorIdLocal) && environment.equals(environmentLocal)) {
                            result2.set((Object)(exitCode == 0 ? 1 : 0));
                            targetDone.up();
                        }
                    }
                });
                try {
                    ApplicationManager.getApplication().invokeAndWait(() -> {
                        try {
                            environment.getRunner().execute(environment);
                        }
                        catch (ExecutionException e) {
                            targetDone.up();
                            LOG.error((Throwable)e);
                        }
                    }, ModalityState.defaultModalityState());
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                    Disposer.dispose((Disposable)disposable2);
                    return;
                }
                targetDone.waitFor();
                Disposer.dispose((Disposable)disposable2);
                if (callback2 != null) {
                    if (((Boolean)result2.get()).booleanValue()) {
                        callback2.onSuccess();
                    } else {
                        callback2.onFailure();
                    }
                }
                if (!((Boolean)result2.get()).booleanValue()) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        ToolWindow window = ToolWindowManager.getInstance((Project)project).getToolWindow(environment.getExecutor().getToolWindowId());
                        if (window != null) {
                            window.activate(null, false, false);
                        }
                    }, project.getDisposed());
                }
            }
        };
        String title = AbstractExternalSystemTaskConfigurationType.generateName(project, taskSettings);
        switch (progressExecutionMode) {
            case NO_PROGRESS_SYNC: {
                task2.execute((ProgressIndicator)new EmptyProgressIndicator());
                break;
            }
            case MODAL_SYNC: {
                new Task.Modal(project, title, true){

                    public void run(@NotNull ProgressIndicator indicator) {
                        task2.execute(indicator);
                    }
                }.queue();
                break;
            }
            case NO_PROGRESS_ASYNC: {
                ApplicationManager.getApplication().executeOnPooledThread(() -> task2.execute((ProgressIndicator)new EmptyProgressIndicator()));
                break;
            }
            case IN_BACKGROUND_ASYNC: {
                new Task.Backgroundable(project, title){

                    public void run(@NotNull ProgressIndicator indicator) {
                        task2.execute(indicator);
                    }
                }.queue();
                break;
            }
            case START_IN_FOREGROUND_ASYNC: {
                new Task.Backgroundable(project, title, true, PerformInBackgroundOption.DEAF){

                    public void run(@NotNull ProgressIndicator indicator) {
                        task2.execute(indicator);
                    }
                }.queue();
            }
        }
    }

    @Nullable
    public static ExecutionEnvironment createExecutionEnvironment(@NotNull Project project, @NotNull ProjectSystemId externalSystemId, @NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull String executorId) {
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            return null;
        }
        String runnerId = ExternalSystemUtil.getRunnerId(executorId);
        if (runnerId == null) {
            return null;
        }
        ProgramRunner runner = ProgramRunner.findRunnerById((String)runnerId);
        if (runner == null) {
            return null;
        }
        RunnerAndConfigurationSettings settings = ExternalSystemUtil.createExternalSystemRunnerAndConfigurationSettings(taskSettings, project, externalSystemId);
        if (settings == null) {
            return null;
        }
        return new ExecutionEnvironment(executor, runner, settings, project);
    }

    @Nullable
    public static RunnerAndConfigurationSettings createExternalSystemRunnerAndConfigurationSettings(@NotNull ExternalSystemTaskExecutionSettings taskSettings, @NotNull Project project, @NotNull ProjectSystemId externalSystemId) {
        AbstractExternalSystemTaskConfigurationType configurationType = ExternalSystemUtil.findConfigurationType(externalSystemId);
        if (configurationType == null) {
            return null;
        }
        String name = AbstractExternalSystemTaskConfigurationType.generateName(project, taskSettings);
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).createConfiguration(name, configurationType.getFactory());
        ((ExternalSystemRunConfiguration)settings.getConfiguration()).getSettings().setFrom(taskSettings);
        return settings;
    }

    @Nullable
    public static AbstractExternalSystemTaskConfigurationType findConfigurationType(@NotNull ProjectSystemId externalSystemId) {
        for (ConfigurationType type : ConfigurationType.CONFIGURATION_TYPE_EP.getExtensionList()) {
            AbstractExternalSystemTaskConfigurationType candidate;
            if (!(type instanceof AbstractExternalSystemTaskConfigurationType) || !externalSystemId.equals((Object)(candidate = (AbstractExternalSystemTaskConfigurationType)type).getExternalSystemId())) continue;
            return candidate;
        }
        return null;
    }

    @Nullable
    public static String getRunnerId(@NotNull String executorId) {
        return RUNNER_IDS.get(executorId);
    }

    public static void linkExternalProject(@NotNull ProjectSystemId externalSystemId, @NotNull ExternalProjectSettings projectSettings, final @NotNull Project project, final @Nullable Consumer<? super Boolean> importResultCallback, boolean isPreviewMode, @NotNull ProgressExecutionMode progressExecutionMode) {
        AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)externalSystemId);
        ExternalProjectSettings existingSettings = systemSettings.getLinkedProjectSettings(projectSettings.getExternalProjectPath());
        if (existingSettings != null) {
            return;
        }
        systemSettings.linkProject(projectSettings);
        ExternalSystemUtil.ensureToolWindowInitialized(project, externalSystemId);
        ExternalProjectRefreshCallback callback2 = new ExternalProjectRefreshCallback(){

            public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
                if (externalProject == null) {
                    if (importResultCallback != null) {
                        importResultCallback.consume((Object)false);
                    }
                    return;
                }
                ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, project, true);
                if (importResultCallback != null) {
                    importResultCallback.consume((Object)true);
                }
            }

            public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
                if (importResultCallback != null) {
                    importResultCallback.consume((Object)false);
                }
            }
        };
        ImportSpecBuilder importSpecBuilder = new ImportSpecBuilder(project, externalSystemId).callback(callback2).use(progressExecutionMode);
        if (isPreviewMode) {
            importSpecBuilder.usePreviewMode();
        }
        ExternalSystemUtil.refreshProject(projectSettings.getExternalProjectPath(), importSpecBuilder);
    }

    @Nullable
    public static VirtualFile refreshAndFindFileByIoFile(@NotNull File file2) {
        Application app = ApplicationManager.getApplication();
        if (!app.isDispatchThread()) assert (!((ApplicationEx)app).holdsReadLock());
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
    }

    @Nullable
    public static VirtualFile findLocalFileByPath(String path) {
        return ApplicationManager.getApplication().isReadAccessAllowed() ? ExternalSystemUtil.findLocalFileByPathUnderReadAction(path) : ExternalSystemUtil.findLocalFileByPathUnderWriteAction(path);
    }

    @Nullable
    private static VirtualFile findLocalFileByPathUnderWriteAction(String path) {
        return (VirtualFile)ExternalSystemApiUtil.doWriteAction(() -> StandardFileSystems.local().refreshAndFindFileByPath(path));
    }

    @Nullable
    private static VirtualFile findLocalFileByPathUnderReadAction(String path) {
        return (VirtualFile)ReadAction.compute(() -> StandardFileSystems.local().findFileByPath(path));
    }

    public static void scheduleExternalViewStructureUpdate(@NotNull Project project, @NotNull ProjectSystemId systemId) {
        ExternalProjectsView externalProjectsView = ExternalProjectsManagerImpl.getInstance(project).getExternalProjectsView(systemId);
        if (externalProjectsView instanceof ExternalProjectsViewImpl) {
            ((ExternalProjectsViewImpl)externalProjectsView).scheduleStructureUpdate();
        }
    }

    @Nullable
    public static ExternalProjectInfo getExternalProjectInfo(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        ExternalProjectSettings linkedProjectSettings = ExternalSystemApiUtil.getSettings((Project)project, (ProjectSystemId)projectSystemId).getLinkedProjectSettings(externalProjectPath);
        if (linkedProjectSettings == null) {
            return null;
        }
        return ProjectDataManagerImpl.getInstance().getExternalProjectData(project, projectSystemId, linkedProjectSettings.getExternalProjectPath());
    }

    @NotNull
    public static ExternalSystemExecutionConsoleManager<ExecutionConsole, ProcessHandler> getConsoleManagerFor(@NotNull ExternalSystemTask task2) {
        for (ExternalSystemExecutionConsoleManager executionConsoleManager : (ExternalSystemExecutionConsoleManager[])ExternalSystemExecutionConsoleManager.EP_NAME.getExtensions()) {
            if (!executionConsoleManager.isApplicableFor(task2)) continue;
            return executionConsoleManager;
        }
        return new DefaultExternalSystemExecutionConsoleManager();
    }

    public static void invokeLater(Project p, Runnable r) {
        ExternalSystemUtil.invokeLater(p, ModalityState.defaultModalityState(), r);
    }

    public static void invokeLater(Project p, ModalityState state, Runnable r) {
        if (ExternalSystemUtil.isNoBackgroundMode()) {
            r.run();
        } else {
            ApplicationManager.getApplication().invokeLater(r, state, p.getDisposed());
        }
    }

    public static boolean isNoBackgroundMode() {
        return ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment();
    }

    static {
        RUNNER_IDS.put("Run", "ExternalSystemTaskRunner");
        String debugExecutorId = "Debug";
        RUNNER_IDS.put(debugExecutorId, "ExternalSystemTaskDebugRunner");
    }

    private static class MyMultiExternalProjectRefreshCallback
    implements ExternalProjectRefreshCallback {
        private final Project myProject;

        MyMultiExternalProjectRefreshCallback(Project project) {
            this.myProject = project;
        }

        public void onSuccess(@Nullable DataNode<ProjectData> externalProject) {
            if (externalProject == null) {
                return;
            }
            ((ProjectDataManager)ServiceManager.getService(ProjectDataManager.class)).importData(externalProject, this.myProject, true);
        }

        public void onFailure(@NotNull String errorMessage, @Nullable String errorDetails) {
            LOG.warn(errorMessage + "\n" + errorDetails);
        }
    }

    private static interface TaskUnderProgress {
        public void execute(@NotNull ProgressIndicator var1);
    }
}

