/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.ui;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.ui.SelectExternalSystemNodeDialog;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ProjectNode;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.NullNode;
import com.intellij.ui.treeStructure.SimpleNode;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectExternalProjectDialog
extends SelectExternalSystemNodeDialog {
    private ProjectData myResult;

    public SelectExternalProjectDialog(@NotNull ProjectSystemId systemId, Project project, ProjectData current2) {
        super(systemId, project, String.format("Select %s Project", systemId.getReadableName()), ProjectNode.class, (SimpleNode node) -> node instanceof ProjectNode && ((ProjectNode)node).getData() == current2);
        assert (current2 == null || current2.getOwner().equals((Object)systemId));
        this.init();
    }

    protected Action @NotNull [] createActions() {
        AbstractAction selectNoneAction = new AbstractAction(ExternalSystemBundle.message((String)"action.text.none", (Object[])new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectExternalProjectDialog.this.doOKAction();
                SelectExternalProjectDialog.this.myResult = null;
            }
        };
        return new Action[]{selectNoneAction, this.getOKAction(), this.getCancelAction()};
    }

    protected void doOKAction() {
        SimpleNode node = this.getSelectedNode();
        if (node instanceof NullNode) {
            node = null;
        }
        this.myResult = node instanceof ProjectNode ? (ProjectData)((ProjectNode)node).getData() : null;
        super.doOKAction();
    }

    @Override
    protected void handleDoubleClickOrEnter(@NotNull ExternalSystemNode node, @Nullable String actionId, InputEvent inputEvent) {
        if (node instanceof ProjectNode) {
            this.doOKAction();
        }
    }

    public ProjectData getResult() {
        return this.myResult;
    }
}

