/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.settings;

import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.externalSystem.service.settings.AbstractSettingsControl;
import com.intellij.openapi.externalSystem.service.settings.ExternalSystemSettingsControlCustomizer;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemSettingsControl;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalProjectSettingsControl<S extends ExternalProjectSettings>
extends AbstractSettingsControl
implements ExternalSystemSettingsControl<S> {
    @NotNull
    private final S myInitialSettings;

    protected AbstractExternalProjectSettingsControl(@NotNull S initialSettings) {
        this(null, initialSettings);
    }

    protected AbstractExternalProjectSettingsControl(@Nullable Project project, @NotNull S initialSettings) {
        super(project);
        this.myInitialSettings = initialSettings;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    protected AbstractExternalProjectSettingsControl(@Nullable Project project, @NotNull S initialSettings, @Nullable ExternalSystemSettingsControlCustomizer controlCustomizer) {
        this(project, initialSettings);
    }

    @NotNull
    public S getInitialSettings() {
        return this.myInitialSettings;
    }

    @Override
    public void fillUi(@NotNull PaintAwarePanel canvas, int indentLevel) {
        this.fillExtraControls(canvas, indentLevel);
    }

    protected abstract void fillExtraControls(@NotNull PaintAwarePanel var1, int var2);

    @Override
    public boolean isModified() {
        return this.isExtraSettingModified();
    }

    protected abstract boolean isExtraSettingModified();

    @Override
    public void reset() {
        this.reset(false, null);
    }

    @Override
    public void reset(@Nullable Project project) {
        this.reset(false, project);
    }

    @Override
    public void reset(@Nullable WizardContext wizardContext) {
        this.reset(false, wizardContext, null);
    }

    public void reset(boolean isDefaultModuleCreation, @Nullable Project project) {
        this.reset(isDefaultModuleCreation, null, project);
    }

    public void reset(boolean isDefaultModuleCreation, @Nullable WizardContext wizardContext, @Nullable Project project) {
        super.reset(wizardContext, project);
        this.resetExtraSettings(isDefaultModuleCreation, wizardContext);
    }

    protected abstract void resetExtraSettings(boolean var1);

    protected void resetExtraSettings(boolean isDefaultModuleCreation, @Nullable WizardContext wizardContext) {
        this.resetExtraSettings(isDefaultModuleCreation);
    }

    @Override
    public void apply(@NotNull S settings) {
        settings.setModules(this.myInitialSettings.getModules());
        if (this.myInitialSettings.getExternalProjectPath() != null) {
            settings.setExternalProjectPath(this.myInitialSettings.getExternalProjectPath());
        }
        this.applyExtraSettings(settings);
    }

    protected abstract void applyExtraSettings(@NotNull S var1);

    @Override
    public void disposeUIResources() {
        ExternalSystemUiUtil.disposeUi(this);
    }

    @Override
    public void showUi(boolean show2) {
        ExternalSystemUiUtil.showUi(this, show2);
    }

    public void updateInitialSettings() {
        this.updateInitialExtraSettings();
    }

    protected void updateInitialExtraSettings() {
    }

    public void setCurrentProject(@Nullable Project project) {
        this.setProject(project);
    }

    @Override
    @Nullable
    public Project getProject() {
        return super.getProject();
    }
}

