/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote.wrapper;

import com.intellij.openapi.externalSystem.importing.ProjectResolverPolicy;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProjectResolver;
import com.intellij.openapi.externalSystem.service.remote.wrapper.AbstractRemoteExternalSystemServiceWrapper;
import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemProjectResolverWrapper<S extends ExternalSystemExecutionSettings>
extends AbstractRemoteExternalSystemServiceWrapper<S, RemoteExternalSystemProjectResolver<S>>
implements RemoteExternalSystemProjectResolver<S> {
    @NotNull
    private final RemoteExternalSystemProgressNotificationManager myProgressManager;

    public ExternalSystemProjectResolverWrapper(@NotNull RemoteExternalSystemProjectResolver<S> delegate, @NotNull RemoteExternalSystemProgressNotificationManager progressManager) {
        super(delegate);
        this.myProgressManager = progressManager;
    }

    @Override
    @Nullable
    public DataNode<ProjectData> resolveProjectInfo(@NotNull ExternalSystemTaskId id2, @NotNull String projectPath, boolean isPreviewMode, @Nullable S settings, @Nullable ProjectResolverPolicy resolverPolicy) throws ExternalSystemException, IllegalArgumentException, IllegalStateException, RemoteException {
        try {
            return ((RemoteExternalSystemProjectResolver)this.getDelegate()).resolveProjectInfo(id2, projectPath, isPreviewMode, settings, resolverPolicy);
        }
        catch (ExternalSystemException e) {
            this.myProgressManager.onFailure(id2, (Exception)((Object)e));
            throw e;
        }
        catch (Exception e) {
            this.myProgressManager.onFailure(id2, e);
            throw new ExternalSystemException((Throwable)e);
        }
    }

    @Override
    public boolean cancelTask(@NotNull ExternalSystemTaskId id2) throws ExternalSystemException, IllegalArgumentException, IllegalStateException, RemoteException {
        this.myProgressManager.beforeCancel(id2);
        try {
            boolean bl = ((RemoteExternalSystemProjectResolver)this.getDelegate()).cancelTask(id2);
            return bl;
        }
        finally {
            this.myProgressManager.onCancel(id2);
        }
    }
}

