/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.remote;

import com.intellij.openapi.externalSystem.model.settings.ExternalSystemExecutionSettings;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractRemoteExternalSystemService<S extends ExternalSystemExecutionSettings>
implements RemoteExternalSystemService<S> {
    private final ConcurrentMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>> myTasksInProgress = new ConcurrentHashMap<ExternalSystemTaskType, Set<ExternalSystemTaskId>>();
    private final AtomicReference<S> mySettings = new AtomicReference();
    private final AtomicReference<ExternalSystemTaskNotificationListener> myListener = new AtomicReference();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T execute(@NotNull ExternalSystemTaskId id2, @NotNull Supplier<? extends T> task2) {
        Set tasks = (Set)this.myTasksInProgress.get(id2.getType());
        if (tasks == null) {
            this.myTasksInProgress.putIfAbsent(id2.getType(), new HashSet());
            tasks = (Set)this.myTasksInProgress.get(id2.getType());
        }
        tasks.add(id2);
        try {
            T t = task2.get();
            return t;
        }
        finally {
            tasks.remove(id2);
        }
    }

    @Override
    public void setSettings(@NotNull S settings) {
        this.mySettings.set(settings);
    }

    @Nullable
    public S getSettings() {
        return (S)((ExternalSystemExecutionSettings)this.mySettings.get());
    }

    @Override
    public void setNotificationListener(@NotNull ExternalSystemTaskNotificationListener listener2) {
        this.myListener.set(listener2);
    }

    @NotNull
    public ExternalSystemTaskNotificationListener getNotificationListener() {
        return this.myListener.get();
    }

    @Override
    public boolean isTaskInProgress(@NotNull ExternalSystemTaskId id2) {
        Set tasks = (Set)this.myTasksInProgress.get(id2.getType());
        return tasks != null && tasks.contains(id2);
    }

    @Override
    @NotNull
    public Map<ExternalSystemTaskType, Set<ExternalSystemTaskId>> getTasksInProgress() {
        return this.myTasksInProgress;
    }
}

