/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483618)
public class ModuleDependencyDataService
extends AbstractDependencyDataService<ModuleDependencyData, ModuleOrderEntry> {
    private static final Logger LOG = Logger.getInstance(ModuleDependencyDataService.class);

    @NotNull
    public Key<ModuleDependencyData> getTargetDataKey() {
        return ProjectKeys.MODULE_DEPENDENCY;
    }

    @Override
    @NotNull
    public Class<ModuleOrderEntry> getOrderEntryType() {
        return ModuleOrderEntry.class;
    }

    @Override
    protected String getOrderEntryName(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleOrderEntry orderEntry) {
        String moduleName = orderEntry.getModuleName();
        Module orderEntryModule = orderEntry.getModule();
        if (orderEntryModule != null) {
            moduleName = modelsProvider.getModifiableModuleModel().getActualName(orderEntryModule);
        }
        return moduleName;
    }

    @Override
    protected Map<OrderEntry, OrderAware> importData(@NotNull Collection<DataNode<ModuleDependencyData>> toImport, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        HashMap<Pair, ModuleOrderEntry> toRemove2 = new HashMap<Pair, ModuleOrderEntry>();
        LinkedHashMap<OrderEntry, OrderAware> orderEntryDataMap = new LinkedHashMap<OrderEntry, OrderAware>();
        for (OrderEntry entry : modelsProvider.getOrderEntries(module)) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry e = (ModuleOrderEntry)entry;
            toRemove2.put(Pair.create((Object)e.getModuleName(), (Object)e.getScope()), e);
        }
        HashSet<ModuleDependencyData> processed2 = new HashSet<ModuleDependencyData>();
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        for (DataNode<ModuleDependencyData> dependencyNode : toImport) {
            ModuleOrderEntry orderEntry;
            ModuleDependencyData dependencyData = (ModuleDependencyData)dependencyNode.getData();
            if (processed2.contains(dependencyData)) continue;
            processed2.add(dependencyData);
            toRemove2.remove(Pair.create((Object)dependencyData.getInternalName(), (Object)dependencyData.getScope()));
            ModuleData moduleData = (ModuleData)dependencyData.getTarget();
            Module ideDependencyModule = modelsProvider.findIdeModule(moduleData);
            if (module.equals(ideDependencyModule)) continue;
            if (ideDependencyModule == null) {
                LOG.warn(String.format("Can't import module dependency for '%s' module. Reason: target module (%s) is not found at the ide", module.getName(), dependencyData));
            }
            if ((orderEntry = modelsProvider.findIdeModuleDependency(dependencyData, module)) == null) {
                orderEntry = (ModuleOrderEntry)ReadAction.compute(() -> ideDependencyModule == null ? modifiableRootModel.addInvalidModuleEntry(moduleData.getInternalName()) : modifiableRootModel.addModuleOrderEntry(ideDependencyModule));
            }
            orderEntry.setScope(dependencyData.getScope());
            orderEntry.setExported(dependencyData.isExported());
            orderEntry.setProductionOnTestDependency(dependencyData.isProductionOnTestDependency());
            orderEntryDataMap.put((OrderEntry)orderEntry, (OrderAware)dependencyData);
        }
        if (!toRemove2.isEmpty()) {
            this.removeData(toRemove2.values(), module, modelsProvider);
        }
        return orderEntryDataMap;
    }

    @Override
    protected void removeData(@NotNull Collection<? extends ExportableOrderEntry> toRemove2, @NotNull Module module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        List filteredList = ContainerUtil.filter(toRemove2, o -> {
            if (o instanceof ModuleOrderEntry) {
                String moduleName = ((ModuleOrderEntry)o).getModuleName();
                return ModuleManager.getInstance((Project)module.getProject()).getUnloadedModuleDescription(moduleName) == null;
            }
            return true;
        });
        super.removeData(filteredList, module, modelsProvider);
    }
}

