/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483638)
public class ModuleDataService
extends AbstractModuleDataService<ModuleData> {
    @NotNull
    public Key<ModuleData> getTargetDataKey() {
        return ProjectKeys.MODULE;
    }

    @NotNull
    public Computable<Collection<Module>> computeOrphanData(@NotNull Collection<DataNode<ModuleData>> toImport, @NotNull ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        return () -> {
            SmartList orphanIdeModules = new SmartList();
            for (Module module : modelsProvider.getModules()) {
                if (!ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectData2.getOwner(), (Module)module) || ExternalSystemApiUtil.getExternalModuleType((Module)module) != null) continue;
                String rootProjectPath = ExternalSystemApiUtil.getExternalRootProjectPath((Module)module);
                if (!projectData2.getLinkedExternalProjectPath().equals(rootProjectPath) || module.getUserData(AbstractModuleDataService.MODULE_DATA_KEY) != null) continue;
                orphanIdeModules.add(module);
            }
            return orphanIdeModules;
        };
    }

    @Override
    public void postProcess(@NotNull Collection<DataNode<ModuleData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        super.postProcess(toImport, projectData2, project, modelsProvider);
        ModuleDataService.updateLocalSettings(toImport, project);
    }

    private static void updateLocalSettings(Collection<DataNode<ModuleData>> toImport, Project project) {
        if (toImport.isEmpty()) {
            return;
        }
        ProjectSystemId externalSystemId = ((ModuleData)toImport.iterator().next().getData()).getOwner();
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        assert (manager != null);
        MultiMap grouped = ExternalSystemApiUtil.groupBy(toImport, (Key)ProjectKeys.PROJECT);
        HashMap<ExternalProjectPojo, Collection<ExternalProjectPojo>> data2 = new HashMap<ExternalProjectPojo, Collection<ExternalProjectPojo>>();
        for (Map.Entry entry : grouped.entrySet()) {
            data2.put(ExternalProjectPojo.from((Named)((Named)((DataNode)entry.getKey()).getData())), ContainerUtil.map2List((Collection)((Collection)entry.getValue()), node -> ExternalProjectPojo.from((Named)((Named)node.getData()))));
        }
        AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)project);
        Set<String> pathsToForget = ModuleDataService.detectRenamedProjects(data2, settings.getAvailableProjects());
        if (!pathsToForget.isEmpty()) {
            settings.forgetExternalProjects(pathsToForget);
        }
        HashMap<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects = new HashMap<ExternalProjectPojo, Collection<ExternalProjectPojo>>(settings.getAvailableProjects());
        projects.putAll(data2);
        settings.setAvailableProjects(projects);
    }

    @NotNull
    private static Set<String> detectRenamedProjects(@NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> currentInfo, @NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> oldInfo) {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : currentInfo.entrySet()) {
            map2.put(entry.getKey().getPath(), entry.getKey().getName());
            for (ExternalProjectPojo pojo : entry.getValue()) {
                map2.put(pojo.getPath(), pojo.getName());
            }
        }
        HashSet<String> result2 = new HashSet<String>();
        for (Map.Entry<ExternalProjectPojo, Collection<ExternalProjectPojo>> entry : oldInfo.entrySet()) {
            String newName = (String)map2.get(entry.getKey().getPath());
            if (newName != null && !newName.equals(entry.getKey().getName())) {
                result2.add(entry.getKey().getPath());
            }
            for (ExternalProjectPojo pojo : entry.getValue()) {
                newName = (String)map2.get(pojo.getPath());
                if (newName == null || newName.equals(pojo.getName())) continue;
                result2.add(pojo.getPath());
            }
        }
        return result2;
    }
}

