/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.importing.ImportSpec;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcher;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemProjectsWatcherImpl;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsState;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemKeymapExtension;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemRunManagerListener;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemShortcutsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalSystemTaskActivator;
import com.intellij.openapi.externalSystem.service.project.manage.TaskActivationState;
import com.intellij.openapi.externalSystem.util.CompositeRunnable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.ExternalStorageConfigurationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="ExternalProjectsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ExternalProjectsManagerImpl
implements ExternalProjectsManager,
PersistentStateComponent<ExternalProjectsState>,
Disposable {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsManager.class);
    private final AtomicBoolean isInitializationFinished = new AtomicBoolean();
    private final AtomicBoolean isInitializationStarted = new AtomicBoolean();
    private final AtomicBoolean isDisposed = new AtomicBoolean();
    private final CompositeRunnable myPostInitializationActivities = new CompositeRunnable();
    @NotNull
    private ExternalProjectsState myState = new ExternalProjectsState();
    @NotNull
    private final Project myProject;
    private final ExternalSystemRunManagerListener myRunManagerListener;
    private final ExternalSystemTaskActivator myTaskActivator;
    private final ExternalSystemShortcutsManager myShortcutsManager;
    private final List<ExternalProjectsView> myProjectsViews = new SmartList();
    private final ExternalSystemProjectsWatcherImpl myWatcher;

    public ExternalProjectsManagerImpl(@NotNull Project project) {
        this.myProject = project;
        this.myShortcutsManager = new ExternalSystemShortcutsManager(project);
        Disposer.register((Disposable)this, (Disposable)this.myShortcutsManager);
        this.myTaskActivator = new ExternalSystemTaskActivator(project);
        this.myRunManagerListener = new ExternalSystemRunManagerListener(this);
        this.myWatcher = new ExternalSystemProjectsWatcherImpl(this.myProject);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Set availableES = ExternalSystemManager.EP_NAME.getExtensionList().stream().map(ExternalSystemManager::getSystemId).collect(Collectors.toSet());
                Iterator iterator2 = ExternalProjectsManagerImpl.this.myProjectsViews.iterator();
                while (iterator2.hasNext()) {
                    ExternalProjectsView view = (ExternalProjectsView)iterator2.next();
                    if (!availableES.contains(view.getSystemId())) {
                        iterator2.remove();
                    }
                    if (!(view instanceof Disposable)) continue;
                    Disposer.dispose((Disposable)((Disposable)view));
                }
            }
        });
    }

    public static ExternalProjectsManagerImpl getInstance(@NotNull Project project) {
        return (ExternalProjectsManagerImpl)project.getService(ExternalProjectsManager.class);
    }

    @Nullable
    public static Project setupCreatedProject(@Nullable Project project) {
        if (project != null) {
            ExternalProjectsManagerImpl.getInstance(project).setStoreExternally(true);
        }
        return project;
    }

    public void setStoreExternally(boolean value2) {
        ExternalStorageConfigurationManager externalStorageConfigurationManager = ExternalStorageConfigurationManager.getInstance((Project)this.myProject);
        if (externalStorageConfigurationManager.isEnabled() == value2) {
            return;
        }
        externalStorageConfigurationManager.setEnabled(value2);
        try {
            for (Module module : ModuleManager.getInstance((Project)this.myProject).getModules()) {
                if (module.isDisposed()) continue;
                ExternalSystemModulePropertyManager.getInstance((Module)module).swapStore();
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                if (!(moduleRootManager instanceof ModuleRootManagerImpl)) continue;
                ((ModuleRootManagerImpl)moduleRootManager).stateChanged();
            }
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
        }
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    public ExternalSystemShortcutsManager getShortcutsManager() {
        return this.myShortcutsManager;
    }

    public ExternalSystemTaskActivator getTaskActivator() {
        return this.myTaskActivator;
    }

    public ExternalSystemProjectsWatcher getExternalProjectsWatcher() {
        return this.myWatcher;
    }

    public void registerView(@NotNull ExternalProjectsView externalProjectsView) {
        assert (this.getExternalProjectsView(externalProjectsView.getSystemId()) == null);
        this.myProjectsViews.add(externalProjectsView);
        if (externalProjectsView instanceof ExternalProjectsViewImpl) {
            ExternalProjectsViewImpl view = (ExternalProjectsViewImpl)externalProjectsView;
            view.loadState(this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId()).getProjectsViewState());
            view.init();
        }
    }

    @Nullable
    public ExternalProjectsView getExternalProjectsView(@NotNull ProjectSystemId systemId) {
        for (ExternalProjectsView projectsView : this.myProjectsViews) {
            if (!projectsView.getSystemId().equals((Object)systemId)) continue;
            return projectsView;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        ProgressManager.checkCanceled();
        if (this.isInitializationStarted.getAndSet(true)) {
            return;
        }
        ExternalProjectsDataStorage.getInstance(this.myProject).load();
        this.myRunManagerListener.attach();
        this.myShortcutsManager.init();
        for (ExternalSystemManager systemManager : ExternalSystemManager.EP_NAME.getIterable()) {
            Collection<ExternalProjectInfo> externalProjects = ExternalProjectsDataStorage.getInstance(this.myProject).list(systemManager.getSystemId());
            for (ExternalProjectInfo externalProject : externalProjects) {
                if (externalProject.getExternalProjectStructure() == null) continue;
                Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
                this.myShortcutsManager.scheduleKeymapUpdate(taskData);
            }
            if (externalProjects.isEmpty()) continue;
            this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(systemManager.getSystemId());
        }
        this.myTaskActivator.init();
        AtomicBoolean atomicBoolean = this.isInitializationFinished;
        synchronized (atomicBoolean) {
            this.isInitializationFinished.set(true);
            this.invokeLater(() -> {
                this.myPostInitializationActivities.run();
                this.myPostInitializationActivities.clear();
            });
        }
    }

    public void refreshProject(@NotNull String externalProjectPath, @NotNull ImportSpec importSpec) {
        ExternalSystemUtil.refreshProject(externalProjectPath, importSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWhenInitialized(@NotNull Runnable runnable2) {
        if (this.isDisposed.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = this.isInitializationFinished;
        synchronized (atomicBoolean) {
            if (this.isInitializationFinished.get()) {
                this.invokeLater(runnable2);
            } else {
                this.myPostInitializationActivities.add(runnable2);
            }
        }
    }

    private void invokeLater(@NotNull Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(runnable2, o -> this.myProject.isDisposed() || this.isDisposed.get());
    }

    public void updateExternalProjectData(ExternalProjectInfo externalProject) {
        ExternalProjectsDataStorage.getInstance(this.myProject).update(externalProject);
        if (externalProject.getExternalProjectStructure() != null) {
            ProjectData projectData2 = (ProjectData)externalProject.getExternalProjectStructure().getData();
            ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectData2.getOwner());
            Collection taskData = ExternalSystemApiUtil.findAllRecursively((DataNode)externalProject.getExternalProjectStructure(), (Key)ProjectKeys.TASK);
            this.myShortcutsManager.scheduleKeymapUpdate(taskData);
            this.myShortcutsManager.scheduleRunConfigurationKeymapUpdate(projectData2.getOwner());
        }
    }

    public void forgetExternalProjectData(@NotNull ProjectSystemId projectSystemId, @NotNull String linkedProjectPath) {
        ExternalProjectsDataStorage.getInstance(this.myProject).remove(projectSystemId, linkedProjectPath);
        ExternalSystemUtil.scheduleExternalViewStructureUpdate(this.myProject, projectSystemId);
    }

    @NotNull
    public ExternalProjectsState getState() {
        ApplicationManager.getApplication().assertIsWriteThread();
        for (ExternalProjectsView externalProjectsView : this.myProjectsViews) {
            if (!(externalProjectsView instanceof ExternalProjectsViewImpl)) continue;
            ExternalProjectsViewState externalProjectsViewState = ((ExternalProjectsViewImpl)externalProjectsView).getState();
            ExternalProjectsState.State state = this.myState.getExternalSystemsState().get(externalProjectsView.getSystemId().getId());
            assert (state != null);
            state.setProjectsViewState(externalProjectsViewState);
        }
        return this.myState;
    }

    @NotNull
    public ExternalProjectsStateProvider getStateProvider() {
        return new ExternalProjectsStateProvider(){

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getAllTasksActivation() {
                SmartList result2 = new SmartList();
                Map<String, ProjectSystemId> systemIds = ExternalSystemApiUtil.getAllManagers().stream().collect(Collectors.toMap(o -> o.getSystemId().getId(), o -> o.getSystemId()));
                for (Map.Entry<String, ExternalProjectsState.State> systemState : ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().entrySet()) {
                    ProjectSystemId systemId = systemIds.get(systemState.getKey());
                    if (systemId == null) continue;
                    for (Map.Entry<String, TaskActivationState> activationStateEntry : systemState.getValue().getExternalSystemsTaskActivation().entrySet()) {
                        result2.add(new ExternalProjectsStateProvider.TasksActivation(systemId, activationStateEntry.getKey(), activationStateEntry.getValue()));
                    }
                }
                return result2;
            }

            @Override
            public List<ExternalProjectsStateProvider.TasksActivation> getTasksActivation(@NotNull ProjectSystemId systemId) {
                Set<Map.Entry<String, TaskActivationState>> entries = ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation().entrySet();
                return ContainerUtil.map(entries, entry -> new ExternalProjectsStateProvider.TasksActivation(systemId, (String)entry.getKey(), (TaskActivationState)entry.getValue()));
            }

            @Override
            public TaskActivationState getTasksActivation(@NotNull ProjectSystemId systemId, @NotNull String projectPath) {
                return ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation().get(projectPath);
            }

            @Override
            public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId systemId) {
                return ExternalProjectsManagerImpl.this.myState.getExternalSystemsState().get(systemId.getId()).getExternalSystemsTaskActivation();
            }
        };
    }

    public boolean isIgnored(@NotNull ProjectSystemId systemId, @NotNull String projectPath) {
        ExternalProjectInfo projectInfo = ExternalSystemUtil.getExternalProjectInfo(this.myProject, systemId, projectPath);
        if (projectInfo == null) {
            return true;
        }
        return ExternalProjectsDataStorage.getInstance(this.myProject).isIgnored(projectInfo.getExternalProjectPath(), projectPath, ProjectKeys.MODULE);
    }

    public void setIgnored(@NotNull DataNode<?> dataNode, boolean isIgnored) {
        ExternalProjectsDataStorage.getInstance(this.myProject).setIgnored(dataNode, isIgnored);
        ExternalSystemKeymapExtension.updateActions(this.myProject, ExternalSystemApiUtil.findAllRecursively(dataNode, (Key)ProjectKeys.TASK));
    }

    public void loadState(@NotNull ExternalProjectsState state) {
        this.myState = state;
        if (this.myState.storeExternally) {
            this.myState.storeExternally = false;
            ExternalStorageConfigurationManager.getInstance((Project)this.myProject).setEnabled(true);
        }
    }

    public void dispose() {
        if (this.isDisposed.getAndSet(true)) {
            return;
        }
        this.myPostInitializationActivities.clear();
        this.myProjectsViews.clear();
        this.myRunManagerListener.detach();
    }

    public static interface ExternalProjectsStateProvider {
        public List<TasksActivation> getAllTasksActivation();

        public List<TasksActivation> getTasksActivation(@NotNull ProjectSystemId var1);

        public TaskActivationState getTasksActivation(@NotNull ProjectSystemId var1, @NotNull String var2);

        public Map<String, TaskActivationState> getProjectsTasksActivationMap(@NotNull ProjectSystemId var1);

        public static class TasksActivation {
            public final ProjectSystemId systemId;
            public final String projectPath;
            public final TaskActivationState state;

            public TasksActivation(ProjectSystemId systemId, String projectPath, TaskActivationState state) {
                this.systemId = systemId;
                this.projectPath = projectPath;
                this.state = state;
            }
        }
    }
}

