/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.configurationStore.SettingsSavingComponentJavaAdapter;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManagerEx;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.SerializationKt;
import com.intellij.openapi.externalSystem.model.internal.InternalExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectDataManagerImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.serialization.ObjectSerializer;
import com.intellij.serialization.SerializationException;
import com.intellij.serialization.VersionedFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.PathKt;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.XCollection;
import com.intellij.util.xmlb.annotations.XMap;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ExternalProjectsData", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ExternalProjectsDataStorage
implements SettingsSavingComponentJavaAdapter,
PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance(ExternalProjectsDataStorage.class);
    public static final int STORAGE_VERSION = 6;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Map<Pair<ProjectSystemId, File>, InternalExternalProjectInfo> myExternalRootProjects = ConcurrentCollectionFactory.createMap(ExternalSystemUtil.HASHING_STRATEGY);
    private final AtomicBoolean changed = new AtomicBoolean();
    private State myState = new State();

    public static ExternalProjectsDataStorage getInstance(@NotNull Project project) {
        return (ExternalProjectsDataStorage)ServiceManager.getService((Project)project, ExternalProjectsDataStorage.class);
    }

    public ExternalProjectsDataStorage(@NotNull Project project) {
        this.myProject = project;
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)project).subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            @Override
            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                ObjectSerializer.getInstance().clearBindingCache();
            }

            @Override
            public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                Set existingEPs = ExternalSystemManager.EP_NAME.getExtensionList().stream().map(ExternalSystemManager::getSystemId).collect(Collectors.toSet());
                Iterator iter = ExternalProjectsDataStorage.this.myExternalRootProjects.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    if (existingEPs.contains(((Pair)entry.getKey()).first)) continue;
                    iter.remove();
                    ExternalProjectsDataStorage.this.markDirty(((InternalExternalProjectInfo)entry.getValue()).getExternalProjectPath());
                }
            }
        });
    }

    public synchronized void load() {
        long startTs;
        long readEnd = startTs = System.currentTimeMillis();
        try {
            List<InternalExternalProjectInfo> projectInfos = ExternalProjectsDataStorage.load(this.myProject);
            readEnd = System.currentTimeMillis();
            if (projectInfos == null || projectInfos.isEmpty() && this.myProject.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) != Boolean.TRUE && this.hasLinkedExternalProjects()) {
                this.markDirtyAllExternalProjects();
            }
            for (InternalExternalProjectInfo projectInfo : ContainerUtil.notNullize(projectInfos)) {
                Pair key = Pair.create((Object)projectInfo.getProjectSystemId(), (Object)new File(projectInfo.getExternalProjectPath()));
                InternalExternalProjectInfo projectInfoReceivedBeforeStorageInitialization = this.myExternalRootProjects.get(key);
                if (projectInfoReceivedBeforeStorageInitialization != null && projectInfoReceivedBeforeStorageInitialization.getLastSuccessfulImportTimestamp() > 0L) continue;
                if (ExternalProjectsDataStorage.validate(projectInfo)) {
                    this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key, projectInfo);
                    if (projectInfo.getLastImportTimestamp() == projectInfo.getLastSuccessfulImportTimestamp()) continue;
                    this.markDirty(projectInfo.getExternalProjectPath());
                    continue;
                }
                String projectPath = projectInfo.getNullSafeExternalProjectPath();
                if (projectPath == null) continue;
                this.markDirty(projectPath);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            this.markDirtyAllExternalProjects();
            LOG.warn("Failed to deserialize data nodes.", e);
        }
        this.mergeLocalSettings();
        long finishTs = System.currentTimeMillis();
        LOG.info("Load external projects data in " + (finishTs - startTs) + " millis (read time: " + (readEnd - startTs) + ")");
    }

    private boolean hasLinkedExternalProjects() {
        for (ExternalSystemManager manager : ExternalSystemManager.EP_NAME.getIterable()) {
            if (((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectsSettings().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void markDirtyAllExternalProjects() {
        ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirtyAllExternalProjects();
    }

    private void markDirty(String projectPath) {
        ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirty(projectPath);
    }

    private static boolean validate(InternalExternalProjectInfo externalProjectInfo) {
        DataNode<ProjectData> projectStructure = externalProjectInfo.getExternalProjectStructure();
        if (projectStructure == null) {
            return false;
        }
        ProjectDataManagerImpl.getInstance().ensureTheDataIsReadyToUse(projectStructure);
        return externalProjectInfo.getExternalProjectPath().equals(((ProjectData)projectStructure.getData()).getLinkedExternalProjectPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doSave() {
        if (!this.changed.compareAndSet(true, false)) {
            return;
        }
        try {
            ExternalProjectsDataStorage externalProjectsDataStorage = this;
            synchronized (externalProjectsDataStorage) {
                long start2 = System.currentTimeMillis();
                ExternalProjectsDataStorage.doSave(this.myProject, this.myExternalRootProjects.values());
                long duration = System.currentTimeMillis() - start2;
                LOG.info("Save external projects data in " + duration + " ms");
            }
        }
        catch (SerializationException | IOException e) {
            LOG.error(e);
        }
    }

    synchronized void update(@NotNull ExternalProjectInfo externalProjectInfo) {
        this.restoreInclusionSettings((DataNode<ProjectData>)externalProjectInfo.getExternalProjectStructure());
        ProjectSystemId projectSystemId = externalProjectInfo.getProjectSystemId();
        String projectPath = externalProjectInfo.getExternalProjectPath();
        DataNode externalProjectStructure = externalProjectInfo.getExternalProjectStructure();
        long lastSuccessfulImportTimestamp = externalProjectInfo.getLastSuccessfulImportTimestamp();
        long lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
        Pair key = Pair.create((Object)projectSystemId, (Object)new File(projectPath));
        InternalExternalProjectInfo old = this.myExternalRootProjects.get(key);
        if (old != null) {
            lastImportTimestamp = externalProjectInfo.getLastImportTimestamp();
            if (lastSuccessfulImportTimestamp == -1L) {
                lastSuccessfulImportTimestamp = old.getLastSuccessfulImportTimestamp();
            }
            externalProjectStructure = externalProjectInfo.getExternalProjectStructure() == null ? old.getExternalProjectStructure() : externalProjectInfo.getExternalProjectStructure().graphCopy();
        } else {
            externalProjectStructure = externalProjectStructure != null ? externalProjectStructure.graphCopy() : null;
        }
        InternalExternalProjectInfo merged = new InternalExternalProjectInfo(projectSystemId, projectPath, (DataNode<ProjectData>)externalProjectStructure);
        merged.setLastImportTimestamp(lastImportTimestamp);
        merged.setLastSuccessfulImportTimestamp(lastSuccessfulImportTimestamp);
        this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key, merged);
        this.markAsChangedAndScheduleSave();
    }

    synchronized void restoreInclusionSettings(@Nullable DataNode<ProjectData> projectDataNode) {
        if (projectDataNode == null) {
            return;
        }
        String rootProjectPath = ((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath();
        ProjectState projectState = this.myState.map.get(rootProjectPath);
        if (projectState == null) {
            return;
        }
        projectDataNode.visit(node -> {
            DataNode<ExternalConfigPathAware> projectOrModuleNode = ExternalProjectsDataStorage.resolveProjectNode(node);
            assert (projectOrModuleNode != null);
            ModuleState moduleState = projectState.map.get(((ExternalConfigPathAware)projectOrModuleNode.getData()).getLinkedExternalProjectPath());
            node.setIgnored(ExternalProjectsDataStorage.isIgnored(projectState, moduleState, node.getKey()));
        });
    }

    synchronized void saveInclusionSettings(@Nullable DataNode<ProjectData> projectDataNode) {
        MultiMap map2;
        if (projectDataNode == null) {
            return;
        }
        MultiMap inclusionMap = new MultiMap();
        MultiMap exclusionMap = new MultiMap();
        projectDataNode.visit(dataNode -> {
            DataNode<ExternalConfigPathAware> projectNode = ExternalProjectsDataStorage.resolveProjectNode(dataNode);
            if (projectNode != null) {
                String projectPath = ((ExternalConfigPathAware)projectNode.getData()).getLinkedExternalProjectPath();
                if (projectNode.isIgnored() || dataNode.isIgnored()) {
                    exclusionMap.putValue((Object)projectPath, (Object)dataNode.getKey().getDataType());
                } else {
                    inclusionMap.putValue((Object)projectPath, (Object)dataNode.getKey().getDataType());
                }
            }
        });
        ProjectState projectState = new ProjectState();
        if (inclusionMap.size() < exclusionMap.size()) {
            projectState.isInclusion = true;
            map2 = inclusionMap;
        } else {
            projectState.isInclusion = false;
            map2 = exclusionMap;
        }
        for (String path : map2.keySet()) {
            projectState.map.put(path, new ModuleState(map2.get((Object)path)));
        }
        this.myState.map.put(((ProjectData)projectDataNode.getData()).getLinkedExternalProjectPath(), projectState);
        this.markAsChangedAndScheduleSave();
    }

    private void markAsChangedAndScheduleSave() {
        if (this.changed.compareAndSet(false, true)) {
            SaveAndSyncHandler.getInstance().scheduleSave(SaveAndSyncHandler.SaveTask.projectIncludingAllSettings((Project)this.myProject), false);
        }
    }

    @Nullable
    synchronized ExternalProjectInfo get(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        return this.myExternalRootProjects.get(Pair.create((Object)projectSystemId, (Object)new File(externalProjectPath)));
    }

    synchronized void remove(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath) {
        InternalExternalProjectInfo removed = this.myExternalRootProjects.remove(Pair.create((Object)projectSystemId, (Object)new File(externalProjectPath)));
        if (removed != null) {
            this.markAsChangedAndScheduleSave();
        }
    }

    @NotNull
    synchronized Collection<ExternalProjectInfo> list(@NotNull ProjectSystemId projectSystemId) {
        return ContainerUtil.mapNotNull(this.myExternalRootProjects.values(), info -> projectSystemId.equals((Object)info.getProjectSystemId()) ? info : null);
    }

    private void mergeLocalSettings() {
        for (ExternalSystemManager manager : ExternalSystemManager.EP_NAME.getIterable()) {
            ProjectSystemId systemId = manager.getSystemId();
            AbstractExternalSystemLocalSettings settings = (AbstractExternalSystemLocalSettings)manager.getLocalSettingsProvider().fun((Object)this.myProject);
            Map availableProjects = settings.getAvailableProjects();
            for (Map.Entry entry : availableProjects.entrySet()) {
                ExternalProjectSettings linkedProjectSettings;
                ExternalProjectPojo projectPojo = (ExternalProjectPojo)entry.getKey();
                String externalProjectPath = projectPojo.getPath();
                Pair key = Pair.create((Object)systemId, (Object)new File(externalProjectPath));
                InternalExternalProjectInfo externalProjectInfo = this.myExternalRootProjects.get(key);
                if (externalProjectInfo == null) {
                    DataNode<ProjectData> dataNode = ExternalProjectsDataStorage.convert(systemId, projectPojo, (Collection)entry.getValue());
                    externalProjectInfo = new InternalExternalProjectInfo(systemId, externalProjectPath, dataNode);
                    this.myExternalRootProjects.put((Pair<ProjectSystemId, File>)key, externalProjectInfo);
                    ExternalProjectsManager.getInstance((Project)this.myProject).getExternalProjectsWatcher().markDirty(externalProjectPath);
                    this.markAsChangedAndScheduleSave();
                }
                if ((linkedProjectSettings = ((AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject)).getLinkedProjectSettings(externalProjectPath)) == null || !ContainerUtil.isEmpty((Collection)linkedProjectSettings.getModules())) continue;
                Set modulePaths = ContainerUtil.map2Set((Collection)ExternalSystemApiUtil.findAllRecursively(externalProjectInfo.getExternalProjectStructure(), (Key)ProjectKeys.MODULE), node -> ((ModuleData)node.getData()).getLinkedExternalProjectPath());
                linkedProjectSettings.setModules(modulePaths);
            }
        }
    }

    private static DataNode<ProjectData> convert(@NotNull ProjectSystemId systemId, @NotNull ExternalProjectPojo rootProject, @NotNull Collection<? extends ExternalProjectPojo> childProjects) {
        ProjectData projectData2 = new ProjectData(systemId, rootProject.getName(), rootProject.getPath(), rootProject.getPath());
        DataNode projectDataNode = new DataNode(ProjectKeys.PROJECT, (Object)projectData2, null);
        for (ExternalProjectPojo externalProjectPojo : childProjects) {
            String moduleConfigPath = externalProjectPojo.getPath();
            ModuleData moduleData = new ModuleData(externalProjectPojo.getName(), systemId, "JAVA_MODULE", externalProjectPojo.getName(), moduleConfigPath, moduleConfigPath);
            projectDataNode.createChild(ProjectKeys.MODULE, (Object)moduleData);
        }
        return projectDataNode;
    }

    private static void doSave(@NotNull Project project, @NotNull Collection<InternalExternalProjectInfo> externalProjects) throws IOException {
        Iterator<InternalExternalProjectInfo> iterator2 = externalProjects.iterator();
        while (iterator2.hasNext()) {
            InternalExternalProjectInfo externalProject = iterator2.next();
            if (ExternalProjectsDataStorage.validate(externalProject)) continue;
            iterator2.remove();
        }
        ExternalProjectsDataStorage.getCacheFile(project).writeList(externalProjects, InternalExternalProjectInfo.class, SerializationKt.createCacheWriteConfiguration());
    }

    @Nullable
    private static DataNode<ExternalConfigPathAware> resolveProjectNode(@NotNull DataNode node) {
        if ((ProjectKeys.MODULE.equals((Object)node.getKey()) || ProjectKeys.PROJECT.equals((Object)node.getKey())) && node.getData() instanceof ExternalConfigPathAware) {
            return node;
        }
        DataNode parent = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.MODULE);
        if (parent == null) {
            parent = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.PROJECT);
        }
        return parent;
    }

    @Nullable(value="null indicates that cache was invalid")
    private static @Nullable(value="null indicates that cache was invalid") List<InternalExternalProjectInfo> load(@NotNull Project project) throws IOException {
        VersionedFile cacheFile = ExternalProjectsDataStorage.getCacheFile(project);
        BasicFileAttributes fileAttributes = PathKt.basicAttributesIfExists((Path)cacheFile.getFile());
        if (fileAttributes == null || !fileAttributes.isRegularFile()) {
            return Collections.emptyList();
        }
        if (ExternalProjectsDataStorage.isInvalidated(cacheFile.getFile(), fileAttributes)) {
            LOG.debug("External projects data storage was invalidated");
            return null;
        }
        return cacheFile.readList(InternalExternalProjectInfo.class, SerializationKt.createCacheReadConfiguration((Logger)LOG));
    }

    private static boolean isInvalidated(@NotNull Path configurationFile, @NotNull BasicFileAttributes fileAttributes) throws IOException {
        if (!Registry.is((String)"external.system.invalidate.storage", (boolean)true)) {
            return false;
        }
        long lastModified = fileAttributes.lastModifiedTime().toMillis();
        if (lastModified == 0L) {
            return true;
        }
        File brokenMarkerFile = ExternalProjectsDataStorage.getBrokenMarkerFile();
        if (brokenMarkerFile.exists() && lastModified < brokenMarkerFile.lastModified()) {
            Files.delete(configurationFile);
            return true;
        }
        return false;
    }

    @NotNull
    private static VersionedFile getCacheFile(@NotNull Project project) {
        return new VersionedFile(ExternalProjectsDataStorage.getProjectConfigurationDir(project).resolve("project.dat"), 6);
    }

    @NotNull
    public static Path getProjectConfigurationDir(@NotNull Project project) {
        return ProjectUtil.getExternalConfigurationDir((Project)project);
    }

    @Nullable
    public synchronized State getState() {
        return this.myState;
    }

    public synchronized void loadState(@NotNull State state) {
        this.myState = state;
    }

    synchronized void setIgnored(@NotNull DataNode<?> dataNode, boolean isIgnored) {
        DataNode projectDataNode;
        DataNode dataNode2 = projectDataNode = ProjectKeys.PROJECT.equals((Object)dataNode.getKey()) ? dataNode : ExternalSystemApiUtil.findParent(dataNode, (Key)ProjectKeys.PROJECT);
        if (projectDataNode == null) {
            return;
        }
        dataNode.visit(node -> node.setIgnored(isIgnored));
        this.saveInclusionSettings((DataNode<ProjectData>)projectDataNode);
    }

    synchronized boolean isIgnored(@NotNull String rootProjectPath, @NotNull String modulePath, @NotNull Key key) {
        ProjectState projectState = this.myState.map.get(rootProjectPath);
        if (projectState == null) {
            return false;
        }
        ModuleState moduleState = projectState.map.get(modulePath);
        return ExternalProjectsDataStorage.isIgnored(projectState, moduleState, key);
    }

    private static boolean isIgnored(@NotNull ProjectState projectState, @Nullable ModuleState moduleState, @NotNull Key<?> key) {
        return projectState.isInclusion ^ (moduleState != null && moduleState.set.contains(key.getDataType()));
    }

    public static synchronized void invalidateCaches() {
        if (!Registry.is((String)"external.system.invalidate.storage", (boolean)true)) {
            return;
        }
        File markerFile2 = ExternalProjectsDataStorage.getBrokenMarkerFile();
        try {
            FileUtil.writeToFile((File)markerFile2, (String)String.valueOf(System.currentTimeMillis()));
        }
        catch (IOException e) {
            LOG.warn("Cannot update the invalidation marker file", (Throwable)e);
        }
    }

    @NotNull
    private static File getBrokenMarkerFile() {
        return PathManagerEx.getAppSystemDir().resolve("external_build_system").resolve(".broken").toFile();
    }

    static class ModuleState {
        @Property(surroundWithTag=false)
        @XCollection(elementName="id")
        public final Set<String> set;

        ModuleState() {
            this.set = new THashSet();
        }

        ModuleState(@NotNull Collection<String> values2) {
            this.set = new THashSet(values2);
        }
    }

    static class ProjectState {
        @Property(surroundWithTag=false)
        @XMap(keyAttributeName="path", entryTagName="dataType")
        public final Map<String, ModuleState> map = new THashMap();
        public boolean isInclusion;

        ProjectState() {
        }
    }

    static final class State {
        @Property(surroundWithTag=false)
        @MapAnnotation(surroundWithTag=false, surroundValueWithTag=false, surroundKeyWithTag=false, keyAttributeName="path", entryTagName="projectState")
        public final Map<String, ProjectState> map = new THashMap();

        State() {
        }
    }
}

