/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.projectView.ProjectView;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.AbstractNamedData;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractModuleDataService;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.SourceFolderManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

@Order(value=-2147483618)
public final class ContentRootDataService
extends AbstractProjectDataService<ContentRootData, ContentEntry> {
    public static final com.intellij.openapi.util.Key<Boolean> CREATE_EMPTY_DIRECTORIES = com.intellij.openapi.util.Key.create((String)"createEmptyDirectories");
    private static final Logger LOG = Logger.getInstance(ContentRootDataService.class);

    @NotNull
    public Key<ContentRootData> getTargetDataKey() {
        return ProjectKeys.CONTENT_ROOT;
    }

    public void importData(@NotNull Collection<DataNode<ContentRootData>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        ContentRootDataService.logUnitTest("Importing data. Data size is [" + toImport.size() + "]", new Object[0]);
        if (toImport.isEmpty()) {
            return;
        }
        SourceFolderManager sourceFolderManager = SourceFolderManager.getInstance((Project)project);
        boolean isNewlyImportedProject = project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) == Boolean.TRUE;
        boolean forceDirectoriesCreation = false;
        DataNode projectDataNode = ExternalSystemApiUtil.findParent(toImport.iterator().next(), (Key)ProjectKeys.PROJECT);
        if (projectDataNode != null) {
            forceDirectoriesCreation = projectDataNode.getUserData(CREATE_EMPTY_DIRECTORIES) == Boolean.TRUE;
        }
        ObjectOpenHashSet modulesToExpand = new ObjectOpenHashSet();
        MultiMap byModule = ExternalSystemApiUtil.groupBy(toImport, ModuleData.class);
        ContentRootDataService.filterAndReportDuplicatingContentRoots((MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>>)byModule, project);
        for (Map.Entry entry : byModule.entrySet()) {
            Module module = (Module)((DataNode)entry.getKey()).getUserData(AbstractModuleDataService.MODULE_KEY);
            Module module2 = module = module != null ? module : modelsProvider.findIdeModule((ModuleData)((DataNode)entry.getKey()).getData());
            if (module == null) {
                LOG.warn(String.format("Can't import content roots. Reason: target module (%s) is not found at the ide. Content roots: %s", entry.getKey(), entry.getValue()));
                continue;
            }
            ContentRootDataService.importData(modelsProvider, sourceFolderManager, (Collection)entry.getValue(), module, forceDirectoriesCreation);
            if (!forceDirectoriesCreation && (!isNewlyImportedProject || projectData2 == null || !projectData2.getLinkedExternalProjectPath().equals(ExternalSystemApiUtil.getExternalProjectPath((Module)module)))) continue;
            modulesToExpand.add(module);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && !modulesToExpand.isEmpty()) {
            for (Module module : modulesToExpand) {
                VirtualFile[] roots;
                String productionModuleName = modelsProvider.getProductionModuleName(module);
                if (productionModuleName != null && modulesToExpand.contains(modelsProvider.findIdeModule(productionModuleName)) || (roots = modelsProvider.getModifiableRootModel(module).getContentRoots()).length <= 0) continue;
                VirtualFile virtualFile = roots[0];
                StartupManager.getInstance((Project)project).runAfterOpened(() -> ApplicationManager.getApplication().invokeLater(() -> {
                    ProjectView projectView = ProjectView.getInstance(project);
                    projectView.changeViewCB("ProjectPane", null).doWhenProcessed(() -> projectView.selectCB(null, virtualFile, false));
                }, ModalityState.NON_MODAL, project.getDisposed()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void importData(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull SourceFolderManager sourceFolderManager, @NotNull Collection<? extends DataNode<ContentRootData>> data2, @NotNull Module module, boolean forceDirectoriesCreation) {
        void var10_12;
        ContentRootDataService.logUnitTest("Import data for module [" + module.getName() + "], data size [" + data2.size() + "]", new Object[0]);
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
        ContentEntry[] contentEntries = modifiableRootModel.getContentEntries();
        HashMap<String, ContentEntry> contentEntriesMap = new HashMap<String, ContentEntry>();
        ContentEntry[] contentEntryArray = contentEntries;
        int n = contentEntryArray.length;
        boolean bl = false;
        while (var10_12 < n) {
            ContentEntry contentEntry = contentEntryArray[var10_12];
            contentEntriesMap.put(contentEntry.getUrl(), contentEntry);
            ++var10_12;
        }
        sourceFolderManager.removeSourceFolders(module);
        ReferenceOpenHashSet importedContentEntries = new ReferenceOpenHashSet();
        for (DataNode<ContentRootData> dataNode : data2) {
            ContentRootData contentRoot = (ContentRootData)dataNode.getData();
            ContentEntry contentEntry = ContentRootDataService.findOrCreateContentRoot(modifiableRootModel, contentRoot.getRootPath());
            if (!importedContentEntries.contains(contentEntry)) {
                ContentRootDataService.removeSourceFoldersIfAbsent(contentEntry, contentRoot);
                importedContentEntries.add(contentEntry);
            }
            ContentRootDataService.logDebug("Importing content root '%s' for module '%s' forceDirectoriesCreation=[%b]", contentRoot.getRootPath(), module.getName(), forceDirectoriesCreation);
            HashSet<String> updatedSourceRoots = new HashSet<String>();
            for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
                JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
                if (type == null) continue;
                for (ContentRootData.SourceRoot sourceRoot : contentRoot.getPaths(externalSrcType)) {
                    boolean createSourceFolder;
                    String sourceRootPath = sourceRoot.getPath();
                    boolean bl2 = createSourceFolder = !updatedSourceRoots.contains(sourceRootPath);
                    if (createSourceFolder) {
                        ContentRootDataService.createOrReplaceSourceFolder(sourceFolderManager, contentEntry, sourceRoot, module, type, forceDirectoriesCreation);
                        if (externalSrcType == ExternalSystemSourceType.SOURCE || externalSrcType == ExternalSystemSourceType.TEST) {
                            updatedSourceRoots.add(sourceRootPath);
                        }
                    }
                    ContentRootDataService.configureSourceFolder(sourceFolderManager, contentEntry, sourceRoot, createSourceFolder, externalSrcType.isGenerated());
                }
            }
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(ExternalSystemSourceType.EXCLUDED)) {
                ContentRootDataService.createExcludedRootIfAbsent(contentEntry, path, module.getName(), module.getProject());
            }
            contentEntriesMap.remove(contentEntry.getUrl());
        }
        for (ContentEntry contentEntry : contentEntriesMap.values()) {
            modifiableRootModel.removeContentEntry(contentEntry);
        }
    }

    @Nullable
    private static JpsModuleSourceRootType<?> getJavaSourceRootType(ExternalSystemSourceType type) {
        switch (type) {
            case SOURCE: 
            case SOURCE_GENERATED: {
                return JavaSourceRootType.SOURCE;
            }
            case TEST: 
            case TEST_GENERATED: {
                return JavaSourceRootType.TEST_SOURCE;
            }
            case EXCLUDED: {
                return null;
            }
            case RESOURCE: 
            case RESOURCE_GENERATED: {
                return JavaResourceRootType.RESOURCE;
            }
            case TEST_RESOURCE: 
            case TEST_RESOURCE_GENERATED: {
                return JavaResourceRootType.TEST_RESOURCE;
            }
        }
        return null;
    }

    @NotNull
    private static ContentEntry findOrCreateContentRoot(@NotNull ModifiableRootModel model, @NotNull String path) {
        ContentEntry[] entries;
        for (ContentEntry entry : entries = model.getContentEntries()) {
            VirtualFile file2 = entry.getFile();
            if (file2 == null || !ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(path)) continue;
            return entry;
        }
        return model.addContentEntry(VfsUtilCore.pathToUrl((String)path));
    }

    private static Set<String> getSourceRoots(@NotNull ContentRootData contentRoot) {
        Set sourceRoots = CollectionFactory.createFilePathSet();
        for (ExternalSystemSourceType externalSrcType : ExternalSystemSourceType.values()) {
            JpsModuleSourceRootType<?> type = ContentRootDataService.getJavaSourceRootType(externalSrcType);
            if (type == null) continue;
            for (ContentRootData.SourceRoot path : contentRoot.getPaths(externalSrcType)) {
                if (path == null) continue;
                sourceRoots.add(path.getPath());
            }
        }
        return sourceRoots;
    }

    private static void removeSourceFoldersIfAbsent(@NotNull ContentEntry contentEntry, @NotNull ContentRootData contentRoot) {
        SourceFolder[] sourceFolders2 = contentEntry.getSourceFolders();
        if (sourceFolders2.length == 0) {
            return;
        }
        Set<String> sourceRoots = ContentRootDataService.getSourceRoots(contentRoot);
        for (SourceFolder sourceFolder : sourceFolders2) {
            String url = sourceFolder.getUrl();
            String path = VfsUtilCore.urlToPath((String)url);
            if (sourceRoots.contains(path)) continue;
            contentEntry.removeSourceFolder(sourceFolder);
        }
    }

    private static void createOrReplaceSourceFolder(@NotNull SourceFolderManager sourceFolderManager, @NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot, @NotNull Module module, @NotNull JpsModuleSourceRootType<?> sourceRootType, boolean createEmptyContentRootDirectories) {
        SourceFolder folder;
        String path = sourceRoot.getPath();
        if (createEmptyContentRootDirectories) {
            ContentRootDataService.createEmptyDirectory(path);
        }
        if ((folder = ContentRootDataService.findSourceFolder(contentEntry, sourceRoot)) != null) {
            JpsModuleSourceRootType folderRootType = folder.getRootType();
            if (sourceRootType.equals((Object)folderRootType)) {
                return;
            }
            contentEntry.removeSourceFolder(folder);
        }
        String url = VfsUtilCore.pathToUrl((String)path);
        if (!FileUtil.exists((String)path)) {
            ContentRootDataService.logDebug("Source folder [%s] does not exist and will not be created, will add when dir is created", url);
            ContentRootDataService.logUnitTest("Adding source folder listener to watch [%s] for creation in project [hashCode=%d]", url, module.getProject().hashCode());
            sourceFolderManager.addSourceFolder(module, url, sourceRootType);
        } else {
            contentEntry.addSourceFolder(url, sourceRootType);
        }
    }

    private static void configureSourceFolder(@NotNull SourceFolderManager sourceFolderManager, @NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot, boolean updatePackagePrefix, boolean generated) {
        String packagePrefix = sourceRoot.getPackagePrefix();
        String url = VfsUtilCore.pathToUrl((String)sourceRoot.getPath());
        ContentRootDataService.logDebug("Importing root '%s' with packagePrefix=[%s] generated=[%b]", sourceRoot, packagePrefix, generated);
        SourceFolder folder = ContentRootDataService.findSourceFolder(contentEntry, sourceRoot);
        if (folder == null) {
            if (updatePackagePrefix) {
                sourceFolderManager.setSourceFolderPackagePrefix(url, packagePrefix);
            }
            if (generated) {
                sourceFolderManager.setSourceFolderGenerated(url, true);
            }
        } else {
            if (updatePackagePrefix && StringUtil.isNotEmpty((String)packagePrefix)) {
                folder.setPackagePrefix(packagePrefix);
            }
            if (generated) {
                ContentRootDataService.setForGeneratedSources(folder, true);
            }
        }
    }

    private static void createEmptyDirectory(@NotNull String path) {
        if (FileUtil.exists((String)path)) {
            return;
        }
        ExternalSystemApiUtil.doWriteAction(() -> {
            try {
                VfsUtil.createDirectoryIfMissing((String)path);
            }
            catch (IOException e) {
                LOG.warn(String.format("Unable to create directory for the path: %s", path), (Throwable)e);
            }
        });
    }

    @Nullable
    private static SourceFolder findSourceFolder(@NotNull ContentEntry contentEntry, @NotNull ContentRootData.SourceRoot sourceRoot) {
        for (SourceFolder folder : contentEntry.getSourceFolders()) {
            String rootPath;
            String folderPath;
            VirtualFile file2 = folder.getFile();
            if (file2 == null || !(folderPath = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2)).equals(rootPath = sourceRoot.getPath())) continue;
            return folder;
        }
        return null;
    }

    private static void setForGeneratedSources(@NotNull SourceFolder folder, boolean generated) {
        JpsModuleSourceRoot jpsElement = folder.getJpsElement();
        JavaSourceRootProperties properties = (JavaSourceRootProperties)jpsElement.getProperties(JavaModuleSourceRootTypes.SOURCES);
        if (properties != null) {
            properties.setForGeneratedSources(generated);
        }
    }

    private static void logUnitTest(@NotNull String format, Object ... args) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info(String.format(format, args));
        }
    }

    private static void logDebug(@NotNull String format, Object ... args) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format(format, args));
        }
    }

    private static void createExcludedRootIfAbsent(@NotNull ContentEntry entry, @NotNull ContentRootData.SourceRoot root, @NotNull String moduleName, @NotNull Project project) {
        String rootPath = root.getPath();
        for (VirtualFile file2 : entry.getExcludeFolderFiles()) {
            if (!ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)file2).equals(rootPath)) continue;
            return;
        }
        ContentRootDataService.logDebug("Importing excluded root '%s' for content root '%s' of module '%s'", root, entry.getUrl(), moduleName);
        entry.addExcludeFolder(VfsUtilCore.pathToUrl((String)rootPath));
    }

    private static void filterAndReportDuplicatingContentRoots(@NotNull MultiMap<DataNode<ModuleData>, DataNode<ContentRootData>> moduleNodeToRootNodes, @NotNull Project project) {
        String notificationMessage;
        LinkedHashMap<String, DuplicateModuleReport> filter2 = new LinkedHashMap<String, DuplicateModuleReport>();
        for (Map.Entry entry : moduleNodeToRootNodes.entrySet()) {
            ModuleData moduleData = (ModuleData)((DataNode)entry.getKey()).getData();
            Collection crDataNodes = (Collection)entry.getValue();
            Iterator iterator2 = crDataNodes.iterator();
            while (iterator2.hasNext()) {
                DataNode crDataNode = (DataNode)iterator2.next();
                String rootPath = ((ContentRootData)crDataNode.getData()).getRootPath();
                DuplicateModuleReport report = filter2.putIfAbsent(rootPath, new DuplicateModuleReport(moduleData));
                if (report == null) continue;
                report.addDuplicate(moduleData);
                iterator2.remove();
                crDataNode.clear(true);
            }
        }
        Map toReport = filter2.entrySet().stream().filter(e -> ((DuplicateModuleReport)e.getValue()).hasDuplicates()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (r1, r2) -> {
            LOG.warn("Unexpected duplicates in keys while collecting filtered reports");
            return r2;
        }, LinkedHashMap::new));
        if (!toReport.isEmpty() && (notificationMessage = ContentRootDataService.prepareMessageAndLogWarnings(toReport)) != null) {
            ContentRootDataService.showNotificationsPopup(project, toReport.size(), notificationMessage);
        }
    }

    @Nullable
    private static String prepareMessageAndLogWarnings(@NotNull Map<String, DuplicateModuleReport> toReport) {
        String firstMessage = null;
        LOG.warn("Duplicating content roots detected.");
        for (Map.Entry<String, DuplicateModuleReport> entry : toReport.entrySet()) {
            String path = entry.getKey();
            DuplicateModuleReport report = entry.getValue();
            String message = String.format("Path [%s] of module [%s] was removed from modules [%s]", path, report.getOriginalName(), StringUtil.join(report.getDuplicatesNames(), (String)", "));
            if (firstMessage == null) {
                firstMessage = message;
            }
            LOG.warn(message);
        }
        return firstMessage;
    }

    private static void showNotificationsPopup(@NotNull Project project, int reportsCount, @NotNull String notificationMessage) {
        int extraReportsCount = reportsCount - 1;
        if (extraReportsCount > 0) {
            notificationMessage = notificationMessage + "<br>Also " + extraReportsCount + " more " + StringUtil.pluralize((String)"path", (int)extraReportsCount) + " " + (extraReportsCount == 1 ? "was" : "were") + " deduplicated. See idea log for details";
        }
        Notification notification = new Notification("Content root duplicates", ExternalSystemBundle.message((String)"duplicate.content.roots.detected", (Object[])new Object[0]), notificationMessage, NotificationType.WARNING);
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private static final class DuplicateModuleReport {
        private final ModuleData myOriginal;
        private final List<ModuleData> myDuplicates = new ArrayList<ModuleData>();

        private DuplicateModuleReport(@NotNull ModuleData original) {
            this.myOriginal = original;
        }

        public void addDuplicate(@NotNull ModuleData duplicate) {
            this.myDuplicates.add(duplicate);
        }

        public boolean hasDuplicates() {
            return !this.myDuplicates.isEmpty();
        }

        public String getOriginalName() {
            return this.myOriginal.getInternalName();
        }

        public Collection<String> getDuplicatesNames() {
            return ContainerUtil.map(this.myDuplicates, AbstractNamedData::getInternalName);
        }
    }
}

