/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.configurationStore.StateStorageManagerKt;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalSystemSourceType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsDataStorage;
import com.intellij.openapi.externalSystem.service.project.manage.ModuleDataServiceExtension;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemLocalSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.event.HyperlinkEvent;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractModuleDataService<E extends ModuleData>
extends AbstractProjectDataService<E, Module> {
    public static final Key<ModuleData> MODULE_DATA_KEY = Key.create((String)"MODULE_DATA_KEY");
    public static final Key<Module> MODULE_KEY = Key.create((String)"LINKED_MODULE");
    public static final Key<Map<OrderEntry, OrderAware>> ORDERED_DATA_MAP_KEY = Key.create((String)"ORDER_ENTRY_DATA_MAP");
    private static final Key<Set<Path>> ORPHAN_MODULE_FILES = Key.create((String)"ORPHAN_FILES");
    private static final Key<AtomicInteger> ORPHAN_MODULE_HANDLERS_COUNTER = Key.create((String)"ORPHAN_MODULE_HANDLERS_COUNTER");
    private static final NotificationGroup ORPHAN_MODULE_NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)"Build sync orphan modules", (String)"Build");
    private static final Logger LOG = Logger.getInstance(AbstractModuleDataService.class);
    private static final ExtensionPointName<ModuleDataServiceExtension> EP_NAME = ExtensionPointName.create((String)"com.intellij.externalSystem.moduleDataServiceExtension");

    public void importData(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Module module;
        if (toImport.isEmpty()) {
            return;
        }
        Collection<DataNode<E>> toCreate = this.filterExistingModules(toImport, modelsProvider);
        if (!toCreate.isEmpty()) {
            this.createModules(toCreate, modelsProvider);
        }
        for (DataNode node : toImport) {
            module = (Module)node.getUserData(MODULE_KEY);
            if (module == null) continue;
            ProjectCoordinate publication = ((ModuleData)node.getData()).getPublication();
            if (publication != null) {
                modelsProvider.registerModulePublication(module, publication);
            }
            String productionModuleId = ((ModuleData)node.getData()).getProductionModuleId();
            modelsProvider.setTestModuleProperties(module, productionModuleId);
            this.setModuleOptions(module, node);
            ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module);
            AbstractModuleDataService.syncPaths(module, modifiableRootModel, (ModuleData)node.getData());
            EP_NAME.forEachExtensionSafe(extension -> extension.importModule(modelsProvider, module, (ModuleData)node.getData()));
            this.importModuleSdk(modifiableRootModel, (ModuleData)node.getData());
        }
        for (DataNode node : toImport) {
            module = (Module)node.getUserData(MODULE_KEY);
            if (module == null) continue;
            String[] groupPath = ((ModuleData)node.getData()).getIdeModuleGroup();
            ModifiableModuleModel modifiableModel = modelsProvider.getModifiableModuleModel();
            modifiableModel.setModuleGroupPath(module, groupPath);
        }
    }

    @NotNull
    protected Module createModule(@NotNull DataNode<E> module, @NotNull IdeModifiableModelsProvider modelsProvider) {
        ModuleData data2 = (ModuleData)module.getData();
        return modelsProvider.newModule(data2);
    }

    private void createModules(@NotNull Collection<? extends DataNode<E>> toCreate, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (DataNode<E> module : toCreate) {
            Module created = this.createModule(module, modelsProvider);
            module.putUserData(MODULE_KEY, (Object)created);
            final ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(created);
            RootPolicy<Object> visitor = new RootPolicy<Object>(){

                public Object visitLibraryOrderEntry(@NotNull LibraryOrderEntry libraryOrderEntry, Object value2) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)libraryOrderEntry);
                    return value2;
                }

                public Object visitModuleOrderEntry(@NotNull ModuleOrderEntry moduleOrderEntry, Object value2) {
                    modifiableRootModel.removeOrderEntry((OrderEntry)moduleOrderEntry);
                    return value2;
                }
            };
            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                orderEntry.accept((RootPolicy)visitor, null);
            }
        }
    }

    @NotNull
    private Collection<DataNode<E>> filterExistingModules(@NotNull Collection<? extends DataNode<E>> modules2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        ArrayList<DataNode<DataNode<E>>> result2 = new ArrayList<DataNode<DataNode<E>>>();
        for (DataNode<E> node : modules2) {
            ModuleData moduleData = (ModuleData)node.getData();
            Module module = modelsProvider.findIdeModule(moduleData);
            if (module == null) {
                UnloadedModuleDescription unloadedModuleDescription = modelsProvider.getUnloadedModuleDescription(moduleData);
                if (unloadedModuleDescription == null) {
                    result2.add(node);
                }
                this.markExistedModulesWithSameRoot(node, modelsProvider);
                continue;
            }
            node.putUserData(MODULE_KEY, (Object)module);
        }
        return result2;
    }

    private void markExistedModulesWithSameRoot(DataNode<E> node, IdeModifiableModelsProvider modelsProvider) {
        ModuleData moduleData = (ModuleData)node.getData();
        ProjectSystemId projectSystemId = moduleData.getOwner();
        Arrays.stream(modelsProvider.getModules()).filter(ideModule -> AbstractModuleDataService.isModulePointsSameRoot(moduleData, ideModule)).filter(module -> !ExternalSystemApiUtil.isExternalSystemAwareModule((ProjectSystemId)projectSystemId, (Module)module)).forEach(module -> ExternalSystemModulePropertyManager.getInstance((Module)module).setExternalOptions(projectSystemId, moduleData, (ProjectData)node.getData(ProjectKeys.PROJECT)));
    }

    private static boolean isModulePointsSameRoot(ModuleData moduleData, Module ideModule) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)ideModule).getContentRoots()) {
            if (!FileUtil.pathsEqual((String)root.getPath(), (String)moduleData.getLinkedExternalProjectPath())) continue;
            return true;
        }
        return false;
    }

    private static void syncPaths(@NotNull Module module, @NotNull ModifiableRootModel modifiableModel, @NotNull ModuleData data2) {
        CompilerModuleExtension extension = (CompilerModuleExtension)modifiableModel.getModuleExtension(CompilerModuleExtension.class);
        if (extension == null) {
            LOG.debug(String.format("No compiler extension is found for '%s', compiler output path will not be synced.", module.getName()));
            return;
        }
        String compileOutputPath = data2.getCompileOutputPath(ExternalSystemSourceType.SOURCE);
        extension.setCompilerOutputPath(compileOutputPath != null ? VfsUtilCore.pathToUrl((String)compileOutputPath) : null);
        String testCompileOutputPath = data2.getCompileOutputPath(ExternalSystemSourceType.TEST);
        extension.setCompilerOutputPathForTests(testCompileOutputPath != null ? VfsUtilCore.pathToUrl((String)testCompileOutputPath) : null);
        extension.inheritCompilerOutputPath(data2.isInheritProjectCompileOutputPath());
    }

    public void removeData(@NotNull Computable<Collection<Module>> toRemoveComputable, @NotNull Collection<DataNode<E>> toIgnore, @NotNull ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        Collection toRemove2 = (Collection)toRemoveComputable.compute();
        SmartList modules2 = new SmartList(toRemove2);
        for (DataNode<E> moduleDataNode : toIgnore) {
            Module module = modelsProvider.findIdeModule((ModuleData)moduleDataNode.getData());
            ContainerUtil.addIfNotNull((Collection)modules2, (Object)module);
        }
        if (modules2.isEmpty()) {
            return;
        }
        ContainerUtil.removeDuplicates((Collection)modules2);
        for (Module module : modules2) {
            if (module.isDisposed()) continue;
            AbstractModuleDataService.unlinkModuleFromExternalSystem(module);
        }
        ExternalSystemApiUtil.executeOnEdt((boolean)true, () -> AbstractModuleDataService.lambda$removeData$4(project, projectData2, (List)modules2, modelsProvider));
    }

    public void onSuccessImport(@NotNull Collection<DataNode<E>> imported, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModelsProvider modelsProvider) {
        Set orphanModules = (Set)project.getUserData(ORPHAN_MODULE_FILES);
        if (orphanModules == null || orphanModules.isEmpty()) {
            return;
        }
        AtomicInteger counter = (AtomicInteger)project.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
        if (counter == null) {
            return;
        }
        if (counter.decrementAndGet() == 0) {
            project.putUserData(ORPHAN_MODULE_FILES, null);
            project.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
            StringBuilder modulesToRestoreText = new StringBuilder();
            ArrayList<Pair> modulesToRestore = new ArrayList<Pair>();
            for (Path modulePath : orphanModules) {
                try {
                    String path = FileUtil.loadFile((File)modulePath.resolveSibling(modulePath.getFileName() + ".path").toFile());
                    modulesToRestoreText.append(FileUtilRt.getNameWithoutExtension((String)new File(path).getName())).append("\n");
                    modulesToRestore.add(Pair.create((Object)path, (Object)modulePath));
                }
                catch (IOException e) {
                    LOG.warn((Throwable)e);
                }
            }
            String buildSystem = projectData2 != null ? projectData2.getOwner().getReadableName() : "build system";
            String content2 = ExternalSystemBundle.message((String)"orphan.modules.text", (Object[])new Object[]{buildSystem, StringUtil.shortenTextWithEllipsis((String)modulesToRestoreText.toString(), (int)50, (int)0)});
            Notification cleanUpNotification = ORPHAN_MODULE_NOTIFICATION_GROUP.createNotification(content2, NotificationType.INFORMATION).setListener((notification, event) -> {
                if (event.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                    return;
                }
                if (AbstractModuleDataService.showRemovedOrphanModules(modulesToRestore, project)) {
                    notification.expire();
                }
            }).whenExpired(() -> {
                List filesToRemove = ContainerUtil.map((Collection)orphanModules, Path::toFile);
                List toRemove2 = ContainerUtil.map((Collection)orphanModules, path -> path.resolveSibling(path.getFileName() + ".path").toFile());
                FileUtil.asyncDelete((Collection)ContainerUtil.concat((List)filesToRemove, (List)toRemove2));
            });
            Disposer.register((Disposable)project, () -> ((Notification)cleanUpNotification).expire());
            cleanUpNotification.notify(project);
        }
    }

    public void onFailureImport(Project project) {
        project.putUserData(ORPHAN_MODULE_FILES, null);
        project.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, null);
    }

    private static boolean showRemovedOrphanModules(final @NotNull List<? extends Pair<String, Path>> orphanModules, @NotNull Project project) {
        final CheckBoxList orphanModulesList = new CheckBoxList();
        DialogWrapper dialog2 = new DialogWrapper(project){
            {
                super(x0);
                this.setTitle(ExternalSystemBundle.message((String)"orphan.modules.dialog.title", (Object[])new Object[0]));
                this.init();
            }

            protected JComponent createCenterPanel() {
                orphanModulesList.setSelectionMode(2);
                orphanModulesList.setItems(orphanModules, module -> FileUtilRt.getNameWithoutExtension((String)new File((String)module.getFirst()).getName()));
                orphanModulesList.setBorder(JBUI.Borders.empty((int)5));
                JScrollPane myModulesScrollPane = ScrollPaneFactory.createScrollPane((Component)orphanModulesList, (int)20, (int)30);
                myModulesScrollPane.setBorder(new MatteBorder(0, 0, 1, 0, JBColor.border()));
                myModulesScrollPane.setMaximumSize(new Dimension(-1, 300));
                JPanel content2 = new JPanel(new BorderLayout());
                content2.add((Component)myModulesScrollPane, "Center");
                return content2;
            }

            @NotNull
            protected JComponent createNorthPanel() {
                GridBagConstraints gbConstraints = new GridBagConstraints();
                JPanel panel2 = new JPanel(new GridBagLayout());
                gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)10, (int)8);
                panel2.add((Component)new JLabel(ExternalSystemBundle.message((String)"orphan.modules.dialog.text", (Object[])new Object[0])), gbConstraints);
                return panel2;
            }
        };
        if (dialog2.showAndGet()) {
            ExternalSystemApiUtil.doWriteAction(() -> {
                for (int i2 = 0; i2 < orphanModules.size(); ++i2) {
                    Pair pair = (Pair)orphanModules.get(i2);
                    String originalPath = (String)pair.first;
                    Path savedPath = (Path)pair.second;
                    if (!orphanModulesList.isItemSelected(i2) || !savedPath.toFile().isFile()) continue;
                    try {
                        FileUtil.copy((File)savedPath.toFile(), (File)new File(originalPath));
                        ModuleManager.getInstance((Project)project).loadModule(originalPath);
                        continue;
                    }
                    catch (ModuleWithNameAlreadyExists | IOException | JDOMException e) {
                        LOG.warn(e);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static void unlinkModuleFromExternalSystem(@NotNull Module module) {
        ExternalSystemModulePropertyManager.getInstance((Module)module).unlinkExternalOptions();
    }

    protected void setModuleOptions(Module module, DataNode<E> moduleDataNode) {
        ModuleData moduleData = (ModuleData)moduleDataNode.getData();
        module.putUserData(MODULE_DATA_KEY, (Object)moduleData);
        ExternalSystemModulePropertyManager.getInstance((Module)module).setExternalOptions(moduleData.getOwner(), moduleData, (ProjectData)moduleDataNode.getData(ProjectKeys.PROJECT));
    }

    public void postProcess(@NotNull Collection<DataNode<E>> toImport, @Nullable ProjectData projectData2, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        for (DataNode<E> moduleDataNode : toImport) {
            Module module = (Module)moduleDataNode.getUserData(MODULE_KEY);
            if (module == null) continue;
            Map orderAwareMap = (Map)moduleDataNode.getUserData(ORDERED_DATA_MAP_KEY);
            if (orderAwareMap != null) {
                this.rearrangeOrderEntries(orderAwareMap, modelsProvider.getModifiableRootModel(module));
            }
            moduleDataNode.putUserData(MODULE_KEY, null);
            moduleDataNode.putUserData(ORDERED_DATA_MAP_KEY, null);
        }
        for (Module module : modelsProvider.getModules()) {
            module.putUserData(MODULE_DATA_KEY, null);
        }
    }

    protected void rearrangeOrderEntries(@NotNull Map<OrderEntry, OrderAware> orderEntryDataMap, @NotNull ModifiableRootModel modifiableRootModel) {
        Pair pair;
        int i2;
        Object[] orderEntries = modifiableRootModel.getOrderEntries();
        int length = orderEntries.length;
        Object[] newOrder = new OrderEntry[length];
        PriorityQueue<Pair> priorityQueue = new PriorityQueue<Pair>(11, (o1, o2) -> {
            int order2;
            int order1 = ((OrderAware)o1.second).getOrder();
            if (order1 != (order2 = ((OrderAware)o2.second).getOrder())) {
                return order1 < order2 ? -1 : 1;
            }
            return ((OrderAware)o1.second).toString().compareTo(((OrderAware)o2.second).toString());
        });
        ArrayList<OrderEntry> noOrderAwareItems = new ArrayList<OrderEntry>();
        for (i2 = 0; i2 < length; ++i2) {
            OrderEntry orderEntry = orderEntries[i2];
            OrderAware orderAware = orderEntryDataMap.get(orderEntry);
            if (orderAware == null) {
                noOrderAwareItems.add(orderEntry);
                continue;
            }
            priorityQueue.add(Pair.create((Object)orderEntry, (Object)orderAware));
        }
        noOrderAwareItems.sort(new Comparator<OrderEntry>(){

            @Override
            public int compare(OrderEntry o1, OrderEntry o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        for (i2 = 0; i2 < noOrderAwareItems.size(); ++i2) {
            newOrder[i2] = (OrderEntry)noOrderAwareItems.get(i2);
        }
        int index = noOrderAwareItems.size();
        while ((pair = (Pair)priorityQueue.poll()) != null) {
            newOrder[index] = (OrderEntry)pair.first;
            ++index;
        }
        if (LOG.isDebugEnabled()) {
            boolean changed2 = !ArrayUtil.equals((Object[])orderEntries, (Object[])newOrder, Comparator.naturalOrder());
            LOG.debug(String.format("rearrange status (%s): %s", modifiableRootModel.getModule(), changed2 ? "modified" : "not modified"));
        }
        modifiableRootModel.rearrangeOrderEntries((OrderEntry[])newOrder);
    }

    private static int findNewPlace(OrderEntry[] newOrder, int newIndex) {
        int idx;
        for (idx = newIndex; idx < 0 || idx < newOrder.length && newOrder[idx] != null; ++idx) {
        }
        if (idx >= newOrder.length) {
            for (idx = newIndex - 1; idx >= 0 && (idx >= newOrder.length || newOrder[idx] != null); --idx) {
            }
        }
        return idx;
    }

    private void importModuleSdk(@NotNull ModifiableRootModel modifiableRootModel, E data2) {
        if (!data2.isSetSdkName()) {
            return;
        }
        if (modifiableRootModel.getSdk() != null) {
            return;
        }
        String skdName = data2.getSdkName();
        if (skdName == null) {
            return;
        }
        ProjectJdkTable projectJdkTable = ProjectJdkTable.getInstance();
        Sdk sdk2 = projectJdkTable.findJdk(skdName);
        if (sdk2 == null) {
            return;
        }
        Project project = modifiableRootModel.getProject();
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)project);
        Sdk projectSdk = projectRootManager.getProjectSdk();
        if (sdk2.equals(projectSdk)) {
            modifiableRootModel.inheritSdk();
        } else {
            modifiableRootModel.setSdk(sdk2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ void lambda$removeData$4(Project project, ProjectData projectData2, List modules2, IdeModifiableModelsProvider modelsProvider) {
        AtomicInteger counter = (AtomicInteger)project.getUserData(ORPHAN_MODULE_HANDLERS_COUNTER);
        if (counter == null) {
            counter = new AtomicInteger();
            project.putUserData(ORPHAN_MODULE_HANDLERS_COUNTER, (Object)counter);
        }
        counter.incrementAndGet();
        LinkedHashSet<Path> orphanModules = (LinkedHashSet<Path>)project.getUserData(ORPHAN_MODULE_FILES);
        if (orphanModules == null) {
            orphanModules = new LinkedHashSet<Path>();
            project.putUserData(ORPHAN_MODULE_FILES, orphanModules);
        }
        LocalHistoryAction historyAction = LocalHistory.getInstance().startAction(ExternalSystemBundle.message((String)"local.history.remove.orphan.modules", (Object[])new Object[0]));
        try {
            String rootProjectPathKey = String.valueOf(projectData2.getLinkedExternalProjectPath().hashCode());
            Path unlinkedModulesDir = ExternalProjectsDataStorage.getProjectConfigurationDir(project).resolve("orphanModules").resolve(rootProjectPathKey);
            if (!FileUtil.createDirectory((File)unlinkedModulesDir.toFile())) {
                LOG.warn("Unable to create " + unlinkedModulesDir);
                return;
            }
            AbstractExternalSystemLocalSettings localSettings = ExternalSystemApiUtil.getLocalSettings((Project)project, (ProjectSystemId)projectData2.getOwner());
            AbstractExternalSystemLocalSettings.SyncType syncType = (AbstractExternalSystemLocalSettings.SyncType)localSettings.getProjectSyncType().get(projectData2.getLinkedExternalProjectPath());
            for (Module module : modules2) {
                if (module.isDisposed()) continue;
                String path = module.getModuleFilePath();
                if (!ApplicationManager.getApplication().isHeadlessEnvironment() && syncType == AbstractExternalSystemLocalSettings.SyncType.RE_IMPORT) {
                    try {
                        StateStorageManagerKt.saveComponentManager((ComponentManager)module);
                        VirtualFile moduleFile = module.getModuleFile();
                        if (moduleFile != null) {
                            Path orphanModulePath = unlinkedModulesDir.resolve(String.valueOf(path.hashCode()));
                            FileUtil.writeToFile((File)orphanModulePath.toFile(), (byte[])moduleFile.contentsToByteArray());
                            Path orphanModuleOriginPath = unlinkedModulesDir.resolve(path.hashCode() + ".path");
                            FileUtil.writeToFile((File)orphanModuleOriginPath.toFile(), (String)path);
                            orphanModules.add(orphanModulePath);
                        }
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                }
                modelsProvider.getModifiableModuleModel().disposeModule(module);
                ModuleBuilder.deleteModuleFile((String)path);
            }
        }
        finally {
            historyAction.finish();
        }
    }
}

