/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.Key;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jetbrains.annotations.NotNull;

public final class PerformanceTrace
implements Serializable {
    public static final Key<PerformanceTrace> TRACE_NODE_KEY = Key.create(PerformanceTrace.class, (int)1001);
    private final Map<String, Long> performanceData = new ConcurrentSkipListMap<String, Long>();

    public void logPerformance(@NotNull String key, long millis) {
        this.performanceData.put(key, millis);
    }

    @NotNull
    public Map<String, Long> getPerformanceTrace() {
        return this.performanceData;
    }

    public void addTrace(@NotNull Map<String, Long> trace) {
        this.performanceData.putAll(trace);
    }
}

