/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project;

import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.AbstractIdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.ExternalProjectsWorkspaceImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public class ModifiableWorkspace {
    private final Map<ProjectCoordinate, String> myModuleMappingById = new THashMap((TObjectHashingStrategy)new TObjectHashingStrategy<ProjectCoordinate>(){

        public int computeHashCode(ProjectCoordinate object) {
            String groupId2 = object.getGroupId();
            String artifactId2 = object.getArtifactId();
            String version2 = object.getVersion();
            int result1 = groupId2 != null ? groupId2.hashCode() : 0;
            result1 = 31 * result1 + (artifactId2 != null ? artifactId2.hashCode() : 0);
            result1 = 31 * result1 + (version2 != null ? version2.hashCode() : 0);
            return result1;
        }

        public boolean equals(ProjectCoordinate o1, ProjectCoordinate o2) {
            if (o1.getGroupId() != null ? !o1.getGroupId().equals(o2.getGroupId()) : o2.getGroupId() != null) {
                return false;
            }
            if (o1.getArtifactId() != null ? !o1.getArtifactId().equals(o2.getArtifactId()) : o2.getArtifactId() != null) {
                return false;
            }
            return !(o1.getVersion() != null ? !o1.getVersion().equals(o2.getVersion()) : o2.getVersion() != null);
        }
    });
    private final AbstractIdeModifiableModelsProvider myModelsProvider;
    private final ExternalProjectsWorkspaceImpl.State myState;
    private final MultiMap<String, String> mySubstitutions = MultiMap.createSet();
    private final Map<String, String> myNamesMap = new HashMap<String, String>();

    public ModifiableWorkspace(ExternalProjectsWorkspaceImpl.State state, AbstractIdeModifiableModelsProvider modelsProvider) {
        this.myModelsProvider = modelsProvider;
        HashSet<String> existingModules = new HashSet<String>();
        for (Module module : modelsProvider.getModules()) {
            this.register(module, modelsProvider);
            existingModules.add(module.getName());
        }
        this.myState = state;
        if (this.myState.names != null) {
            for (Map.Entry entry : this.myState.names.entrySet()) {
                if (!existingModules.contains(entry.getKey())) continue;
                this.myNamesMap.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.myState.substitutions != null) {
            for (Map.Entry entry : this.myState.substitutions.entrySet()) {
                if (!existingModules.contains(entry.getKey())) continue;
                this.mySubstitutions.put(entry.getKey(), (Collection)entry.getValue());
            }
        }
    }

    public void commit() {
        HashSet existingModules = new HashSet();
        Arrays.stream(this.myModelsProvider.getModules()).map(Module::getName).forEach(existingModules::add);
        this.myState.names = new HashMap<String, String>();
        this.myNamesMap.forEach((module, lib) -> {
            if (existingModules.contains(module)) {
                this.myState.names.put((String)module, (String)lib);
            }
        });
        this.myState.substitutions = new HashMap<String, Set<String>>();
        for (Map.Entry entry : this.mySubstitutions.entrySet()) {
            Collection value2;
            if (!existingModules.contains(entry.getKey()) || (value2 = (Collection)entry.getValue()) == null || value2.isEmpty()) continue;
            this.myState.substitutions.put((String)entry.getKey(), new TreeSet(value2));
        }
    }

    public void addSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope) {
        this.myNamesMap.put(moduleName, libraryName);
        this.mySubstitutions.putValue((Object)ownerModuleName, (Object)(moduleName + '_' + scope.getDisplayName()));
    }

    public void removeSubstitution(String ownerModuleName, String moduleName, String libraryName, DependencyScope scope) {
        this.mySubstitutions.remove((Object)ownerModuleName, (Object)(moduleName + '_' + scope.getDisplayName()));
        Collection substitutions = this.mySubstitutions.values();
        for (DependencyScope dependencyScope : DependencyScope.values()) {
            if (!substitutions.contains(moduleName + '_' + dependencyScope.getDisplayName())) continue;
            return;
        }
        this.myNamesMap.remove(moduleName, libraryName);
    }

    public boolean isSubstitution(String moduleOwner, String substitutionModule, DependencyScope scope) {
        return this.mySubstitutions.get((Object)moduleOwner).contains(substitutionModule + '_' + scope.getDisplayName());
    }

    public boolean isSubstituted(String libraryName) {
        return this.myNamesMap.containsValue(libraryName);
    }

    public String getSubstitutedLibrary(String moduleName) {
        return this.myNamesMap.get(moduleName);
    }

    @Nullable
    public String findModule(@NotNull ProjectCoordinate id2) {
        if (StringUtil.isEmpty((String)id2.getArtifactId())) {
            return null;
        }
        String result2 = this.myModuleMappingById.get(id2);
        return result2 == null && id2.getVersion() != null ? this.myModuleMappingById.get(new ProjectId(id2.getGroupId(), id2.getArtifactId(), null)) : result2;
    }

    public void register(@NotNull ProjectCoordinate id2, @NotNull Module module) {
        this.myModuleMappingById.put(id2, module.getName());
        this.myModuleMappingById.put((ProjectCoordinate)new ProjectId(id2.getGroupId(), id2.getArtifactId(), null), module.getName());
    }

    private void register(@NotNull Module module, AbstractIdeModifiableModelsProvider modelsProvider) {
        Arrays.stream(ExternalProjectsWorkspaceImpl.EP_NAME.getExtensions()).map(contributor -> contributor.findProjectId(module, modelsProvider)).filter(Objects::nonNull).findFirst().ifPresent(id2 -> this.register((ProjectCoordinate)id2, module));
    }
}

