/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SimpleJavaParameters;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.rmi.RemoteProcessSupport;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.service.ExternalSystemCommunicationManager;
import com.intellij.openapi.externalSystem.service.InProcessExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacade;
import com.intellij.openapi.externalSystem.service.RemoteExternalSystemFacadeImpl;
import com.intellij.openapi.externalSystem.service.ResolverDeserializationWrapper;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemJdkProvider;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.ExternalSystemProgressNotificationManagerImpl;
import com.intellij.openapi.externalSystem.service.remote.RemoteExternalSystemProgressNotificationManager;
import com.intellij.openapi.externalSystem.service.remote.wrapper.ExternalSystemFacadeWrapper;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.SimpleJavaSdkType;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ProjectExtension;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.serialization.ObjectSerializer;
import com.intellij.ui.PlaceHolder;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Unit;
import kotlin.reflect.full.NoSuchPropertyException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RemoteExternalSystemCommunicationManager
implements ExternalSystemCommunicationManager,
Disposable {
    private static final Logger LOG = Logger.getInstance(RemoteExternalSystemCommunicationManager.class);
    private static final String MAIN_CLASS_NAME = RemoteExternalSystemFacadeImpl.class.getName();
    private final AtomicReference<RemoteExternalSystemProgressNotificationManager> myExportedNotificationManager = new AtomicReference();
    @NotNull
    private final ThreadLocal<ProjectSystemId> myTargetExternalSystemId = new ThreadLocal();
    @NotNull
    private final ExternalSystemProgressNotificationManagerImpl myProgressManager = (ExternalSystemProgressNotificationManagerImpl)ApplicationManager.getApplication().getService(ExternalSystemProgressNotificationManager.class);
    @NotNull
    private final RemoteProcessSupport<Object, RemoteExternalSystemFacade, String> mySupport = new RemoteProcessSupport<Object, RemoteExternalSystemFacade, String>(RemoteExternalSystemFacade.class){

        @Override
        protected void fireModificationCountChanged() {
        }

        @Override
        protected String getName(@NotNull Object o) {
            return RemoteExternalSystemFacade.class.getName();
        }

        @Override
        protected RunProfileState getRunProfileState(@NotNull Object o, @NotNull String configuration, @NotNull Executor executor) {
            return RemoteExternalSystemCommunicationManager.this.createRunProfileState(configuration);
        }
    };

    public RemoteExternalSystemCommunicationManager() {
        ShutDownTracker.getInstance().registerShutdownTask(() -> this.shutdown(false));
    }

    public synchronized void shutdown(boolean wait) {
        this.mySupport.stopAll(wait);
    }

    private RunProfileState createRunProfileState(final String configuration) {
        return new RunProfileState(){

            private SimpleJavaParameters createJavaParameters() throws ExecutionException {
                ExternalSystemManager manager;
                ProjectSystemId externalSystemId;
                SimpleJavaParameters params = new SimpleJavaParameters();
                params.setJdk(new SimpleJavaSdkType().createJdk("tmp", SystemProperties.getJavaHome()));
                File myWorkingDirectory = new File(configuration);
                params.setWorkingDirectory(myWorkingDirectory.isDirectory() ? myWorkingDirectory.getPath() : PathManager.getBinPath());
                ArrayList classPath = new ArrayList(PathManager.getUtilClassPath());
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(Project.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(PlaceHolder.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(DependencyScope.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(ProjectExtension.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(Alarm.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(ExtensionPointName.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(StorageUtilKt.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(ExternalSystemTaskNotificationListener.class));
                Class<?> javaSdkClass = ExternalSystemJdkProvider.getInstance().getJavaSdkType().getClass();
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(javaSdkClass));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(ModuleType.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(EmptyModuleType.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(Unit.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(NoSuchPropertyException.class));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(this.getClass()));
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(ExternalSystemException.class));
                ExternalSystemApiUtil.addBundle((PathsList)params.getClassPath(), (String)"messages.CommonBundle", CommonBundle.class);
                ContainerUtil.addIfNotNull(classPath, (Object)PathUtil.getJarPathForClass(ObjectSerializer.class));
                params.getClassPath().addAll(classPath);
                params.setMainClass(MAIN_CLASS_NAME);
                params.getVMParametersList().addParametersString("-Djava.awt.headless=true");
                params.getVMParametersList().addParametersString("-Dsun.rmi.transport.connectionTimeout=" + TimeUnit.HOURS.toMillis(1L));
                String debugPort = System.getProperty("external.system.remote.communication.manager.debug.port");
                if (debugPort != null) {
                    params.getVMParametersList().addParametersString("-Xdebug -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + debugPort);
                }
                if ((externalSystemId = (ProjectSystemId)RemoteExternalSystemCommunicationManager.this.myTargetExternalSystemId.get()) != null && (manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId)) != null) {
                    params.getClassPath().add(PathUtil.getJarPathForClass((Class)manager.getProjectResolverClass()));
                    params.getProgramParametersList().add(manager.getProjectResolverClass().getName());
                    params.getProgramParametersList().add(manager.getTaskManagerClass().getName());
                    manager.enhanceRemoteProcessing(params);
                }
                return params;
            }

            @NotNull
            public ExecutionResult execute(@NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                OSProcessHandler processHandler2 = this.startProcess();
                return new DefaultExecutionResult((ProcessHandler)processHandler2);
            }

            @NotNull
            private OSProcessHandler startProcess() throws ExecutionException {
                SimpleJavaParameters params = this.createJavaParameters();
                GeneralCommandLine commandLine = params.toCommandLine();
                OSProcessHandler processHandler2 = new OSProcessHandler(commandLine);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler2);
                return processHandler2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RemoteExternalSystemFacade acquire(@NotNull String id2, @NotNull ProjectSystemId externalSystemId) throws Exception {
        RemoteExternalSystemFacade facade;
        this.myTargetExternalSystemId.set(externalSystemId);
        try {
            facade = this.mySupport.acquire(this, id2);
        }
        finally {
            this.myTargetExternalSystemId.set(null);
        }
        if (facade == null) {
            return null;
        }
        RemoteExternalSystemProgressNotificationManager exported = this.myExportedNotificationManager.get();
        if (exported == null) {
            try {
                exported = (RemoteExternalSystemProgressNotificationManager)UnicastRemoteObject.exportObject((Remote)this.myProgressManager, 0);
                this.myExportedNotificationManager.set(exported);
            }
            catch (RemoteException e) {
                exported = this.myExportedNotificationManager.get();
            }
        }
        if (exported == null) {
            LOG.warn("Can't export progress manager");
        } else {
            facade.applyProgressManager(exported);
        }
        return RemoteExternalSystemCommunicationManager.wrapResolverDeserialization(facade);
    }

    @NotNull
    private static RemoteExternalSystemFacade wrapResolverDeserialization(@NotNull RemoteExternalSystemFacade facade) {
        return new ResolverDeserializationWrapper(facade);
    }

    @Override
    public void release(@NotNull String id2, @NotNull ProjectSystemId externalSystemId) {
        this.mySupport.release(this, id2);
    }

    @Override
    public boolean isAlive(@NotNull RemoteExternalSystemFacade facade) {
        RemoteExternalSystemFacade toCheck = facade;
        if (facade instanceof ExternalSystemFacadeWrapper) {
            toCheck = ((ExternalSystemFacadeWrapper)facade).getDelegate();
        }
        if (toCheck instanceof InProcessExternalSystemFacadeImpl) {
            return false;
        }
        try {
            facade.getResolver();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    @Override
    public void clear() {
        this.mySupport.stopAll(true);
    }

    public void dispose() {
        this.shutdown(false);
    }
}

