/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.settings;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public enum LocationSettingType {
    DEDUCED("setting.type.location.deduced", "TextField.inactiveForeground"),
    UNKNOWN("setting.type.location.unknown"),
    EXPLICIT_INCORRECT("setting.type.location.explicit.incorrect"),
    EXPLICIT_CORRECT("setting.type.location.explicit.correct");

    @PropertyKey(resourceBundle="messages.ExternalSystemBundle")
    @NotNull
    private final String myDescriptionKey;
    @NotNull
    private final Color myColor;

    private LocationSettingType(String descriptionKey) {
        this(descriptionKey, "TextField.foreground");
    }

    private LocationSettingType(String descriptionKey, String key) {
        this.myDescriptionKey = descriptionKey;
        this.myColor = JBColor.namedColor((String)key, (Color)UIManager.getColor(key));
    }

    public String getDescription(@NotNull ProjectSystemId externalSystemId) {
        return ExternalSystemBundle.message((String)this.myDescriptionKey, (Object[])new Object[]{externalSystemId.getReadableName()});
    }

    @NotNull
    public Color getColor() {
        return this.myColor;
    }
}

