/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model.internal;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InternalExternalProjectInfo
implements ExternalProjectInfo {
    @NotNull
    private final ProjectSystemId projectSystemId;
    @NotNull
    private final String externalProjectPath;
    @Nullable
    private final DataNode<ProjectData> externalProjectStructure;
    private long lastSuccessfulImportTimestamp = -1L;
    private long lastImportTimestamp = -1L;
    private final String buildNumber;

    public InternalExternalProjectInfo(@NotNull ProjectSystemId projectSystemId, @NotNull String externalProjectPath, @Nullable DataNode<ProjectData> externalProjectStructure) {
        this.projectSystemId = projectSystemId;
        this.externalProjectPath = externalProjectPath;
        this.externalProjectStructure = externalProjectStructure;
        this.buildNumber = ApplicationInfo.getInstance().getBuild().asString();
    }

    private InternalExternalProjectInfo() {
        this.projectSystemId = ProjectSystemId.IDE;
        this.externalProjectPath = "";
        this.externalProjectStructure = null;
        this.buildNumber = ApplicationManager.getApplication() == null ? "" : ApplicationInfo.getInstance().getBuild().asString();
    }

    @NotNull
    public ProjectSystemId getProjectSystemId() {
        return this.projectSystemId;
    }

    @NotNull
    public String getExternalProjectPath() {
        return this.externalProjectPath;
    }

    @Nullable
    public String getNullSafeExternalProjectPath() {
        return this.externalProjectPath;
    }

    @Nullable
    public DataNode<ProjectData> getExternalProjectStructure() {
        return this.externalProjectStructure;
    }

    public long getLastSuccessfulImportTimestamp() {
        return this.lastSuccessfulImportTimestamp;
    }

    public long getLastImportTimestamp() {
        return this.lastImportTimestamp;
    }

    public void setLastSuccessfulImportTimestamp(long value2) {
        this.lastSuccessfulImportTimestamp = value2;
    }

    public void setLastImportTimestamp(long value2) {
        this.lastImportTimestamp = value2;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public ExternalProjectInfo copy() {
        InternalExternalProjectInfo copy2 = new InternalExternalProjectInfo(this.projectSystemId, this.externalProjectPath, this.externalProjectStructure != null ? this.externalProjectStructure.graphCopy() : null);
        copy2.setLastImportTimestamp(this.lastImportTimestamp);
        copy2.setLastSuccessfulImportTimestamp(this.lastSuccessfulImportTimestamp);
        return copy2;
    }

    public String toString() {
        return "InternalExternalProjectInfo{myProjectSystemId=" + this.projectSystemId + ", externalProjectPath='" + this.externalProjectPath + '\'' + ", externalProjectStructure=" + this.externalProjectStructure + ", lastSuccessfulImportTimestamp=" + this.lastSuccessfulImportTimestamp + ", lastImportTimestamp=" + this.lastImportTimestamp + '}';
    }
}

