/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractExternalEntityData;
import com.intellij.openapi.externalSystem.model.project.settings.ConfigurationData;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.serialization.PropertyMapping;
import java.util.Map;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;

@ApiStatus.Experimental
public final class ConfigurationDataImpl
extends AbstractExternalEntityData
implements ConfigurationData {
    @Language(value="JSON")
    @NotNull
    private final String data;
    @Nullable
    private volatile transient Object myJsonObject;

    @PropertyMapping(value={"owner", "data"})
    public ConfigurationDataImpl(@NotNull ProjectSystemId owner, @Language(value="JSON") @NotNull String data2) {
        super(owner);
        this.data = data2;
    }

    @Language(value="JSON")
    @NotNull
    public String getJsonString() {
        return this.data;
    }

    public Object find(@NotNull String query) {
        if (StringUtil.isEmpty((String)query)) {
            return null;
        }
        Object jsonObject = this.getJsonObject();
        for (String part : StringUtil.split((String)query, (String)".")) {
            if (jsonObject instanceof Map) {
                jsonObject = ((Map)jsonObject).get(part);
                continue;
            }
            return null;
        }
        return jsonObject;
    }

    public Object getJsonObject() {
        if (this.myJsonObject == null) {
            JsonReaderEx reader = new JsonReaderEx(this.data);
            reader.setLenient(true);
            this.myJsonObject = JsonUtil.nextAny(reader);
        }
        return this.myJsonObject;
    }
}

