/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action.task;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunExternalSystemTaskAction
extends ExternalSystemNodeAction<TaskData> {
    private static final Logger LOG = Logger.getInstance(RunExternalSystemTaskAction.class);

    public RunExternalSystemTaskAction() {
        super(TaskData.class);
    }

    @Override
    protected void perform(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull TaskData taskData, @NotNull AnActionEvent e) {
        ExternalTaskExecutionInfo taskExecutionInfo = ExternalSystemActionUtil.buildTaskInfo(taskData);
        ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)e.getDataContext());
        RunnerAndConfigurationSettings configuration = RunExternalSystemTaskAction.findOrGet(context);
        if (configuration == null || !RunExternalSystemTaskAction.runTaskAsExistingConfiguration(project, projectSystemId, taskExecutionInfo, configuration)) {
            RunExternalSystemTaskAction.runTaskAsNewRunConfiguration(project, projectSystemId, taskExecutionInfo);
            configuration = RunExternalSystemTaskAction.findOrGet(context);
        }
        context.getRunManager().setSelectedConfiguration(configuration);
    }

    @Nullable
    private static RunnerAndConfigurationSettings findOrGet(@NotNull ConfigurationContext context) {
        RunnerAndConfigurationSettings result2 = context.findExisting();
        if (result2 == null && (result2 = context.getConfiguration()) != null) {
            context.getRunManager().setTemporaryConfiguration(result2);
        }
        return result2;
    }

    private static boolean runTaskAsExistingConfiguration(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull ExternalTaskExecutionInfo taskExecutionInfo, @NotNull RunnerAndConfigurationSettings configuration) {
        String executorId = taskExecutionInfo.getExecutorId();
        String runnerId = ExternalSystemUtil.getRunnerId(executorId);
        if (runnerId == null) {
            return false;
        }
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        ProgramRunner runner = ProgramRunner.findRunnerById((String)runnerId);
        if (executor == null || runner == null) {
            return false;
        }
        ExecutionEnvironment environment = new ExecutionEnvironment(executor, runner, configuration, project);
        ApplicationManager.getApplication().invokeLater(() -> {
            try {
                environment.getRunner().execute(environment);
            }
            catch (ExecutionException exception) {
                LOG.error("Failed to execute " + projectSystemId.getReadableName() + " task.", (Throwable)exception);
            }
        });
        return true;
    }

    private static void runTaskAsNewRunConfiguration(@NotNull Project project, @NotNull ProjectSystemId projectSystemId, @NotNull ExternalTaskExecutionInfo taskExecutionInfo) {
        ExternalSystemUtil.runTask(taskExecutionInfo.getSettings(), taskExecutionInfo.getExecutorId(), project, projectSystemId);
    }
}

