/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.action.ExternalSystemAction;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.view.RunConfigurationNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class RemoveExternalSystemRunConfigurationAction
extends ExternalSystemAction {
    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        List selectedNodes = (List)e.getData(ExternalSystemDataKeys.SELECTED_NODES);
        if (selectedNodes == null || selectedNodes.size() != 1) {
            return false;
        }
        return selectedNodes.get(0) instanceof RunConfigurationNode;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = this.getProject(e);
        assert (project != null);
        List selectedNodes = (List)e.getData(ExternalSystemDataKeys.SELECTED_NODES);
        if (selectedNodes == null || selectedNodes.size() != 1 || !(selectedNodes.get(0) instanceof RunConfigurationNode)) {
            return;
        }
        RunnerAndConfigurationSettings settings = ((RunConfigurationNode)selectedNodes.get(0)).getSettings();
        assert (settings != null);
        ExternalSystemActionsCollector.trigger(project, this.getSystemId(e), this, e);
        int res2 = Messages.showYesNoDialog((Project)project, (String)ExternalSystemBundle.message((String)"delete.0", (Object[])new Object[]{settings.getName()}), (String)ExternalSystemBundle.message((String)"confirmation", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (res2 == 0) {
            RunManager.getInstance((Project)project).removeConfiguration(settings);
        }
    }
}

