/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.externalSystem.service.internal.ExternalSystemProcessingManager;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemActionsCollector;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RefreshAllExternalProjectsAction
extends AnAction
implements AnAction.TransparentUpdate,
DumbAware {
    public RefreshAllExternalProjectsAction() {
        this.getTemplatePresentation().setText(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.description", (Object[])new Object[]{"external"}));
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String name = StringUtil.join(systemIds, projectSystemId -> projectSystemId.getReadableName(), (String)",");
        e.getPresentation().setText(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.text", (Object[])new Object[]{name}));
        e.getPresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.refresh.all.projects.description", (Object[])new Object[]{name}));
        ExternalSystemProcessingManager processingManager = (ExternalSystemProcessingManager)ServiceManager.getService(ExternalSystemProcessingManager.class);
        e.getPresentation().setEnabled(!processingManager.hasTaskOfTypeInProgress(ExternalSystemTaskType.RESOLVE_PROJECT, project));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        List<ProjectSystemId> systemIds = RefreshAllExternalProjectsAction.getSystemIds(e);
        if (systemIds.isEmpty()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        for (ProjectSystemId externalSystemId : systemIds) {
            ExternalSystemActionsCollector.trigger(project, externalSystemId, this, e);
            ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project, externalSystemId).forceWhenUptodate(true));
        }
    }

    @NotNull
    private static List<ProjectSystemId> getSystemIds(@NotNull AnActionEvent e) {
        ArrayList<ProjectSystemId> systemIds = new ArrayList<ProjectSystemId>();
        ProjectSystemId externalSystemId = (ProjectSystemId)e.getData(ExternalSystemDataKeys.EXTERNAL_SYSTEM_ID);
        if (externalSystemId == null) {
            ExternalSystemManager.EP_NAME.forEachExtensionSafe(manager -> systemIds.add(manager.getSystemId()));
        } else {
            systemIds.add(externalSystemId);
        }
        return systemIds;
    }
}

