/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.externalSystem.ExternalSystemUiAware;
import com.intellij.openapi.externalSystem.action.ExternalSystemNodeAction;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ExternalConfigPathAware;
import com.intellij.openapi.externalSystem.model.project.ExternalEntityData;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class OpenExternalConfigAction
extends ExternalSystemNodeAction<ExternalConfigPathAware> {
    public OpenExternalConfigAction() {
        super(ExternalConfigPathAware.class);
        this.getTemplatePresentation().setText(ExternalSystemBundle.messagePointer((String)"action.open.config.text", (Object[])new Object[]{"External"}));
        this.getTemplatePresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.open.config.description", (Object[])new Object[]{"external"}));
    }

    @Override
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        ExternalEntityData externalData = this.getExternalData(e, ExternalEntityData.class);
        if (!(externalData instanceof ExternalConfigPathAware)) {
            return false;
        }
        VirtualFile config2 = this.getExternalConfig((ExternalConfigPathAware)externalData, externalData.getOwner());
        if (config2 == null) {
            return false;
        }
        ProjectSystemId externalSystemId = this.getSystemId(e);
        e.getPresentation().setText(ExternalSystemBundle.messagePointer((String)"action.open.config.text", (Object[])new Object[]{externalSystemId.getReadableName()}));
        e.getPresentation().setDescription(ExternalSystemBundle.messagePointer((String)"action.open.config.description", (Object[])new Object[]{externalSystemId.getReadableName()}));
        ExternalSystemUiAware uiAware = this.getExternalSystemUiAware(e);
        if (uiAware != null) {
            e.getPresentation().setIcon(uiAware.getProjectIcon());
        }
        return true;
    }

    @Override
    protected void perform(@NotNull Project project, @NotNull ProjectSystemId systemId, @NotNull ExternalConfigPathAware configPathAware, @NotNull AnActionEvent e) {
        VirtualFile configFile = this.getExternalConfig(configPathAware, systemId);
        if (configFile != null) {
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(project, configFile);
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, true);
        }
    }
}

