/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.model;

import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractRegistry<T> {
    @NotNull
    private final TIntObjectHashMap<T> myDataById = new TIntObjectHashMap();
    private transient TObjectIntHashMap<T> myIdsByData = new TObjectIntHashMap();

    @NotNull
    public T dataById(int id2) throws IllegalArgumentException {
        Object result2 = this.myDataById.get(id2);
        if (result2 == null) {
            throw new IllegalArgumentException("No data is registered for id " + id2);
        }
        return (T)result2;
    }

    public int getId(@NotNull T data2) throws IllegalStateException {
        if (this.myIdsByData == null) {
            throw new IllegalStateException(String.format("Can't register data '%s'. Reason: the %s registry is already sealed", data2, this.getClass().getName()));
        }
        int id2 = this.myIdsByData.get(data2);
        if (id2 <= 0) {
            id2 = this.myIdsByData.size() + 1;
            this.myDataById.put(id2, data2);
            this.myIdsByData.put(data2, id2);
        }
        return id2;
    }

    public int[] getAllIds() {
        int[] result2 = this.myDataById.keys();
        Arrays.sort(result2);
        return result2;
    }

    public int size() {
        return this.myDataById.size();
    }

    public void seal() {
        this.myIdsByData = null;
        this.myDataById.compact();
    }
}

