/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl.view;

import com.intellij.diagnostic.Dumpable;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.impl.TextDrawingCallback;
import com.intellij.openapi.editor.impl.view.CharWidthCache;
import com.intellij.openapi.editor.impl.view.EditorCoordinateMapper;
import com.intellij.openapi.editor.impl.view.EditorPainter;
import com.intellij.openapi.editor.impl.view.EditorSizeManager;
import com.intellij.openapi.editor.impl.view.FontLayoutService;
import com.intellij.openapi.editor.impl.view.LineLayout;
import com.intellij.openapi.editor.impl.view.LogicalPositionCache;
import com.intellij.openapi.editor.impl.view.SpecialCharacterFragment;
import com.intellij.openapi.editor.impl.view.TabFragment;
import com.intellij.openapi.editor.impl.view.TextLayoutCache;
import com.intellij.openapi.editor.impl.view.VisualLinesIterator;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class EditorView
implements TextDrawingCallback,
Disposable,
Dumpable,
HierarchyListener,
VisibleAreaListener {
    private static final Logger LOG = Logger.getInstance(EditorView.class);
    private static final Key<LineLayout> FOLD_REGION_TEXT_LAYOUT = Key.create((String)"text.layout");
    private final EditorImpl myEditor;
    private final DocumentEx myDocument;
    private final EditorPainter myPainter;
    private final EditorCoordinateMapper myMapper;
    private final EditorSizeManager mySizeManager;
    private final TextLayoutCache myTextLayoutCache;
    private final LogicalPositionCache myLogicalPositionCache;
    private final CharWidthCache myCharWidthCache;
    private final TabFragment myTabFragment;
    private FontRenderContext myFontRenderContext;
    private String myPrefixText;
    private LineLayout myPrefixLayout;
    private TextAttributes myPrefixAttributes;
    private int myBidiFlags;
    private float myPlainSpaceWidth;
    private int myLineHeight;
    private int myDescent;
    private int myCharHeight;
    private float myMaxCharWidth;
    private int myCapHeight;
    private int myTabSize;
    private int myTopOverhang;
    private int myBottomOverhang;
    private final Object myLock = new Object();

    public EditorView(EditorImpl editor) {
        this.myEditor = editor;
        this.myDocument = editor.getDocument();
        this.myPainter = new EditorPainter(this);
        this.myMapper = new EditorCoordinateMapper(this);
        this.mySizeManager = new EditorSizeManager(this);
        this.myTextLayoutCache = new TextLayoutCache(this);
        this.myLogicalPositionCache = new LogicalPositionCache(this);
        this.myCharWidthCache = new CharWidthCache(this);
        this.myTabFragment = new TabFragment(this);
        this.myEditor.getContentComponent().addHierarchyListener(this);
        this.myEditor.getScrollingModel().addVisibleAreaListener(this);
        Disposer.register((Disposable)this, (Disposable)this.myLogicalPositionCache);
        Disposer.register((Disposable)this, (Disposable)this.myTextLayoutCache);
        Disposer.register((Disposable)this, (Disposable)this.mySizeManager);
    }

    EditorImpl getEditor() {
        return this.myEditor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FontRenderContext getFontRenderContext() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myFontRenderContext;
        }
    }

    EditorSizeManager getSizeManager() {
        return this.mySizeManager;
    }

    TextLayoutCache getTextLayoutCache() {
        return this.myTextLayoutCache;
    }

    TabFragment getTabFragment() {
        return this.myTabFragment;
    }

    LogicalPositionCache getLogicalPositionCache() {
        return this.myLogicalPositionCache;
    }

    float getRightAlignmentLineStartX(int visualLine) {
        return this.myMapper.getRightAlignmentLineStartX(visualLine);
    }

    int getRightAlignmentMarginX() {
        return this.myMapper.getRightAlignmentMarginX();
    }

    public void dispose() {
        this.myEditor.getScrollingModel().removeVisibleAreaListener(this);
        this.myEditor.getContentComponent().removeHierarchyListener(this);
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if ((e.getChangeFlags() & 4L) != 0L && e.getComponent().isShowing()) {
            this.checkFontRenderContext(null);
        }
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent e) {
        this.checkFontRenderContext(null);
    }

    public int yToVisualLine(int y) {
        return this.myMapper.yToVisualLine(y);
    }

    public int visualLineToY(int line) {
        return this.myMapper.visualLineToY(line);
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int offset) {
        EditorView.assertIsReadAccess();
        return this.myMapper.offsetToLogicalPosition(offset);
    }

    public int logicalPositionToOffset(@NotNull LogicalPosition pos) {
        EditorView.assertIsReadAccess();
        return this.myMapper.logicalPositionToOffset(pos);
    }

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition pos, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.logicalToVisualPosition(pos, beforeSoftWrap);
    }

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition pos) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualToLogicalPosition(pos);
    }

    @NotNull
    public VisualPosition offsetToVisualPosition(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.offsetToVisualPosition(offset, leanTowardsLargerOffsets, beforeSoftWrap);
    }

    public int visualPositionToOffset(VisualPosition visualPosition) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualPositionToOffset(visualPosition);
    }

    public int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.offsetToVisualLine(offset, beforeSoftWrap);
    }

    public int visualLineToOffset(int visualLine) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualLineToOffset(visualLine);
    }

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D p) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.xyToVisualPosition(p);
    }

    @NotNull
    public Point2D visualPositionToXY(@NotNull VisualPosition pos) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.visualPositionToXY(pos);
    }

    @NotNull
    public Point2D offsetToXY(int offset, boolean leanTowardsLargerOffsets, boolean beforeSoftWrap) {
        EditorView.assertIsDispatchThread();
        this.assertNotInBulkMode();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.myMapper.offsetToXY(offset, leanTowardsLargerOffsets, beforeSoftWrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrefix(String prefixText, TextAttributes attributes) {
        EditorView.assertIsDispatchThread();
        this.myPrefixText = prefixText;
        Object object = this.myLock;
        synchronized (object) {
            this.myPrefixLayout = prefixText == null || prefixText.isEmpty() ? null : LineLayout.create(this, prefixText, attributes.getFontType());
        }
        this.myPrefixAttributes = attributes;
        this.mySizeManager.invalidateRange(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getPrefixTextWidthInPixels() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myPrefixLayout == null ? 0.0f : this.myPrefixLayout.getWidth();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LineLayout getPrefixLayout() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myPrefixLayout;
        }
    }

    TextAttributes getPrefixAttributes() {
        return this.myPrefixAttributes;
    }

    public void paint(Graphics2D g) {
        EditorView.assertIsDispatchThread();
        this.myEditor.getSoftWrapModel().prepareToMapping();
        this.checkFontRenderContext(g.getFontRenderContext());
        this.myPainter.paint(g);
    }

    public void repaintCarets() {
        EditorView.assertIsDispatchThread();
        this.myPainter.repaintCarets();
    }

    public Dimension getPreferredSize() {
        EditorView.assertIsDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.mySizeManager.getPreferredSize();
    }

    public int getPreferredWidth(int beginLine, int endLine) {
        EditorView.assertIsDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.mySizeManager.getPreferredWidth(beginLine, endLine);
    }

    public int getPreferredHeight() {
        EditorView.assertIsDispatchThread();
        assert (!this.myEditor.isPurePaintingMode());
        this.myEditor.getSoftWrapModel().prepareToMapping();
        return this.mySizeManager.getPreferredHeight();
    }

    public int getMaxWidthInRange(int startOffset, int endOffset) {
        EditorView.assertIsDispatchThread();
        int startVisualLine = this.offsetToVisualLine(startOffset, false);
        int endVisualLine = this.offsetToVisualLine(endOffset, true);
        return this.getMaxTextWidthInLineRange(startVisualLine, endVisualLine) + this.getInsets().left;
    }

    int getMaxTextWidthInLineRange(int startVisualLine, int endVisualLine) {
        this.myEditor.getSoftWrapModel().prepareToMapping();
        int maxWidth = 0;
        VisualLinesIterator iterator2 = new VisualLinesIterator(this.myEditor, startVisualLine);
        while (!iterator2.atEnd() && iterator2.getVisualLine() <= endVisualLine) {
            int width = this.mySizeManager.getVisualLineWidth(iterator2, false);
            maxWidth = Math.max(maxWidth, width);
            iterator2.advance();
        }
        return maxWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitSettings() {
        EditorView.assertIsDispatchThread();
        Object object = this.myLock;
        synchronized (object) {
            this.myPlainSpaceWidth = -1.0f;
            this.myTabSize = -1;
            this.setFontRenderContext(null);
        }
        switch (EditorSettingsExternalizable.getInstance().getBidiTextDirection()) {
            case LTR: {
                this.myBidiFlags = 0;
                break;
            }
            case RTL: {
                this.myBidiFlags = 1;
                break;
            }
            default: {
                this.myBidiFlags = -2;
            }
        }
        this.myLogicalPositionCache.reset(false);
        this.myTextLayoutCache.resetToDocumentSize(false);
        this.invalidateFoldRegionLayouts();
        this.myCharWidthCache.clear();
        this.setPrefix(this.myPrefixText, this.myPrefixAttributes);
        this.mySizeManager.reset();
    }

    public void invalidateRange(int startOffset, int endOffset) {
        EditorView.assertIsDispatchThread();
        int textLength = this.myDocument.getTextLength();
        if (startOffset > endOffset || startOffset >= textLength || endOffset < 0) {
            return;
        }
        int startLine = this.myDocument.getLineNumber(Math.max(0, startOffset));
        int endLine = this.myDocument.getLineNumber(Math.min(textLength, endOffset));
        this.myTextLayoutCache.invalidateLines(startLine, endLine);
        this.mySizeManager.invalidateRange(startOffset, endOffset);
    }

    public void reset() {
        EditorView.assertIsDispatchThread();
        this.myLogicalPositionCache.reset(true);
        this.myTextLayoutCache.resetToDocumentSize(true);
        this.mySizeManager.reset();
    }

    public boolean isRtlLocation(@NotNull VisualPosition visualPosition) {
        int offset;
        EditorView.assertIsDispatchThread();
        if (this.myDocument.getTextLength() == 0) {
            return false;
        }
        LogicalPosition logicalPosition = this.visualToLogicalPosition(visualPosition);
        if (!logicalPosition.equals((Object)this.offsetToLogicalPosition(offset = this.logicalPositionToOffset(logicalPosition)))) {
            return false;
        }
        if (this.myEditor.getSoftWrapModel().getSoftWrap(offset) != null) {
            VisualPosition beforeWrapPosition = this.offsetToVisualPosition(offset, true, true);
            if (visualPosition.line == beforeWrapPosition.line && (visualPosition.column > beforeWrapPosition.column || visualPosition.column == beforeWrapPosition.column && visualPosition.leansRight)) {
                return false;
            }
            VisualPosition afterWrapPosition = this.offsetToVisualPosition(offset, false, false);
            if (visualPosition.line == afterWrapPosition.line && (visualPosition.column < afterWrapPosition.column || visualPosition.column == afterWrapPosition.column && !visualPosition.leansRight)) {
                return false;
            }
        }
        int line = this.myDocument.getLineNumber(offset);
        LineLayout layout = this.myTextLayoutCache.getLineLayout(line);
        return layout.isRtlLocation(offset - this.myDocument.getLineStartOffset(line), logicalPosition.leansForward);
    }

    public boolean isAtBidiRunBoundary(@NotNull VisualPosition visualPosition) {
        EditorView.assertIsDispatchThread();
        int offset = this.visualPositionToOffset(visualPosition);
        int otherSideOffset = this.visualPositionToOffset(visualPosition.leanRight(!visualPosition.leansRight));
        return offset != otherSideOffset;
    }

    public int findNearestDirectionBoundary(int offset, boolean lookForward) {
        int lineStartOffset;
        EditorView.assertIsDispatchThread();
        int textLength = this.myDocument.getTextLength();
        if (textLength == 0 || offset < 0 || offset > textLength) {
            return -1;
        }
        int line = this.myDocument.getLineNumber(offset);
        LineLayout layout = this.myTextLayoutCache.getLineLayout(line);
        int relativeOffset = layout.findNearestDirectionBoundary(offset - (lineStartOffset = this.myDocument.getLineStartOffset(line)), lookForward);
        return relativeOffset < 0 ? -1 : lineStartOffset + relativeOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getPlainSpaceWidth() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myPlainSpaceWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNominalLineHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myLineHeight + this.myTopOverhang + this.myBottomOverhang;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLineHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myLineHeight;
        }
    }

    private float getVerticalScalingFactor() {
        if (this.myEditor.isOneLineMode()) {
            return 1.0f;
        }
        float lineSpacing = this.myEditor.getColorsScheme().getLineSpacing();
        return lineSpacing > 0.0f ? lineSpacing : 1.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDescent() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myDescent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCharHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myCharHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    float getMaxCharWidth() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myMaxCharWidth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAscent() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myLineHeight - this.myDescent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getCapHeight() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myCapHeight;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTopOverhang() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myTopOverhang;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBottomOverhang() {
        Object object = this.myLock;
        synchronized (object) {
            this.initMetricsIfNeeded();
            return this.myBottomOverhang;
        }
    }

    private void initMetricsIfNeeded() {
        int lineHeight;
        if (this.myPlainSpaceWidth >= 0.0f) {
            return;
        }
        Font font = this.myEditor.getColorsScheme().getFont(EditorFontType.PLAIN);
        FontMetrics fm = FontInfo.getFontMetrics(font, this.myFontRenderContext);
        float width = FontLayoutService.getInstance().charWidth2D(fm, 32);
        this.myPlainSpaceWidth = width > 0.0f ? width : 1.0f;
        this.myCharHeight = FontLayoutService.getInstance().charWidth(fm, 'a');
        float verticalScalingFactor = this.getVerticalScalingFactor();
        int fontMetricsHeight = FontLayoutService.getInstance().getHeight(fm);
        if (Registry.is((String)"editor.text.xcode.vertical.spacing")) {
            double delta;
            LineMetrics metrics = font.getLineMetrics("", this.myFontRenderContext);
            double height = Math.ceil(metrics.getHeight()) + (double)metrics.getLeading();
            int spacing = Math.round(height * (delta = (double)(verticalScalingFactor - 1.0f)) / 2.0) <= 1L ? (delta > 0.0 ? 2 : 0) : (int)Math.ceil(height * delta / 2.0) * 2;
            lineHeight = (int)Math.ceil(height) + spacing;
        } else if (Registry.is((String)"editor.text.vertical.spacing.correct.rounding")) {
            if (verticalScalingFactor == 1.0f) {
                lineHeight = fontMetricsHeight;
            } else {
                Font scaledFont = font.deriveFont((float)font.getSize() * verticalScalingFactor);
                FontMetrics scaledMetrics = FontInfo.getFontMetrics(scaledFont, this.myFontRenderContext);
                lineHeight = FontLayoutService.getInstance().getHeight(scaledMetrics);
            }
        } else {
            lineHeight = (int)Math.ceil((float)fontMetricsHeight * verticalScalingFactor);
        }
        this.myLineHeight = Math.max(1, lineHeight);
        int descent = FontLayoutService.getInstance().getDescent(fm);
        this.myDescent = descent + (this.myLineHeight - fontMetricsHeight) / 2;
        this.myTopOverhang = fontMetricsHeight - this.myLineHeight + this.myDescent - descent;
        this.myBottomOverhang = descent - this.myDescent;
        FontMetrics fmBI = FontInfo.getFontMetrics(this.myEditor.getColorsScheme().getFont(EditorFontType.BOLD_ITALIC), this.myFontRenderContext);
        this.myMaxCharWidth = FontLayoutService.getInstance().charWidth2D(fmBI, 87);
        this.myCapHeight = (int)font.createGlyphVector(this.myFontRenderContext, "H").getVisualBounds().getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTabSize() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myTabSize < 0) {
                this.myTabSize = EditorUtil.getTabSize(this.myEditor);
            }
            return this.myTabSize;
        }
    }

    private boolean setFontRenderContext(FontRenderContext context) {
        FontRenderContext contextToSet;
        FontRenderContext fontRenderContext = contextToSet = context == null ? FontInfo.getFontRenderContext(this.myEditor.getContentComponent()) : context;
        if (EditorView.areEqualContexts(this.myFontRenderContext, contextToSet)) {
            return false;
        }
        AffineTransform transform = contextToSet.getTransform();
        if (transform.getDeterminant() == 0.0) {
            LOG.error("Incorrect transform in FontRenderContext" + (context == null ? " obtained from component" : "") + ": " + transform);
            contextToSet = new FontRenderContext(new AffineTransform(), contextToSet.getAntiAliasingHint(), contextToSet.getFractionalMetricsHint());
        }
        this.myFontRenderContext = contextToSet.getFractionalMetricsHint() == this.myEditor.myFractionalMetricsHintValue ? contextToSet : new FontRenderContext(contextToSet.getTransform(), contextToSet.getAntiAliasingHint(), this.myEditor.myFractionalMetricsHintValue);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFontRenderContext(FontRenderContext context) {
        boolean contextUpdated = false;
        Object object = this.myLock;
        synchronized (object) {
            if (this.setFontRenderContext(context)) {
                this.myPlainSpaceWidth = -1.0f;
                contextUpdated = true;
            }
        }
        if (contextUpdated) {
            this.myTextLayoutCache.resetToDocumentSize(false);
            this.invalidateFoldRegionLayouts();
            this.myCharWidthCache.clear();
        }
    }

    private static boolean areEqualContexts(FontRenderContext c1, FontRenderContext c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.getTransform().equals(c2.getTransform()) && c1.getAntiAliasingHint().equals(c2.getAntiAliasingHint());
    }

    public int offsetToVisualColumnInFoldRegion(@NotNull FoldRegion region, int offset, boolean leanTowardsLargerOffsets) {
        if (offset < 0 || offset == 0 && !leanTowardsLargerOffsets) {
            return 0;
        }
        String text = region.getPlaceholderText();
        if (offset > text.length()) {
            offset = text.length();
            leanTowardsLargerOffsets = true;
        }
        int logicalColumn = LogicalPositionCache.calcColumn(text, 0, 0, offset, this.getTabSize());
        int maxColumn = 0;
        for (LineLayout.VisualFragment fragment : this.getFoldRegionLayout(region).getFragmentsInVisualOrder(0.0f)) {
            int startLC = fragment.getStartLogicalColumn();
            int endLC = fragment.getEndLogicalColumn();
            if (logicalColumn > startLC && logicalColumn < endLC || logicalColumn == startLC && leanTowardsLargerOffsets || logicalColumn == endLC && !leanTowardsLargerOffsets) {
                return fragment.logicalToVisualColumn(logicalColumn);
            }
            maxColumn = fragment.getEndVisualColumn();
        }
        return maxColumn;
    }

    public int visualColumnToOffsetInFoldRegion(@NotNull FoldRegion region, int visualColumn, boolean leansRight) {
        if (visualColumn < 0 || visualColumn == 0 && !leansRight) {
            return 0;
        }
        String text = region.getPlaceholderText();
        for (LineLayout.VisualFragment fragment : this.getFoldRegionLayout(region).getFragmentsInVisualOrder(0.0f)) {
            int startVC = fragment.getStartVisualColumn();
            int endVC = fragment.getEndVisualColumn();
            if (!(visualColumn > startVC && visualColumn < endVC || visualColumn == startVC && leansRight) && (visualColumn != endVC || leansRight)) continue;
            int logicalColumn = fragment.visualToLogicalColumn(visualColumn);
            return LogicalPositionCache.calcOffset(text, logicalColumn, 0, 0, text.length(), this.getTabSize());
        }
        return text.length();
    }

    LineLayout getFoldRegionLayout(FoldRegion foldRegion) {
        LineLayout layout = (LineLayout)foldRegion.getUserData(FOLD_REGION_TEXT_LAYOUT);
        if (layout == null) {
            TextAttributes placeholderAttributes = this.myEditor.getFoldingModel().getPlaceholderAttributes();
            layout = LineLayout.create(this, StringUtil.replace((String)foldRegion.getPlaceholderText(), (String)"\n", (String)" "), placeholderAttributes == null ? 0 : placeholderAttributes.getFontType());
            foldRegion.putUserData(FOLD_REGION_TEXT_LAYOUT, (Object)layout);
        }
        return layout;
    }

    private void invalidateFoldRegionLayouts() {
        for (FoldRegion region : this.myEditor.getFoldingModel().getAllFoldRegions()) {
            this.invalidateFoldRegionLayout(region);
        }
    }

    public void invalidateFoldRegionLayout(FoldRegion region) {
        region.putUserData(FOLD_REGION_TEXT_LAYOUT, null);
    }

    float getCodePointWidth(int codePoint, @JdkConstants.FontStyle int fontStyle) {
        SpecialCharacterFragment specialCharacterFragment;
        if (this.myEditor.getSettings().isShowingSpecialChars() && (specialCharacterFragment = SpecialCharacterFragment.create(this, codePoint, null, 0)) != null) {
            return specialCharacterFragment.visualColumnToX(0.0f, 1);
        }
        return this.myCharWidthCache.getCodePointWidth(codePoint, fontStyle);
    }

    Insets getInsets() {
        return this.myEditor.getContentComponent().getInsets();
    }

    int getBidiFlags() {
        return this.myBidiFlags;
    }

    private static void assertIsDispatchThread() {
        ApplicationManager.getApplication().assertIsDispatchThread();
    }

    private static void assertIsReadAccess() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
    }

    @Override
    public void drawChars(@NotNull Graphics g, char @NotNull [] data2, int start2, int end, int x, int y, Color color, FontInfo fontInfo) {
        this.myPainter.drawChars(g, data2, start2, end, x, y, color, fontInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String dumpState() {
        String prefixText = this.myPrefixText;
        TextAttributes prefixAttributes = this.myPrefixAttributes;
        Object object = this.myLock;
        synchronized (object) {
            return "[prefix text: " + prefixText + ", prefix attributes: " + prefixAttributes + ", space width: " + this.myPlainSpaceWidth + ", line height: " + this.myLineHeight + ", descent: " + this.myDescent + ", char height: " + this.myCharHeight + ", max char width: " + this.myMaxCharWidth + ", tab size: " + this.myTabSize + " ,size manager: " + this.mySizeManager.dumpState() + " ,logical position cache: " + this.myLogicalPositionCache.dumpState() + "]";
        }
    }

    public void validateState() {
        this.myLogicalPositionCache.validateState();
        this.mySizeManager.validateState();
    }

    private void assertNotInBulkMode() {
        if (this.myDocument instanceof DocumentImpl) {
            ((DocumentImpl)this.myDocument).assertNotInBulkUpdate();
        } else if (this.myDocument.isInBulkUpdate()) {
            throw new IllegalStateException("Current operation is not permitted in bulk mode");
        }
        if (this.myEditor.getInlayModel().isInBatchMode()) {
            throw new IllegalStateException("Current operation is not permitted during batch inlay update");
        }
    }
}

