/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;

public class TextChangeImpl
implements TextChange {
    private final StringBuilder myText = new StringBuilder();
    private char[] myChars;
    private int myStart;
    private int myEnd;

    public TextChangeImpl(@NotNull CharSequence text, int start2) throws IllegalArgumentException {
        this(text, start2, start2);
    }

    public TextChangeImpl(@NotNull CharSequence text, int start2, int end) throws IllegalArgumentException {
        if (start2 < 0) {
            throw new IllegalArgumentException(String.format("Can't construct new %s object. Reason: given start index (%d) is negative. End index: %d, text: '%s'", this.getClass().getName(), start2, end, text));
        }
        if (end < start2) {
            throw new IllegalArgumentException(String.format("Can't construct new %s object. Reason: given end index (%d) is less than start index (%d). Text: '%s'", this.getClass().getName(), end, start2, text));
        }
        this.myText.append(text);
        this.myStart = start2;
        this.myEnd = end;
    }

    public int getStart() {
        return this.myStart;
    }

    public void setStart(int start2) {
        assert (start2 >= 0) : start2;
        this.myStart = start2;
    }

    public int getEnd() {
        return this.myEnd;
    }

    public void setEnd(int end) {
        this.myEnd = end;
    }

    @NotNull
    public CharSequence getText() {
        return this.myText;
    }

    public char @NotNull [] getChars() {
        char[] chars = this.myChars;
        if (chars == null) {
            this.myChars = chars = CharArrayUtil.fromSequence((CharSequence)this.myText);
        }
        return chars;
    }

    public int getDiff() {
        return this.myText.length() - this.myEnd + this.myStart;
    }

    public void advance(int offset) throws IllegalArgumentException {
        if (offset == 0) {
            return;
        }
        int newStart = this.myStart + offset;
        if (newStart < 0) {
            throw new IllegalArgumentException(String.format("Can't apply given offset (%d) to the current text change object (%s). Reason: new start index becomes negative after that (%d)", offset, this, newStart));
        }
        this.setStart(newStart);
        this.setEnd(this.myEnd + offset);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextChangeImpl that = (TextChangeImpl)o;
        return this.myStart == that.myStart && this.myEnd == that.myEnd && StringUtil.equals((CharSequence)this.myText, (CharSequence)that.myText);
    }

    public int hashCode() {
        int result2 = StringUtil.stringHashCode((CharSequence)this.myText);
        result2 = 31 * result2 + this.myStart;
        return 31 * result2 + this.myEnd;
    }

    public String toString() {
        return String.format("%d-%d: '%s'", this.myStart, this.myEnd, this.myText);
    }
}

