/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCopyPasteHelper;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SelectionModelImpl
implements SelectionModel {
    private static final Logger LOG = Logger.getInstance(SelectionModelImpl.class);
    private final List<SelectionListener> mySelectionListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final EditorImpl myEditor;
    private TextAttributes myTextAttributes;

    public SelectionModelImpl(EditorImpl editor) {
        this.myEditor = editor;
    }

    public boolean isUnknownDirection() {
        return this.myEditor.getCaretModel().getCurrentCaret().isUnknownDirection();
    }

    public void setUnknownDirection(boolean unknownDirection) {
        this.myEditor.getCaretModel().getCurrentCaret().setUnknownDirection(unknownDirection);
    }

    @NotNull
    public Editor getEditor() {
        return this.myEditor;
    }

    void fireSelectionChanged(SelectionEvent event) {
        TextRange[] oldRanges = event.getOldRanges();
        TextRange[] newRanges = event.getNewRanges();
        int count = Math.min(oldRanges.length, newRanges.length);
        for (int i2 = 0; i2 < count; ++i2) {
            TextRange oldRange = oldRanges[i2];
            TextRange newRange = newRanges[i2];
            int oldSelectionStart = oldRange.getStartOffset();
            int startOffset = newRange.getStartOffset();
            int oldSelectionEnd = oldRange.getEndOffset();
            int endOffset = newRange.getEndOffset();
            this.myEditor.repaint(Math.min(oldSelectionStart, startOffset), Math.max(oldSelectionStart, startOffset), false);
            this.myEditor.repaint(Math.min(oldSelectionEnd, endOffset), Math.max(oldSelectionEnd, endOffset), false);
        }
        TextRange[] remaining = oldRanges.length < newRanges.length ? newRanges : oldRanges;
        for (int i3 = count; i3 < remaining.length; ++i3) {
            TextRange range2 = remaining[i3];
            this.myEditor.repaint(range2.getStartOffset(), range2.getEndOffset(), false);
        }
        this.broadcastSelectionEvent(event);
    }

    private void broadcastSelectionEvent(SelectionEvent event) {
        for (SelectionListener listener2 : this.mySelectionListeners) {
            try {
                listener2.selectionChanged(event);
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
            }
        }
    }

    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        List caretStates = EditorModificationUtil.calcBlockSelectionState((Editor)this.myEditor, (LogicalPosition)blockStart, (LogicalPosition)blockEnd);
        this.myEditor.getCaretModel().setCaretsAndSelections(caretStates);
    }

    public int @NotNull [] getBlockSelectionStarts() {
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        int[] result2 = new int[carets.size()];
        int i2 = 0;
        for (Caret caret : carets) {
            result2[i2++] = caret.getSelectionStart();
        }
        return result2;
    }

    public int @NotNull [] getBlockSelectionEnds() {
        List<Caret> carets = this.myEditor.getCaretModel().getAllCarets();
        int[] result2 = new int[carets.size()];
        int i2 = 0;
        for (Caret caret : carets) {
            result2[i2++] = caret.getSelectionEnd();
        }
        return result2;
    }

    public void addSelectionListener(@NotNull SelectionListener listener2) {
        this.mySelectionListeners.add(listener2);
    }

    public void removeSelectionListener(@NotNull SelectionListener listener2) {
        boolean success = this.mySelectionListeners.remove(listener2);
        LOG.assertTrue(success);
    }

    public static void doSelectLineAtCaret(Caret caret) {
        int lineNumber = caret.getLogicalPosition().line;
        Editor editor = caret.getEditor();
        Document document = editor.getDocument();
        if (lineNumber >= document.getLineCount()) {
            return;
        }
        Pair<LogicalPosition, LogicalPosition> lines = EditorUtil.calcCaretLineRange(caret);
        LogicalPosition lineStart = (LogicalPosition)lines.first;
        LogicalPosition nextLineStart = (LogicalPosition)lines.second;
        int start2 = editor.logicalPositionToOffset(lineStart);
        int end = editor.logicalPositionToOffset(nextLineStart);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        caret.removeSelection();
        caret.setSelection(start2, end);
    }

    public void copySelectionToClipboard() {
        EditorCopyPasteHelper.getInstance().copySelectionToClipboard((Editor)this.myEditor);
    }

    public TextAttributes getTextAttributes() {
        if (this.myTextAttributes == null) {
            TextAttributes textAttributes = new TextAttributes();
            EditorColorsScheme scheme = this.myEditor.getColorsScheme();
            textAttributes.setForegroundColor(scheme.getColor(EditorColors.SELECTION_FOREGROUND_COLOR));
            textAttributes.setBackgroundColor(scheme.getColor(EditorColors.SELECTION_BACKGROUND_COLOR));
            this.myTextAttributes = textAttributes;
        }
        return this.myTextAttributes;
    }

    public void reinitSettings() {
        this.myTextAttributes = null;
    }
}

